/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditional formatting options of a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPIConditionalFormattingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<KPIConditionalFormattingOption.Builder, KPIConditionalFormattingOption> {
    private static final SdkField<KPIPrimaryValueConditionalFormatting> PRIMARY_VALUE_FIELD = SdkField
            .<KPIPrimaryValueConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("PrimaryValue")
            .getter(getter(KPIConditionalFormattingOption::primaryValue)).setter(setter(Builder::primaryValue))
            .constructor(KPIPrimaryValueConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValue").build()).build();

    private static final SdkField<KPIProgressBarConditionalFormatting> PROGRESS_BAR_FIELD = SdkField
            .<KPIProgressBarConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("ProgressBar")
            .getter(getter(KPIConditionalFormattingOption::progressBar)).setter(setter(Builder::progressBar))
            .constructor(KPIProgressBarConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressBar").build()).build();

    private static final SdkField<KPIActualValueConditionalFormatting> ACTUAL_VALUE_FIELD = SdkField
            .<KPIActualValueConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("ActualValue")
            .getter(getter(KPIConditionalFormattingOption::actualValue)).setter(setter(Builder::actualValue))
            .constructor(KPIActualValueConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()).build();

    private static final SdkField<KPIComparisonValueConditionalFormatting> COMPARISON_VALUE_FIELD = SdkField
            .<KPIComparisonValueConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("ComparisonValue")
            .getter(getter(KPIConditionalFormattingOption::comparisonValue)).setter(setter(Builder::comparisonValue))
            .constructor(KPIComparisonValueConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_VALUE_FIELD,
            PROGRESS_BAR_FIELD, ACTUAL_VALUE_FIELD, COMPARISON_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KPIPrimaryValueConditionalFormatting primaryValue;

    private final KPIProgressBarConditionalFormatting progressBar;

    private final KPIActualValueConditionalFormatting actualValue;

    private final KPIComparisonValueConditionalFormatting comparisonValue;

    private KPIConditionalFormattingOption(BuilderImpl builder) {
        this.primaryValue = builder.primaryValue;
        this.progressBar = builder.progressBar;
        this.actualValue = builder.actualValue;
        this.comparisonValue = builder.comparisonValue;
    }

    /**
     * <p>
     * The conditional formatting for the primary value of a KPI visual.
     * </p>
     * 
     * @return The conditional formatting for the primary value of a KPI visual.
     */
    public final KPIPrimaryValueConditionalFormatting primaryValue() {
        return primaryValue;
    }

    /**
     * <p>
     * The conditional formatting for the progress bar of a KPI visual.
     * </p>
     * 
     * @return The conditional formatting for the progress bar of a KPI visual.
     */
    public final KPIProgressBarConditionalFormatting progressBar() {
        return progressBar;
    }

    /**
     * <p>
     * The conditional formatting for the actual value of a KPI visual.
     * </p>
     * 
     * @return The conditional formatting for the actual value of a KPI visual.
     */
    public final KPIActualValueConditionalFormatting actualValue() {
        return actualValue;
    }

    /**
     * <p>
     * The conditional formatting for the comparison value of a KPI visual.
     * </p>
     * 
     * @return The conditional formatting for the comparison value of a KPI visual.
     */
    public final KPIComparisonValueConditionalFormatting comparisonValue() {
        return comparisonValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(progressBar());
        hashCode = 31 * hashCode + Objects.hashCode(actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIConditionalFormattingOption)) {
            return false;
        }
        KPIConditionalFormattingOption other = (KPIConditionalFormattingOption) obj;
        return Objects.equals(primaryValue(), other.primaryValue()) && Objects.equals(progressBar(), other.progressBar())
                && Objects.equals(actualValue(), other.actualValue())
                && Objects.equals(comparisonValue(), other.comparisonValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPIConditionalFormattingOption").add("PrimaryValue", primaryValue())
                .add("ProgressBar", progressBar()).add("ActualValue", actualValue()).add("ComparisonValue", comparisonValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryValue":
            return Optional.ofNullable(clazz.cast(primaryValue()));
        case "ProgressBar":
            return Optional.ofNullable(clazz.cast(progressBar()));
        case "ActualValue":
            return Optional.ofNullable(clazz.cast(actualValue()));
        case "ComparisonValue":
            return Optional.ofNullable(clazz.cast(comparisonValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryValue", PRIMARY_VALUE_FIELD);
        map.put("ProgressBar", PROGRESS_BAR_FIELD);
        map.put("ActualValue", ACTUAL_VALUE_FIELD);
        map.put("ComparisonValue", COMPARISON_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIConditionalFormattingOption, T> g) {
        return obj -> g.apply((KPIConditionalFormattingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPIConditionalFormattingOption> {
        /**
         * <p>
         * The conditional formatting for the primary value of a KPI visual.
         * </p>
         * 
         * @param primaryValue
         *        The conditional formatting for the primary value of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValue(KPIPrimaryValueConditionalFormatting primaryValue);

        /**
         * <p>
         * The conditional formatting for the primary value of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KPIPrimaryValueConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link KPIPrimaryValueConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIPrimaryValueConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #primaryValue(KPIPrimaryValueConditionalFormatting)}.
         * 
         * @param primaryValue
         *        a consumer that will call methods on {@link KPIPrimaryValueConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValue(KPIPrimaryValueConditionalFormatting)
         */
        default Builder primaryValue(Consumer<KPIPrimaryValueConditionalFormatting.Builder> primaryValue) {
            return primaryValue(KPIPrimaryValueConditionalFormatting.builder().applyMutation(primaryValue).build());
        }

        /**
         * <p>
         * The conditional formatting for the progress bar of a KPI visual.
         * </p>
         * 
         * @param progressBar
         *        The conditional formatting for the progress bar of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressBar(KPIProgressBarConditionalFormatting progressBar);

        /**
         * <p>
         * The conditional formatting for the progress bar of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KPIProgressBarConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link KPIProgressBarConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIProgressBarConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #progressBar(KPIProgressBarConditionalFormatting)}.
         * 
         * @param progressBar
         *        a consumer that will call methods on {@link KPIProgressBarConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressBar(KPIProgressBarConditionalFormatting)
         */
        default Builder progressBar(Consumer<KPIProgressBarConditionalFormatting.Builder> progressBar) {
            return progressBar(KPIProgressBarConditionalFormatting.builder().applyMutation(progressBar).build());
        }

        /**
         * <p>
         * The conditional formatting for the actual value of a KPI visual.
         * </p>
         * 
         * @param actualValue
         *        The conditional formatting for the actual value of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualValue(KPIActualValueConditionalFormatting actualValue);

        /**
         * <p>
         * The conditional formatting for the actual value of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KPIActualValueConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link KPIActualValueConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIActualValueConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #actualValue(KPIActualValueConditionalFormatting)}.
         * 
         * @param actualValue
         *        a consumer that will call methods on {@link KPIActualValueConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualValue(KPIActualValueConditionalFormatting)
         */
        default Builder actualValue(Consumer<KPIActualValueConditionalFormatting.Builder> actualValue) {
            return actualValue(KPIActualValueConditionalFormatting.builder().applyMutation(actualValue).build());
        }

        /**
         * <p>
         * The conditional formatting for the comparison value of a KPI visual.
         * </p>
         * 
         * @param comparisonValue
         *        The conditional formatting for the comparison value of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonValue(KPIComparisonValueConditionalFormatting comparisonValue);

        /**
         * <p>
         * The conditional formatting for the comparison value of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KPIComparisonValueConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link KPIComparisonValueConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIComparisonValueConditionalFormatting.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #comparisonValue(KPIComparisonValueConditionalFormatting)}.
         * 
         * @param comparisonValue
         *        a consumer that will call methods on {@link KPIComparisonValueConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparisonValue(KPIComparisonValueConditionalFormatting)
         */
        default Builder comparisonValue(Consumer<KPIComparisonValueConditionalFormatting.Builder> comparisonValue) {
            return comparisonValue(KPIComparisonValueConditionalFormatting.builder().applyMutation(comparisonValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KPIPrimaryValueConditionalFormatting primaryValue;

        private KPIProgressBarConditionalFormatting progressBar;

        private KPIActualValueConditionalFormatting actualValue;

        private KPIComparisonValueConditionalFormatting comparisonValue;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIConditionalFormattingOption model) {
            primaryValue(model.primaryValue);
            progressBar(model.progressBar);
            actualValue(model.actualValue);
            comparisonValue(model.comparisonValue);
        }

        public final KPIPrimaryValueConditionalFormatting.Builder getPrimaryValue() {
            return primaryValue != null ? primaryValue.toBuilder() : null;
        }

        public final void setPrimaryValue(KPIPrimaryValueConditionalFormatting.BuilderImpl primaryValue) {
            this.primaryValue = primaryValue != null ? primaryValue.build() : null;
        }

        @Override
        public final Builder primaryValue(KPIPrimaryValueConditionalFormatting primaryValue) {
            this.primaryValue = primaryValue;
            return this;
        }

        public final KPIProgressBarConditionalFormatting.Builder getProgressBar() {
            return progressBar != null ? progressBar.toBuilder() : null;
        }

        public final void setProgressBar(KPIProgressBarConditionalFormatting.BuilderImpl progressBar) {
            this.progressBar = progressBar != null ? progressBar.build() : null;
        }

        @Override
        public final Builder progressBar(KPIProgressBarConditionalFormatting progressBar) {
            this.progressBar = progressBar;
            return this;
        }

        public final KPIActualValueConditionalFormatting.Builder getActualValue() {
            return actualValue != null ? actualValue.toBuilder() : null;
        }

        public final void setActualValue(KPIActualValueConditionalFormatting.BuilderImpl actualValue) {
            this.actualValue = actualValue != null ? actualValue.build() : null;
        }

        @Override
        public final Builder actualValue(KPIActualValueConditionalFormatting actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final KPIComparisonValueConditionalFormatting.Builder getComparisonValue() {
            return comparisonValue != null ? comparisonValue.toBuilder() : null;
        }

        public final void setComparisonValue(KPIComparisonValueConditionalFormatting.BuilderImpl comparisonValue) {
            this.comparisonValue = comparisonValue != null ? comparisonValue.build() : null;
        }

        @Override
        public final Builder comparisonValue(KPIComparisonValueConditionalFormatting comparisonValue) {
            this.comparisonValue = comparisonValue;
            return this;
        }

        @Override
        public KPIConditionalFormattingOption build() {
            return new KPIConditionalFormattingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
