/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>InvalidTopicReviewedAnswer</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidTopicReviewedAnswer implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidTopicReviewedAnswer.Builder, InvalidTopicReviewedAnswer> {
    private static final SdkField<String> ANSWER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnswerId").getter(getter(InvalidTopicReviewedAnswer::answerId)).setter(setter(Builder::answerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerId").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(InvalidTopicReviewedAnswer::errorAsString)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANSWER_ID_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String answerId;

    private final String error;

    private InvalidTopicReviewedAnswer(BuilderImpl builder) {
        this.answerId = builder.answerId;
        this.error = builder.error;
    }

    /**
     * <p>
     * The answer ID for the <code>InvalidTopicReviewedAnswer</code>.
     * </p>
     * 
     * @return The answer ID for the <code>InvalidTopicReviewedAnswer</code>.
     */
    public final String answerId() {
        return answerId;
    }

    /**
     * <p>
     * The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link ReviewedAnswerErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
     * @see ReviewedAnswerErrorCode
     */
    public final ReviewedAnswerErrorCode error() {
        return ReviewedAnswerErrorCode.fromValue(error);
    }

    /**
     * <p>
     * The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link ReviewedAnswerErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
     * @see ReviewedAnswerErrorCode
     */
    public final String errorAsString() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(answerId());
        hashCode = 31 * hashCode + Objects.hashCode(errorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidTopicReviewedAnswer)) {
            return false;
        }
        InvalidTopicReviewedAnswer other = (InvalidTopicReviewedAnswer) obj;
        return Objects.equals(answerId(), other.answerId()) && Objects.equals(errorAsString(), other.errorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidTopicReviewedAnswer").add("AnswerId", answerId()).add("Error", errorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnswerId":
            return Optional.ofNullable(clazz.cast(answerId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(errorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnswerId", ANSWER_ID_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidTopicReviewedAnswer, T> g) {
        return obj -> g.apply((InvalidTopicReviewedAnswer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidTopicReviewedAnswer> {
        /**
         * <p>
         * The answer ID for the <code>InvalidTopicReviewedAnswer</code>.
         * </p>
         * 
         * @param answerId
         *        The answer ID for the <code>InvalidTopicReviewedAnswer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerId(String answerId);

        /**
         * <p>
         * The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
         * </p>
         * 
         * @param error
         *        The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
         * @see ReviewedAnswerErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewedAnswerErrorCode
         */
        Builder error(String error);

        /**
         * <p>
         * The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
         * </p>
         * 
         * @param error
         *        The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.
         * @see ReviewedAnswerErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewedAnswerErrorCode
         */
        Builder error(ReviewedAnswerErrorCode error);
    }

    static final class BuilderImpl implements Builder {
        private String answerId;

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidTopicReviewedAnswer model) {
            answerId(model.answerId);
            error(model.error);
        }

        public final String getAnswerId() {
            return answerId;
        }

        public final void setAnswerId(String answerId) {
            this.answerId = answerId;
        }

        @Override
        public final Builder answerId(String answerId) {
            this.answerId = answerId;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(ReviewedAnswerErrorCode error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        @Override
        public InvalidTopicReviewedAnswer build() {
            return new InvalidTopicReviewedAnswer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
