/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logo image configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageConfiguration.Builder, ImageConfiguration> {
    private static final SdkField<ImageSource> SOURCE_FIELD = SdkField.<ImageSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(ImageConfiguration::source)).setter(setter(Builder::source))
            .constructor(ImageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageSource source;

    private ImageConfiguration(BuilderImpl builder) {
        this.source = builder.source;
    }

    /**
     * <p>
     * The source of the image.
     * </p>
     * 
     * @return The source of the image.
     */
    public final ImageSource source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfiguration)) {
            return false;
        }
        ImageConfiguration other = (ImageConfiguration) obj;
        return Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageConfiguration").add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageConfiguration, T> g) {
        return obj -> g.apply((ImageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageConfiguration> {
        /**
         * <p>
         * The source of the image.
         * </p>
         * 
         * @param source
         *        The source of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ImageSource source);

        /**
         * <p>
         * The source of the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSource.Builder} avoiding the need to
         * create one manually via {@link ImageSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(ImageSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ImageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ImageSource)
         */
        default Builder source(Consumer<ImageSource.Builder> source) {
            return source(ImageSource.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfiguration model) {
            source(model.source);
        }

        public final ImageSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ImageSource source) {
            this.source = source;
            return this;
        }

        @Override
        public ImageConfiguration build() {
            return new ImageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
