/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a histogram.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistogramFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<HistogramFieldWells.Builder, HistogramFieldWells> {
    private static final SdkField<HistogramAggregatedFieldWells> HISTOGRAM_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<HistogramAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("HistogramAggregatedFieldWells")
            .getter(getter(HistogramFieldWells::histogramAggregatedFieldWells))
            .setter(setter(Builder::histogramAggregatedFieldWells))
            .constructor(HistogramAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistogramAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HISTOGRAM_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HistogramAggregatedFieldWells histogramAggregatedFieldWells;

    private HistogramFieldWells(BuilderImpl builder) {
        this.histogramAggregatedFieldWells = builder.histogramAggregatedFieldWells;
    }

    /**
     * <p>
     * The field well configuration of a histogram.
     * </p>
     * 
     * @return The field well configuration of a histogram.
     */
    public final HistogramAggregatedFieldWells histogramAggregatedFieldWells() {
        return histogramAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(histogramAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistogramFieldWells)) {
            return false;
        }
        HistogramFieldWells other = (HistogramFieldWells) obj;
        return Objects.equals(histogramAggregatedFieldWells(), other.histogramAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HistogramFieldWells").add("HistogramAggregatedFieldWells", histogramAggregatedFieldWells())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HistogramAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(histogramAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HistogramAggregatedFieldWells", HISTOGRAM_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HistogramFieldWells, T> g) {
        return obj -> g.apply((HistogramFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistogramFieldWells> {
        /**
         * <p>
         * The field well configuration of a histogram.
         * </p>
         * 
         * @param histogramAggregatedFieldWells
         *        The field well configuration of a histogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder histogramAggregatedFieldWells(HistogramAggregatedFieldWells histogramAggregatedFieldWells);

        /**
         * <p>
         * The field well configuration of a histogram.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistogramAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link HistogramAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistogramAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #histogramAggregatedFieldWells(HistogramAggregatedFieldWells)}.
         * 
         * @param histogramAggregatedFieldWells
         *        a consumer that will call methods on {@link HistogramAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #histogramAggregatedFieldWells(HistogramAggregatedFieldWells)
         */
        default Builder histogramAggregatedFieldWells(
                Consumer<HistogramAggregatedFieldWells.Builder> histogramAggregatedFieldWells) {
            return histogramAggregatedFieldWells(HistogramAggregatedFieldWells.builder()
                    .applyMutation(histogramAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HistogramAggregatedFieldWells histogramAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(HistogramFieldWells model) {
            histogramAggregatedFieldWells(model.histogramAggregatedFieldWells);
        }

        public final HistogramAggregatedFieldWells.Builder getHistogramAggregatedFieldWells() {
            return histogramAggregatedFieldWells != null ? histogramAggregatedFieldWells.toBuilder() : null;
        }

        public final void setHistogramAggregatedFieldWells(HistogramAggregatedFieldWells.BuilderImpl histogramAggregatedFieldWells) {
            this.histogramAggregatedFieldWells = histogramAggregatedFieldWells != null ? histogramAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder histogramAggregatedFieldWells(HistogramAggregatedFieldWells histogramAggregatedFieldWells) {
            this.histogramAggregatedFieldWells = histogramAggregatedFieldWells;
            return this;
        }

        @Override
        public HistogramFieldWells build() {
            return new HistogramFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
