/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the presentation of histogram bins.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistogramBinOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<HistogramBinOptions.Builder, HistogramBinOptions> {
    private static final SdkField<String> SELECTED_BIN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectedBinType").getter(getter(HistogramBinOptions::selectedBinTypeAsString))
            .setter(setter(Builder::selectedBinType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedBinType").build()).build();

    private static final SdkField<BinCountOptions> BIN_COUNT_FIELD = SdkField.<BinCountOptions> builder(MarshallingType.SDK_POJO)
            .memberName("BinCount").getter(getter(HistogramBinOptions::binCount)).setter(setter(Builder::binCount))
            .constructor(BinCountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinCount").build()).build();

    private static final SdkField<BinWidthOptions> BIN_WIDTH_FIELD = SdkField.<BinWidthOptions> builder(MarshallingType.SDK_POJO)
            .memberName("BinWidth").getter(getter(HistogramBinOptions::binWidth)).setter(setter(Builder::binWidth))
            .constructor(BinWidthOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinWidth").build()).build();

    private static final SdkField<Double> START_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StartValue").getter(getter(HistogramBinOptions::startValue)).setter(setter(Builder::startValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_BIN_TYPE_FIELD,
            BIN_COUNT_FIELD, BIN_WIDTH_FIELD, START_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String selectedBinType;

    private final BinCountOptions binCount;

    private final BinWidthOptions binWidth;

    private final Double startValue;

    private HistogramBinOptions(BuilderImpl builder) {
        this.selectedBinType = builder.selectedBinType;
        this.binCount = builder.binCount;
        this.binWidth = builder.binWidth;
        this.startValue = builder.startValue;
    }

    /**
     * <p>
     * The options that determine the selected bin type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectedBinType}
     * will return {@link HistogramBinType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selectedBinTypeAsString}.
     * </p>
     * 
     * @return The options that determine the selected bin type.
     * @see HistogramBinType
     */
    public final HistogramBinType selectedBinType() {
        return HistogramBinType.fromValue(selectedBinType);
    }

    /**
     * <p>
     * The options that determine the selected bin type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectedBinType}
     * will return {@link HistogramBinType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selectedBinTypeAsString}.
     * </p>
     * 
     * @return The options that determine the selected bin type.
     * @see HistogramBinType
     */
    public final String selectedBinTypeAsString() {
        return selectedBinType;
    }

    /**
     * <p>
     * The options that determine the bin count of a histogram.
     * </p>
     * 
     * @return The options that determine the bin count of a histogram.
     */
    public final BinCountOptions binCount() {
        return binCount;
    }

    /**
     * <p>
     * The options that determine the bin width of a histogram.
     * </p>
     * 
     * @return The options that determine the bin width of a histogram.
     */
    public final BinWidthOptions binWidth() {
        return binWidth;
    }

    /**
     * <p>
     * The options that determine the bin start value.
     * </p>
     * 
     * @return The options that determine the bin start value.
     */
    public final Double startValue() {
        return startValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectedBinTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(binCount());
        hashCode = 31 * hashCode + Objects.hashCode(binWidth());
        hashCode = 31 * hashCode + Objects.hashCode(startValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistogramBinOptions)) {
            return false;
        }
        HistogramBinOptions other = (HistogramBinOptions) obj;
        return Objects.equals(selectedBinTypeAsString(), other.selectedBinTypeAsString())
                && Objects.equals(binCount(), other.binCount()) && Objects.equals(binWidth(), other.binWidth())
                && Objects.equals(startValue(), other.startValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HistogramBinOptions").add("SelectedBinType", selectedBinTypeAsString())
                .add("BinCount", binCount()).add("BinWidth", binWidth()).add("StartValue", startValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedBinType":
            return Optional.ofNullable(clazz.cast(selectedBinTypeAsString()));
        case "BinCount":
            return Optional.ofNullable(clazz.cast(binCount()));
        case "BinWidth":
            return Optional.ofNullable(clazz.cast(binWidth()));
        case "StartValue":
            return Optional.ofNullable(clazz.cast(startValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SelectedBinType", SELECTED_BIN_TYPE_FIELD);
        map.put("BinCount", BIN_COUNT_FIELD);
        map.put("BinWidth", BIN_WIDTH_FIELD);
        map.put("StartValue", START_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HistogramBinOptions, T> g) {
        return obj -> g.apply((HistogramBinOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistogramBinOptions> {
        /**
         * <p>
         * The options that determine the selected bin type.
         * </p>
         * 
         * @param selectedBinType
         *        The options that determine the selected bin type.
         * @see HistogramBinType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistogramBinType
         */
        Builder selectedBinType(String selectedBinType);

        /**
         * <p>
         * The options that determine the selected bin type.
         * </p>
         * 
         * @param selectedBinType
         *        The options that determine the selected bin type.
         * @see HistogramBinType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistogramBinType
         */
        Builder selectedBinType(HistogramBinType selectedBinType);

        /**
         * <p>
         * The options that determine the bin count of a histogram.
         * </p>
         * 
         * @param binCount
         *        The options that determine the bin count of a histogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binCount(BinCountOptions binCount);

        /**
         * <p>
         * The options that determine the bin count of a histogram.
         * </p>
         * This is a convenience method that creates an instance of the {@link BinCountOptions.Builder} avoiding the
         * need to create one manually via {@link BinCountOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BinCountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #binCount(BinCountOptions)}.
         * 
         * @param binCount
         *        a consumer that will call methods on {@link BinCountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #binCount(BinCountOptions)
         */
        default Builder binCount(Consumer<BinCountOptions.Builder> binCount) {
            return binCount(BinCountOptions.builder().applyMutation(binCount).build());
        }

        /**
         * <p>
         * The options that determine the bin width of a histogram.
         * </p>
         * 
         * @param binWidth
         *        The options that determine the bin width of a histogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binWidth(BinWidthOptions binWidth);

        /**
         * <p>
         * The options that determine the bin width of a histogram.
         * </p>
         * This is a convenience method that creates an instance of the {@link BinWidthOptions.Builder} avoiding the
         * need to create one manually via {@link BinWidthOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BinWidthOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #binWidth(BinWidthOptions)}.
         * 
         * @param binWidth
         *        a consumer that will call methods on {@link BinWidthOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #binWidth(BinWidthOptions)
         */
        default Builder binWidth(Consumer<BinWidthOptions.Builder> binWidth) {
            return binWidth(BinWidthOptions.builder().applyMutation(binWidth).build());
        }

        /**
         * <p>
         * The options that determine the bin start value.
         * </p>
         * 
         * @param startValue
         *        The options that determine the bin start value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startValue(Double startValue);
    }

    static final class BuilderImpl implements Builder {
        private String selectedBinType;

        private BinCountOptions binCount;

        private BinWidthOptions binWidth;

        private Double startValue;

        private BuilderImpl() {
        }

        private BuilderImpl(HistogramBinOptions model) {
            selectedBinType(model.selectedBinType);
            binCount(model.binCount);
            binWidth(model.binWidth);
            startValue(model.startValue);
        }

        public final String getSelectedBinType() {
            return selectedBinType;
        }

        public final void setSelectedBinType(String selectedBinType) {
            this.selectedBinType = selectedBinType;
        }

        @Override
        public final Builder selectedBinType(String selectedBinType) {
            this.selectedBinType = selectedBinType;
            return this;
        }

        @Override
        public final Builder selectedBinType(HistogramBinType selectedBinType) {
            this.selectedBinType(selectedBinType == null ? null : selectedBinType.toString());
            return this;
        }

        public final BinCountOptions.Builder getBinCount() {
            return binCount != null ? binCount.toBuilder() : null;
        }

        public final void setBinCount(BinCountOptions.BuilderImpl binCount) {
            this.binCount = binCount != null ? binCount.build() : null;
        }

        @Override
        public final Builder binCount(BinCountOptions binCount) {
            this.binCount = binCount;
            return this;
        }

        public final BinWidthOptions.Builder getBinWidth() {
            return binWidth != null ? binWidth.toBuilder() : null;
        }

        public final void setBinWidth(BinWidthOptions.BuilderImpl binWidth) {
            this.binWidth = binWidth != null ? binWidth.build() : null;
        }

        @Override
        public final Builder binWidth(BinWidthOptions binWidth) {
            this.binWidth = binWidth;
            return this;
        }

        public final Double getStartValue() {
            return startValue;
        }

        public final void setStartValue(Double startValue) {
            this.startValue = startValue;
        }

        @Override
        public final Builder startValue(Double startValue) {
            this.startValue = startValue;
            return this;
        }

        @Override
        public HistogramBinOptions build() {
            return new HistogramBinOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
