/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The categorical data color for a single category.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialCategoricalDataColor implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialCategoricalDataColor.Builder, GeospatialCategoricalDataColor> {
    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(GeospatialCategoricalDataColor::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<String> DATA_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataValue").getter(getter(GeospatialCategoricalDataColor::dataValue)).setter(setter(Builder::dataValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COLOR_FIELD, DATA_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String color;

    private final String dataValue;

    private GeospatialCategoricalDataColor(BuilderImpl builder) {
        this.color = builder.color;
        this.dataValue = builder.dataValue;
    }

    /**
     * <p>
     * The color and opacity values for the category data color.
     * </p>
     * 
     * @return The color and opacity values for the category data color.
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * The data value for the category data color.
     * </p>
     * 
     * @return The data value for the category data color.
     */
    public final String dataValue() {
        return dataValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(dataValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialCategoricalDataColor)) {
            return false;
        }
        GeospatialCategoricalDataColor other = (GeospatialCategoricalDataColor) obj;
        return Objects.equals(color(), other.color()) && Objects.equals(dataValue(), other.dataValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialCategoricalDataColor").add("Color", color()).add("DataValue", dataValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "DataValue":
            return Optional.ofNullable(clazz.cast(dataValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Color", COLOR_FIELD);
        map.put("DataValue", DATA_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialCategoricalDataColor, T> g) {
        return obj -> g.apply((GeospatialCategoricalDataColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialCategoricalDataColor> {
        /**
         * <p>
         * The color and opacity values for the category data color.
         * </p>
         * 
         * @param color
         *        The color and opacity values for the category data color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * The data value for the category data color.
         * </p>
         * 
         * @param dataValue
         *        The data value for the category data color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataValue(String dataValue);
    }

    static final class BuilderImpl implements Builder {
        private String color;

        private String dataValue;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialCategoricalDataColor model) {
            color(model.color);
            dataValue(model.dataValue);
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final String getDataValue() {
            return dataValue;
        }

        public final void setDataValue(String dataValue) {
            this.dataValue = dataValue;
        }

        @Override
        public final Builder dataValue(String dataValue) {
            this.dataValue = dataValue;
            return this;
        }

        @Override
        public GeospatialCategoricalDataColor build() {
            return new GeospatialCategoricalDataColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
