/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of target visuals that you want to be filtered.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterOperationTargetVisualsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterOperationTargetVisualsConfiguration.Builder, FilterOperationTargetVisualsConfiguration> {
    private static final SdkField<SameSheetTargetVisualConfiguration> SAME_SHEET_TARGET_VISUAL_CONFIGURATION_FIELD = SdkField
            .<SameSheetTargetVisualConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SameSheetTargetVisualConfiguration")
            .getter(getter(FilterOperationTargetVisualsConfiguration::sameSheetTargetVisualConfiguration))
            .setter(setter(Builder::sameSheetTargetVisualConfiguration))
            .constructor(SameSheetTargetVisualConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SameSheetTargetVisualConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SAME_SHEET_TARGET_VISUAL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SameSheetTargetVisualConfiguration sameSheetTargetVisualConfiguration;

    private FilterOperationTargetVisualsConfiguration(BuilderImpl builder) {
        this.sameSheetTargetVisualConfiguration = builder.sameSheetTargetVisualConfiguration;
    }

    /**
     * <p>
     * The configuration of the same-sheet target visuals that you want to be filtered.
     * </p>
     * 
     * @return The configuration of the same-sheet target visuals that you want to be filtered.
     */
    public final SameSheetTargetVisualConfiguration sameSheetTargetVisualConfiguration() {
        return sameSheetTargetVisualConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sameSheetTargetVisualConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterOperationTargetVisualsConfiguration)) {
            return false;
        }
        FilterOperationTargetVisualsConfiguration other = (FilterOperationTargetVisualsConfiguration) obj;
        return Objects.equals(sameSheetTargetVisualConfiguration(), other.sameSheetTargetVisualConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterOperationTargetVisualsConfiguration")
                .add("SameSheetTargetVisualConfiguration", sameSheetTargetVisualConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SameSheetTargetVisualConfiguration":
            return Optional.ofNullable(clazz.cast(sameSheetTargetVisualConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SameSheetTargetVisualConfiguration", SAME_SHEET_TARGET_VISUAL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterOperationTargetVisualsConfiguration, T> g) {
        return obj -> g.apply((FilterOperationTargetVisualsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterOperationTargetVisualsConfiguration> {
        /**
         * <p>
         * The configuration of the same-sheet target visuals that you want to be filtered.
         * </p>
         * 
         * @param sameSheetTargetVisualConfiguration
         *        The configuration of the same-sheet target visuals that you want to be filtered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfiguration sameSheetTargetVisualConfiguration);

        /**
         * <p>
         * The configuration of the same-sheet target visuals that you want to be filtered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SameSheetTargetVisualConfiguration.Builder} avoiding the need to create one manually via
         * {@link SameSheetTargetVisualConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SameSheetTargetVisualConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfiguration)}.
         * 
         * @param sameSheetTargetVisualConfiguration
         *        a consumer that will call methods on {@link SameSheetTargetVisualConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfiguration)
         */
        default Builder sameSheetTargetVisualConfiguration(
                Consumer<SameSheetTargetVisualConfiguration.Builder> sameSheetTargetVisualConfiguration) {
            return sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfiguration.builder()
                    .applyMutation(sameSheetTargetVisualConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SameSheetTargetVisualConfiguration sameSheetTargetVisualConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterOperationTargetVisualsConfiguration model) {
            sameSheetTargetVisualConfiguration(model.sameSheetTargetVisualConfiguration);
        }

        public final SameSheetTargetVisualConfiguration.Builder getSameSheetTargetVisualConfiguration() {
            return sameSheetTargetVisualConfiguration != null ? sameSheetTargetVisualConfiguration.toBuilder() : null;
        }

        public final void setSameSheetTargetVisualConfiguration(
                SameSheetTargetVisualConfiguration.BuilderImpl sameSheetTargetVisualConfiguration) {
            this.sameSheetTargetVisualConfiguration = sameSheetTargetVisualConfiguration != null ? sameSheetTargetVisualConfiguration
                    .build() : null;
        }

        @Override
        public final Builder sameSheetTargetVisualConfiguration(
                SameSheetTargetVisualConfiguration sameSheetTargetVisualConfiguration) {
            this.sameSheetTargetVisualConfiguration = sameSheetTargetVisualConfiguration;
            return this;
        }

        @Override
        public FilterOperationTargetVisualsConfiguration build() {
            return new FilterOperationTargetVisualsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
