/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field sort options in a chart configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldSortOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldSortOptions.Builder, FieldSortOptions> {
    private static final SdkField<FieldSort> FIELD_SORT_FIELD = SdkField.<FieldSort> builder(MarshallingType.SDK_POJO)
            .memberName("FieldSort").getter(getter(FieldSortOptions::fieldSort)).setter(setter(Builder::fieldSort))
            .constructor(FieldSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldSort").build()).build();

    private static final SdkField<ColumnSort> COLUMN_SORT_FIELD = SdkField.<ColumnSort> builder(MarshallingType.SDK_POJO)
            .memberName("ColumnSort").getter(getter(FieldSortOptions::columnSort)).setter(setter(Builder::columnSort))
            .constructor(ColumnSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_SORT_FIELD,
            COLUMN_SORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldSort fieldSort;

    private final ColumnSort columnSort;

    private FieldSortOptions(BuilderImpl builder) {
        this.fieldSort = builder.fieldSort;
        this.columnSort = builder.columnSort;
    }

    /**
     * <p>
     * The sort configuration for a field in a field well.
     * </p>
     * 
     * @return The sort configuration for a field in a field well.
     */
    public final FieldSort fieldSort() {
        return fieldSort;
    }

    /**
     * <p>
     * The sort configuration for a column that is not used in a field well.
     * </p>
     * 
     * @return The sort configuration for a column that is not used in a field well.
     */
    public final ColumnSort columnSort() {
        return columnSort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldSort());
        hashCode = 31 * hashCode + Objects.hashCode(columnSort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSortOptions)) {
            return false;
        }
        FieldSortOptions other = (FieldSortOptions) obj;
        return Objects.equals(fieldSort(), other.fieldSort()) && Objects.equals(columnSort(), other.columnSort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldSortOptions").add("FieldSort", fieldSort()).add("ColumnSort", columnSort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldSort":
            return Optional.ofNullable(clazz.cast(fieldSort()));
        case "ColumnSort":
            return Optional.ofNullable(clazz.cast(columnSort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldSort", FIELD_SORT_FIELD);
        map.put("ColumnSort", COLUMN_SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldSortOptions, T> g) {
        return obj -> g.apply((FieldSortOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldSortOptions> {
        /**
         * <p>
         * The sort configuration for a field in a field well.
         * </p>
         * 
         * @param fieldSort
         *        The sort configuration for a field in a field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSort(FieldSort fieldSort);

        /**
         * <p>
         * The sort configuration for a field in a field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldSort.Builder} avoiding the need to
         * create one manually via {@link FieldSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldSort.Builder#build()} is called immediately and its result
         * is passed to {@link #fieldSort(FieldSort)}.
         * 
         * @param fieldSort
         *        a consumer that will call methods on {@link FieldSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldSort(FieldSort)
         */
        default Builder fieldSort(Consumer<FieldSort.Builder> fieldSort) {
            return fieldSort(FieldSort.builder().applyMutation(fieldSort).build());
        }

        /**
         * <p>
         * The sort configuration for a column that is not used in a field well.
         * </p>
         * 
         * @param columnSort
         *        The sort configuration for a column that is not used in a field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnSort(ColumnSort columnSort);

        /**
         * <p>
         * The sort configuration for a column that is not used in a field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnSort.Builder} avoiding the need to
         * create one manually via {@link ColumnSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnSort.Builder#build()} is called immediately and its result
         * is passed to {@link #columnSort(ColumnSort)}.
         * 
         * @param columnSort
         *        a consumer that will call methods on {@link ColumnSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnSort(ColumnSort)
         */
        default Builder columnSort(Consumer<ColumnSort.Builder> columnSort) {
            return columnSort(ColumnSort.builder().applyMutation(columnSort).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FieldSort fieldSort;

        private ColumnSort columnSort;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSortOptions model) {
            fieldSort(model.fieldSort);
            columnSort(model.columnSort);
        }

        public final FieldSort.Builder getFieldSort() {
            return fieldSort != null ? fieldSort.toBuilder() : null;
        }

        public final void setFieldSort(FieldSort.BuilderImpl fieldSort) {
            this.fieldSort = fieldSort != null ? fieldSort.build() : null;
        }

        @Override
        public final Builder fieldSort(FieldSort fieldSort) {
            this.fieldSort = fieldSort;
            return this;
        }

        public final ColumnSort.Builder getColumnSort() {
            return columnSort != null ? columnSort.toBuilder() : null;
        }

        public final void setColumnSort(ColumnSort.BuilderImpl columnSort) {
            this.columnSort = columnSort != null ? columnSort.build() : null;
        }

        @Override
        public final Builder columnSort(ColumnSort columnSort) {
            this.columnSort = columnSort;
            return this;
        }

        @Override
        public FieldSortOptions build() {
            return new FieldSortOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
