/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration for a field in a field well.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldSort implements SdkPojo, Serializable, ToCopyableBuilder<FieldSort.Builder, FieldSort> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(FieldSort::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(FieldSort::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD,
            DIRECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final String direction;

    private FieldSort(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.direction = builder.direction;
    }

    /**
     * <p>
     * The sort configuration target field.
     * </p>
     * 
     * @return The sort configuration target field.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The sort direction. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASC</code>: Ascending
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESC</code>: Descending
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The sort direction. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASC</code>: Ascending
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESC</code>: Descending
     *         </p>
     *         </li>
     * @see SortDirection
     */
    public final SortDirection direction() {
        return SortDirection.fromValue(direction);
    }

    /**
     * <p>
     * The sort direction. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASC</code>: Ascending
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESC</code>: Descending
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The sort direction. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASC</code>: Ascending
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESC</code>: Descending
     *         </p>
     *         </li>
     * @see SortDirection
     */
    public final String directionAsString() {
        return direction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSort)) {
            return false;
        }
        FieldSort other = (FieldSort) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(directionAsString(), other.directionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldSort").add("FieldId", fieldId()).add("Direction", directionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldSort, T> g) {
        return obj -> g.apply((FieldSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldSort> {
        /**
         * <p>
         * The sort configuration target field.
         * </p>
         * 
         * @param fieldId
         *        The sort configuration target field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The sort direction. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASC</code>: Ascending
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESC</code>: Descending
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        The sort direction. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASC</code>: Ascending
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESC</code>: Descending
         *        </p>
         *        </li>
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The sort direction. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASC</code>: Ascending
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESC</code>: Descending
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        The sort direction. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASC</code>: Ascending
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESC</code>: Descending
         *        </p>
         *        </li>
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder direction(SortDirection direction);
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private String direction;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSort model) {
            fieldId(model.fieldId);
            direction(model.direction);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(SortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        @Override
        public FieldSort build() {
            return new FieldSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
