/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDashboardSnapshotJobResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDashboardSnapshotJobResponse.Builder, DescribeDashboardSnapshotJobResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeDashboardSnapshotJobResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(DescribeDashboardSnapshotJobResponse::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<String> SNAPSHOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotJobId").getter(getter(DescribeDashboardSnapshotJobResponse::snapshotJobId))
            .setter(setter(Builder::snapshotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotJobId").build()).build();

    private static final SdkField<SnapshotUserConfigurationRedacted> USER_CONFIGURATION_FIELD = SdkField
            .<SnapshotUserConfigurationRedacted> builder(MarshallingType.SDK_POJO).memberName("UserConfiguration")
            .getter(getter(DescribeDashboardSnapshotJobResponse::userConfiguration)).setter(setter(Builder::userConfiguration))
            .constructor(SnapshotUserConfigurationRedacted::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfiguration").build()).build();

    private static final SdkField<SnapshotConfiguration> SNAPSHOT_CONFIGURATION_FIELD = SdkField
            .<SnapshotConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnapshotConfiguration")
            .getter(getter(DescribeDashboardSnapshotJobResponse::snapshotConfiguration))
            .setter(setter(Builder::snapshotConfiguration)).constructor(SnapshotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeDashboardSnapshotJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(DescribeDashboardSnapshotJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeDashboardSnapshotJobResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeDashboardSnapshotJobResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDashboardSnapshotJobResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDashboardSnapshotJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, SNAPSHOT_JOB_ID_FIELD, USER_CONFIGURATION_FIELD, SNAPSHOT_CONFIGURATION_FIELD, ARN_FIELD,
            JOB_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String dashboardId;

    private final String snapshotJobId;

    private final SnapshotUserConfigurationRedacted userConfiguration;

    private final SnapshotConfiguration snapshotConfiguration;

    private final String arn;

    private final String jobStatus;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String requestId;

    private final Integer status;

    private DescribeDashboardSnapshotJobResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.snapshotJobId = builder.snapshotJobId;
        this.userConfiguration = builder.userConfiguration;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.arn = builder.arn;
        this.jobStatus = builder.jobStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the dashboard that you have started a snapshot job for.
     * </p>
     * 
     * @return The ID of the dashboard that you have started a snapshot job for.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The ID of the job to be described. The job ID is set when you start a new job with a
     * <code>StartDashboardSnapshotJob</code> API call.
     * </p>
     * 
     * @return The ID of the job to be described. The job ID is set when you start a new job with a
     *         <code>StartDashboardSnapshotJob</code> API call.
     */
    public final String snapshotJobId() {
        return snapshotJobId;
    }

    /**
     * <p>
     * The user configuration for the snapshot job. This information is provided when you make a
     * <code>StartDashboardSnapshotJob</code> API call.
     * </p>
     * 
     * @return The user configuration for the snapshot job. This information is provided when you make a
     *         <code>StartDashboardSnapshotJob</code> API call.
     */
    public final SnapshotUserConfigurationRedacted userConfiguration() {
        return userConfiguration;
    }

    /**
     * <p>
     * The snapshot configuration of the job. This information is provided when you make a
     * <code>StartDashboardSnapshotJob</code> API call.
     * </p>
     * 
     * @return The snapshot configuration of the job. This information is provided when you make a
     *         <code>StartDashboardSnapshotJob</code> API call.
     */
    public final SnapshotConfiguration snapshotConfiguration() {
        return snapshotConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a
     * <code>StartDashboardSnapshotJob</code> API call.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job
     *         with a <code>StartDashboardSnapshotJob</code> API call.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates the status of a job. The status updates as the job executes. This shows one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job failed to execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code> - The job is queued and hasn't started yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> - The job is still running.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link SnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job. The status updates as the job executes. This shows one of the following
     *         values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The job was completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The job failed to execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUEUED</code> - The job is queued and hasn't started yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> - The job is still running.
     *         </p>
     *         </li>
     * @see SnapshotJobStatus
     */
    public final SnapshotJobStatus jobStatus() {
        return SnapshotJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Indicates the status of a job. The status updates as the job executes. This shows one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job failed to execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code> - The job is queued and hasn't started yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> - The job is still running.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link SnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job. The status updates as the job executes. This shows one of the following
     *         values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The job was completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The job failed to execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUEUED</code> - The job is queued and hasn't started yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> - The job is still running.
     *         </p>
     *         </li>
     * @see SnapshotJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The time that the snapshot job was created.
     * </p>
     * 
     * @return The time that the snapshot job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that the snapshot job status was last updated.
     * </p>
     * 
     * @return The time that the snapshot job status was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request
     * </p>
     * 
     * @return The HTTP status of the request
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(userConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardSnapshotJobResponse)) {
            return false;
        }
        DescribeDashboardSnapshotJobResponse other = (DescribeDashboardSnapshotJobResponse) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(snapshotJobId(), other.snapshotJobId())
                && Objects.equals(userConfiguration(), other.userConfiguration())
                && Objects.equals(snapshotConfiguration(), other.snapshotConfiguration()) && Objects.equals(arn(), other.arn())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDashboardSnapshotJobResponse").add("AwsAccountId", awsAccountId())
                .add("DashboardId", dashboardId()).add("SnapshotJobId", snapshotJobId())
                .add("UserConfiguration", userConfiguration()).add("SnapshotConfiguration", snapshotConfiguration())
                .add("Arn", arn()).add("JobStatus", jobStatusAsString()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "SnapshotJobId":
            return Optional.ofNullable(clazz.cast(snapshotJobId()));
        case "UserConfiguration":
            return Optional.ofNullable(clazz.cast(userConfiguration()));
        case "SnapshotConfiguration":
            return Optional.ofNullable(clazz.cast(snapshotConfiguration()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("SnapshotJobId", SNAPSHOT_JOB_ID_FIELD);
        map.put("UserConfiguration", USER_CONFIGURATION_FIELD);
        map.put("SnapshotConfiguration", SNAPSHOT_CONFIGURATION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardSnapshotJobResponse, T> g) {
        return obj -> g.apply((DescribeDashboardSnapshotJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDashboardSnapshotJobResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the dashboard that you have started a snapshot job for.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard that you have started a snapshot job for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The ID of the job to be described. The job ID is set when you start a new job with a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * 
         * @param snapshotJobId
         *        The ID of the job to be described. The job ID is set when you start a new job with a
         *        <code>StartDashboardSnapshotJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotJobId(String snapshotJobId);

        /**
         * <p>
         * The user configuration for the snapshot job. This information is provided when you make a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * 
         * @param userConfiguration
         *        The user configuration for the snapshot job. This information is provided when you make a
         *        <code>StartDashboardSnapshotJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userConfiguration(SnapshotUserConfigurationRedacted userConfiguration);

        /**
         * <p>
         * The user configuration for the snapshot job. This information is provided when you make a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SnapshotUserConfigurationRedacted.Builder} avoiding the need to create one manually via
         * {@link SnapshotUserConfigurationRedacted#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotUserConfigurationRedacted.Builder#build()} is called
         * immediately and its result is passed to {@link #userConfiguration(SnapshotUserConfigurationRedacted)}.
         * 
         * @param userConfiguration
         *        a consumer that will call methods on {@link SnapshotUserConfigurationRedacted.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userConfiguration(SnapshotUserConfigurationRedacted)
         */
        default Builder userConfiguration(Consumer<SnapshotUserConfigurationRedacted.Builder> userConfiguration) {
            return userConfiguration(SnapshotUserConfigurationRedacted.builder().applyMutation(userConfiguration).build());
        }

        /**
         * <p>
         * The snapshot configuration of the job. This information is provided when you make a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * 
         * @param snapshotConfiguration
         *        The snapshot configuration of the job. This information is provided when you make a
         *        <code>StartDashboardSnapshotJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotConfiguration(SnapshotConfiguration snapshotConfiguration);

        /**
         * <p>
         * The snapshot configuration of the job. This information is provided when you make a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotConfiguration.Builder} avoiding
         * the need to create one manually via {@link SnapshotConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #snapshotConfiguration(SnapshotConfiguration)}.
         * 
         * @param snapshotConfiguration
         *        a consumer that will call methods on {@link SnapshotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotConfiguration(SnapshotConfiguration)
         */
        default Builder snapshotConfiguration(Consumer<SnapshotConfiguration.Builder> snapshotConfiguration) {
            return snapshotConfiguration(SnapshotConfiguration.builder().applyMutation(snapshotConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job
         *        with a <code>StartDashboardSnapshotJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates the status of a job. The status updates as the job executes. This shows one of the following
         * values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The job was completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The job failed to execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUEUED</code> - The job is queued and hasn't started yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> - The job is still running.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        Indicates the status of a job. The status updates as the job executes. This shows one of the following
         *        values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The job was completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The job failed to execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUEUED</code> - The job is queued and hasn't started yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> - The job is still running.
         *        </p>
         *        </li>
         * @see SnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Indicates the status of a job. The status updates as the job executes. This shows one of the following
         * values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The job was completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The job failed to execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUEUED</code> - The job is queued and hasn't started yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> - The job is still running.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        Indicates the status of a job. The status updates as the job executes. This shows one of the following
         *        values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The job was completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The job failed to execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUEUED</code> - The job is queued and hasn't started yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> - The job is still running.
         *        </p>
         *        </li>
         * @see SnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotJobStatus
         */
        Builder jobStatus(SnapshotJobStatus jobStatus);

        /**
         * <p>
         * The time that the snapshot job was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the snapshot job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that the snapshot job status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that the snapshot job status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request
         * </p>
         * 
         * @param status
         *        The HTTP status of the request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String snapshotJobId;

        private SnapshotUserConfigurationRedacted userConfiguration;

        private SnapshotConfiguration snapshotConfiguration;

        private String arn;

        private String jobStatus;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardSnapshotJobResponse model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            snapshotJobId(model.snapshotJobId);
            userConfiguration(model.userConfiguration);
            snapshotConfiguration(model.snapshotConfiguration);
            arn(model.arn);
            jobStatus(model.jobStatus);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getSnapshotJobId() {
            return snapshotJobId;
        }

        public final void setSnapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
        }

        @Override
        public final Builder snapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
            return this;
        }

        public final SnapshotUserConfigurationRedacted.Builder getUserConfiguration() {
            return userConfiguration != null ? userConfiguration.toBuilder() : null;
        }

        public final void setUserConfiguration(SnapshotUserConfigurationRedacted.BuilderImpl userConfiguration) {
            this.userConfiguration = userConfiguration != null ? userConfiguration.build() : null;
        }

        @Override
        public final Builder userConfiguration(SnapshotUserConfigurationRedacted userConfiguration) {
            this.userConfiguration = userConfiguration;
            return this;
        }

        public final SnapshotConfiguration.Builder getSnapshotConfiguration() {
            return snapshotConfiguration != null ? snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(SnapshotConfiguration.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(SnapshotConfiguration snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(SnapshotJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeDashboardSnapshotJobResponse build() {
            return new DescribeDashboardSnapshotJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
