/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnalysisDefinitionResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeAnalysisDefinitionResponse.Builder, DescribeAnalysisDefinitionResponse> {
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(DescribeAnalysisDefinitionResponse::analysisId))
            .setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeAnalysisDefinitionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<AnalysisError>> ERRORS_FIELD = SdkField
            .<List<AnalysisError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(DescribeAnalysisDefinitionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatus").getter(getter(DescribeAnalysisDefinitionResponse::resourceStatusAsString))
            .setter(setter(Builder::resourceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()).build();

    private static final SdkField<String> THEME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeArn").getter(getter(DescribeAnalysisDefinitionResponse::themeArn))
            .setter(setter(Builder::themeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()).build();

    private static final SdkField<AnalysisDefinition> DEFINITION_FIELD = SdkField
            .<AnalysisDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(DescribeAnalysisDefinitionResponse::definition)).setter(setter(Builder::definition))
            .constructor(AnalysisDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeAnalysisDefinitionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeAnalysisDefinitionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_ID_FIELD, NAME_FIELD,
            ERRORS_FIELD, RESOURCE_STATUS_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String analysisId;

    private final String name;

    private final List<AnalysisError> errors;

    private final String resourceStatus;

    private final String themeArn;

    private final AnalysisDefinition definition;

    private final Integer status;

    private final String requestId;

    private DescribeAnalysisDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.analysisId = builder.analysisId;
        this.name = builder.name;
        this.errors = builder.errors;
        this.resourceStatus = builder.resourceStatus;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ID of the analysis described.
     * </p>
     * 
     * @return The ID of the analysis described.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The descriptive name of the analysis.
     * </p>
     * 
     * @return The descriptive name of the analysis.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors associated with the analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Errors associated with the analysis.
     */
    public final List<AnalysisError> errors() {
        return errors;
    }

    /**
     * <p>
     * Status associated with the analysis.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Status associated with the analysis.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>
     *         </p>
     *         </li>
     * @see ResourceStatus
     */
    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(resourceStatus);
    }

    /**
     * <p>
     * Status associated with the analysis.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Status associated with the analysis.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>
     *         </p>
     *         </li>
     * @see ResourceStatus
     */
    public final String resourceStatusAsString() {
        return resourceStatus;
    }

    /**
     * <p>
     * The ARN of the theme of the analysis.
     * </p>
     * 
     * @return The ARN of the theme of the analysis.
     */
    public final String themeArn() {
        return themeArn;
    }

    /**
     * <p>
     * The definition of an analysis.
     * </p>
     * <p>
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     * </p>
     * 
     * @return The definition of an analysis.</p>
     *         <p>
     *         A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public final AnalysisDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisDefinitionResponse)) {
            return false;
        }
        DescribeAnalysisDefinitionResponse other = (DescribeAnalysisDefinitionResponse) obj;
        return Objects.equals(analysisId(), other.analysisId()) && Objects.equals(name(), other.name())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && Objects.equals(resourceStatusAsString(), other.resourceStatusAsString())
                && Objects.equals(themeArn(), other.themeArn()) && Objects.equals(definition(), other.definition())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnalysisDefinitionResponse").add("AnalysisId", analysisId()).add("Name", name())
                .add("Errors", hasErrors() ? errors() : null).add("ResourceStatus", resourceStatusAsString())
                .add("ThemeArn", themeArn()).add("Definition", definition()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "ResourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatusAsString()));
        case "ThemeArn":
            return Optional.ofNullable(clazz.cast(themeArn()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("ResourceStatus", RESOURCE_STATUS_FIELD);
        map.put("ThemeArn", THEME_ARN_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnalysisDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeAnalysisDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAnalysisDefinitionResponse> {
        /**
         * <p>
         * The ID of the analysis described.
         * </p>
         * 
         * @param analysisId
         *        The ID of the analysis described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The descriptive name of the analysis.
         * </p>
         * 
         * @param name
         *        The descriptive name of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Errors associated with the analysis.
         * </p>
         * 
         * @param errors
         *        Errors associated with the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<AnalysisError> errors);

        /**
         * <p>
         * Errors associated with the analysis.
         * </p>
         * 
         * @param errors
         *        Errors associated with the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(AnalysisError... errors);

        /**
         * <p>
         * Errors associated with the analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AnalysisError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.AnalysisError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AnalysisError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<AnalysisError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AnalysisError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<AnalysisError>)
         */
        Builder errors(Consumer<AnalysisError.Builder>... errors);

        /**
         * <p>
         * Status associated with the analysis.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceStatus
         *        Status associated with the analysis.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>
         *        </p>
         *        </li>
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Status associated with the analysis.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceStatus
         *        Status associated with the analysis.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>
         *        </p>
         *        </li>
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * The ARN of the theme of the analysis.
         * </p>
         * 
         * @param themeArn
         *        The ARN of the theme of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeArn(String themeArn);

        /**
         * <p>
         * The definition of an analysis.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * 
         * @param definition
         *        The definition of an analysis.</p>
         *        <p>
         *        A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(AnalysisDefinition definition);

        /**
         * <p>
         * The definition of an analysis.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisDefinition.Builder} avoiding the
         * need to create one manually via {@link AnalysisDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(AnalysisDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link AnalysisDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(AnalysisDefinition)
         */
        default Builder definition(Consumer<AnalysisDefinition.Builder> definition) {
            return definition(AnalysisDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String analysisId;

        private String name;

        private List<AnalysisError> errors = DefaultSdkAutoConstructList.getInstance();

        private String resourceStatus;

        private String themeArn;

        private AnalysisDefinition definition;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisDefinitionResponse model) {
            super(model);
            analysisId(model.analysisId);
            name(model.name);
            errors(model.errors);
            resourceStatus(model.resourceStatus);
            themeArn(model.themeArn);
            definition(model.definition);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AnalysisError.Builder> getErrors() {
            List<AnalysisError.Builder> result = AnalysisErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AnalysisError.BuilderImpl> errors) {
            this.errors = AnalysisErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AnalysisError> errors) {
            this.errors = AnalysisErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AnalysisError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AnalysisError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> AnalysisError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getThemeArn() {
            return themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final AnalysisDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(AnalysisDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(AnalysisDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeAnalysisDefinitionResponse build() {
            return new DescribeAnalysisDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
