/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default configuration for all dependent controls of the filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFilterControlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultFilterControlConfiguration.Builder, DefaultFilterControlConfiguration> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(DefaultFilterControlConfiguration::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<DefaultFilterControlOptions> CONTROL_OPTIONS_FIELD = SdkField
            .<DefaultFilterControlOptions> builder(MarshallingType.SDK_POJO).memberName("ControlOptions")
            .getter(getter(DefaultFilterControlConfiguration::controlOptions)).setter(setter(Builder::controlOptions))
            .constructor(DefaultFilterControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            CONTROL_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final DefaultFilterControlOptions controlOptions;

    private DefaultFilterControlConfiguration(BuilderImpl builder) {
        this.title = builder.title;
        this.controlOptions = builder.controlOptions;
    }

    /**
     * <p>
     * The title of the <code>DefaultFilterControlConfiguration</code>. This title is shared by all controls that are
     * tied to this filter.
     * </p>
     * 
     * @return The title of the <code>DefaultFilterControlConfiguration</code>. This title is shared by all controls
     *         that are tied to this filter.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The control option for the <code>DefaultFilterControlConfiguration</code>.
     * </p>
     * 
     * @return The control option for the <code>DefaultFilterControlConfiguration</code>.
     */
    public final DefaultFilterControlOptions controlOptions() {
        return controlOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(controlOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFilterControlConfiguration)) {
            return false;
        }
        DefaultFilterControlConfiguration other = (DefaultFilterControlConfiguration) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(controlOptions(), other.controlOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultFilterControlConfiguration").add("Title", title())
                .add("ControlOptions", controlOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "ControlOptions":
            return Optional.ofNullable(clazz.cast(controlOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("ControlOptions", CONTROL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultFilterControlConfiguration, T> g) {
        return obj -> g.apply((DefaultFilterControlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultFilterControlConfiguration> {
        /**
         * <p>
         * The title of the <code>DefaultFilterControlConfiguration</code>. This title is shared by all controls that
         * are tied to this filter.
         * </p>
         * 
         * @param title
         *        The title of the <code>DefaultFilterControlConfiguration</code>. This title is shared by all controls
         *        that are tied to this filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The control option for the <code>DefaultFilterControlConfiguration</code>.
         * </p>
         * 
         * @param controlOptions
         *        The control option for the <code>DefaultFilterControlConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOptions(DefaultFilterControlOptions controlOptions);

        /**
         * <p>
         * The control option for the <code>DefaultFilterControlConfiguration</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultFilterControlOptions.Builder}
         * avoiding the need to create one manually via {@link DefaultFilterControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterControlOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #controlOptions(DefaultFilterControlOptions)}.
         * 
         * @param controlOptions
         *        a consumer that will call methods on {@link DefaultFilterControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlOptions(DefaultFilterControlOptions)
         */
        default Builder controlOptions(Consumer<DefaultFilterControlOptions.Builder> controlOptions) {
            return controlOptions(DefaultFilterControlOptions.builder().applyMutation(controlOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private DefaultFilterControlOptions controlOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFilterControlConfiguration model) {
            title(model.title);
            controlOptions(model.controlOptions);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final DefaultFilterControlOptions.Builder getControlOptions() {
            return controlOptions != null ? controlOptions.toBuilder() : null;
        }

        public final void setControlOptions(DefaultFilterControlOptions.BuilderImpl controlOptions) {
            this.controlOptions = controlOptions != null ? controlOptions.build() : null;
        }

        @Override
        public final Builder controlOptions(DefaultFilterControlOptions controlOptions) {
            this.controlOptions = controlOptions;
            return this;
        }

        @Override
        public DefaultFilterControlConfiguration build() {
            return new DefaultFilterControlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
