/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default values of a date time parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimeDatasetParameterDefaultValues implements SdkPojo, Serializable,
        ToCopyableBuilder<DateTimeDatasetParameterDefaultValues.Builder, DateTimeDatasetParameterDefaultValues> {
    private static final SdkField<List<Instant>> STATIC_VALUES_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("StaticValues")
            .getter(getter(DateTimeDatasetParameterDefaultValues::staticValues))
            .setter(setter(Builder::staticValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Instant> staticValues;

    private DateTimeDatasetParameterDefaultValues(BuilderImpl builder) {
        this.staticValues = builder.staticValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaticValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStaticValues() {
        return staticValues != null && !(staticValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of static default values for a given date time parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaticValues} method.
     * </p>
     * 
     * @return A list of static default values for a given date time parameter.
     */
    public final List<Instant> staticValues() {
        return staticValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticValues() ? staticValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeDatasetParameterDefaultValues)) {
            return false;
        }
        DateTimeDatasetParameterDefaultValues other = (DateTimeDatasetParameterDefaultValues) obj;
        return hasStaticValues() == other.hasStaticValues() && Objects.equals(staticValues(), other.staticValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimeDatasetParameterDefaultValues")
                .add("StaticValues", hasStaticValues() ? staticValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticValues":
            return Optional.ofNullable(clazz.cast(staticValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StaticValues", STATIC_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateTimeDatasetParameterDefaultValues, T> g) {
        return obj -> g.apply((DateTimeDatasetParameterDefaultValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimeDatasetParameterDefaultValues> {
        /**
         * <p>
         * A list of static default values for a given date time parameter.
         * </p>
         * 
         * @param staticValues
         *        A list of static default values for a given date time parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValues(Collection<Instant> staticValues);

        /**
         * <p>
         * A list of static default values for a given date time parameter.
         * </p>
         * 
         * @param staticValues
         *        A list of static default values for a given date time parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValues(Instant... staticValues);
    }

    static final class BuilderImpl implements Builder {
        private List<Instant> staticValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeDatasetParameterDefaultValues model) {
            staticValues(model.staticValues);
        }

        public final Collection<Instant> getStaticValues() {
            if (staticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return staticValues;
        }

        public final void setStaticValues(Collection<Instant> staticValues) {
            this.staticValues = DateTimeDatasetParameterValueListCopier.copy(staticValues);
        }

        @Override
        public final Builder staticValues(Collection<Instant> staticValues) {
            this.staticValues = DateTimeDatasetParameterValueListCopier.copy(staticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticValues(Instant... staticValues) {
            staticValues(Arrays.asList(staticValues));
            return this;
        }

        @Override
        public DateTimeDatasetParameterDefaultValues build() {
            return new DateTimeDatasetParameterDefaultValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
