/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data source credentials. This is a variant type structure. For this structure to be valid, only one of the attributes
 * can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceCredentials.Builder, DataSourceCredentials> {
    private static final SdkField<CredentialPair> CREDENTIAL_PAIR_FIELD = SdkField
            .<CredentialPair> builder(MarshallingType.SDK_POJO).memberName("CredentialPair")
            .getter(getter(DataSourceCredentials::credentialPair)).setter(setter(Builder::credentialPair))
            .constructor(CredentialPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialPair").build()).build();

    private static final SdkField<String> COPY_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopySourceArn").getter(getter(DataSourceCredentials::copySourceArn))
            .setter(setter(Builder::copySourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopySourceArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(DataSourceCredentials::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_PAIR_FIELD,
            COPY_SOURCE_ARN_FIELD, SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CredentialPair credentialPair;

    private final String copySourceArn;

    private final String secretArn;

    private DataSourceCredentials(BuilderImpl builder) {
        this.credentialPair = builder.credentialPair;
        this.copySourceArn = builder.copySourceArn;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * Credential pair. For more information, see
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> </code>
     * .
     * </p>
     * 
     * @return Credential pair. For more information, see
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> </code>
     *         .
     */
    public final CredentialPair credentialPair() {
        return credentialPair;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When
     * <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as the
     * credentials for the <code>DataSourceCredentials</code> structure.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When
     *         <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as
     *         the credentials for the <code>DataSourceCredentials</code> structure.
     */
    public final String copySourceArn() {
        return copySourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets Manager.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets Manager.
     */
    public final String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialPair());
        hashCode = 31 * hashCode + Objects.hashCode(copySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceCredentials)) {
            return false;
        }
        DataSourceCredentials other = (DataSourceCredentials) obj;
        return Objects.equals(credentialPair(), other.credentialPair()) && Objects.equals(copySourceArn(), other.copySourceArn())
                && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceCredentials").add("CredentialPair", credentialPair())
                .add("CopySourceArn", copySourceArn()).add("SecretArn", secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CredentialPair":
            return Optional.ofNullable(clazz.cast(credentialPair()));
        case "CopySourceArn":
            return Optional.ofNullable(clazz.cast(copySourceArn()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CredentialPair", CREDENTIAL_PAIR_FIELD);
        map.put("CopySourceArn", COPY_SOURCE_ARN_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceCredentials, T> g) {
        return obj -> g.apply((DataSourceCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceCredentials> {
        /**
         * <p>
         * Credential pair. For more information, see
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> </code>
         * .
         * </p>
         * 
         * @param credentialPair
         *        Credential pair. For more information, see
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialPair(CredentialPair credentialPair);

        /**
         * <p>
         * Credential pair. For more information, see
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> </code>
         * .
         * </p>
         * This is a convenience method that creates an instance of the {@link CredentialPair.Builder} avoiding the need
         * to create one manually via {@link CredentialPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CredentialPair.Builder#build()} is called immediately and its
         * result is passed to {@link #credentialPair(CredentialPair)}.
         * 
         * @param credentialPair
         *        a consumer that will call methods on {@link CredentialPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialPair(CredentialPair)
         */
        default Builder credentialPair(Consumer<CredentialPair.Builder> credentialPair) {
            return credentialPair(CredentialPair.builder().applyMutation(credentialPair).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When
         * <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as the
         * credentials for the <code>DataSourceCredentials</code> structure.
         * </p>
         * 
         * @param copySourceArn
         *        The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.
         *        When <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is
         *        used as the credentials for the <code>DataSourceCredentials</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceArn(String copySourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets
         *        Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private CredentialPair credentialPair;

        private String copySourceArn;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceCredentials model) {
            credentialPair(model.credentialPair);
            copySourceArn(model.copySourceArn);
            secretArn(model.secretArn);
        }

        public final CredentialPair.Builder getCredentialPair() {
            return credentialPair != null ? credentialPair.toBuilder() : null;
        }

        public final void setCredentialPair(CredentialPair.BuilderImpl credentialPair) {
            this.credentialPair = credentialPair != null ? credentialPair.build() : null;
        }

        @Override
        public final Builder credentialPair(CredentialPair credentialPair) {
            this.credentialPair = credentialPair;
            return this;
        }

        public final String getCopySourceArn() {
            return copySourceArn;
        }

        public final void setCopySourceArn(String copySourceArn) {
            this.copySourceArn = copySourceArn;
        }

        @Override
        public final Builder copySourceArn(String copySourceArn) {
            this.copySourceArn = copySourceArn;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public DataSourceCredentials build() {
            return new DataSourceCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
