/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The color map that determines the color options for a particular element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPathColor implements SdkPojo, Serializable, ToCopyableBuilder<DataPathColor.Builder, DataPathColor> {
    private static final SdkField<DataPathValue> ELEMENT_FIELD = SdkField.<DataPathValue> builder(MarshallingType.SDK_POJO)
            .memberName("Element").getter(getter(DataPathColor::element)).setter(setter(Builder::element))
            .constructor(DataPathValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Element").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(DataPathColor::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(DataPathColor::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_FIELD, COLOR_FIELD,
            TIME_GRANULARITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataPathValue element;

    private final String color;

    private final String timeGranularity;

    private DataPathColor(BuilderImpl builder) {
        this.element = builder.element;
        this.color = builder.color;
        this.timeGranularity = builder.timeGranularity;
    }

    /**
     * <p>
     * The element that the color needs to be applied to.
     * </p>
     * 
     * @return The element that the color needs to be applied to.
     */
    public final DataPathValue element() {
        return element;
    }

    /**
     * <p>
     * The color that needs to be applied to the element.
     * </p>
     * 
     * @return The color that needs to be applied to the element.
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * The time granularity of the field that the color needs to be applied to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The time granularity of the field that the color needs to be applied to.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The time granularity of the field that the color needs to be applied to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The time granularity of the field that the color needs to be applied to.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(element());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathColor)) {
            return false;
        }
        DataPathColor other = (DataPathColor) obj;
        return Objects.equals(element(), other.element()) && Objects.equals(color(), other.color())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPathColor").add("Element", element()).add("Color", color())
                .add("TimeGranularity", timeGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Element":
            return Optional.ofNullable(clazz.cast(element()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Element", ELEMENT_FIELD);
        map.put("Color", COLOR_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPathColor, T> g) {
        return obj -> g.apply((DataPathColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPathColor> {
        /**
         * <p>
         * The element that the color needs to be applied to.
         * </p>
         * 
         * @param element
         *        The element that the color needs to be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder element(DataPathValue element);

        /**
         * <p>
         * The element that the color needs to be applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPathValue.Builder} avoiding the need
         * to create one manually via {@link DataPathValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPathValue.Builder#build()} is called immediately and its
         * result is passed to {@link #element(DataPathValue)}.
         * 
         * @param element
         *        a consumer that will call methods on {@link DataPathValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #element(DataPathValue)
         */
        default Builder element(Consumer<DataPathValue.Builder> element) {
            return element(DataPathValue.builder().applyMutation(element).build());
        }

        /**
         * <p>
         * The color that needs to be applied to the element.
         * </p>
         * 
         * @param color
         *        The color that needs to be applied to the element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * The time granularity of the field that the color needs to be applied to.
         * </p>
         * 
         * @param timeGranularity
         *        The time granularity of the field that the color needs to be applied to.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The time granularity of the field that the color needs to be applied to.
         * </p>
         * 
         * @param timeGranularity
         *        The time granularity of the field that the color needs to be applied to.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);
    }

    static final class BuilderImpl implements Builder {
        private DataPathValue element;

        private String color;

        private String timeGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathColor model) {
            element(model.element);
            color(model.color);
            timeGranularity(model.timeGranularity);
        }

        public final DataPathValue.Builder getElement() {
            return element != null ? element.toBuilder() : null;
        }

        public final void setElement(DataPathValue.BuilderImpl element) {
            this.element = element != null ? element.build() : null;
        }

        @Override
        public final Builder element(DataPathValue element) {
            this.element = element;
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        @Override
        public DataPathColor build() {
            return new DataPathColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
