/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The theme colors that are used for data colors in charts. The colors description is a hexadecimal color code that
 * consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataColorPalette implements SdkPojo, Serializable,
        ToCopyableBuilder<DataColorPalette.Builder, DataColorPalette> {
    private static final SdkField<List<String>> COLORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Colors")
            .getter(getter(DataColorPalette::colors))
            .setter(setter(Builder::colors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MIN_MAX_GRADIENT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MinMaxGradient")
            .getter(getter(DataColorPalette::minMaxGradient))
            .setter(setter(Builder::minMaxGradient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinMaxGradient").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EMPTY_FILL_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmptyFillColor").getter(getter(DataColorPalette::emptyFillColor))
            .setter(setter(Builder::emptyFillColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyFillColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLORS_FIELD,
            MIN_MAX_GRADIENT_FIELD, EMPTY_FILL_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> colors;

    private final List<String> minMaxGradient;

    private final String emptyFillColor;

    private DataColorPalette(BuilderImpl builder) {
        this.colors = builder.colors;
        this.minMaxGradient = builder.minMaxGradient;
        this.emptyFillColor = builder.emptyFillColor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Colors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColors() {
        return colors != null && !(colors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The hexadecimal codes for the colors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColors} method.
     * </p>
     * 
     * @return The hexadecimal codes for the colors.
     */
    public final List<String> colors() {
        return colors;
    }

    /**
     * For responses, this returns true if the service returned a value for the MinMaxGradient property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMinMaxGradient() {
        return minMaxGradient != null && !(minMaxGradient instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The minimum and maximum hexadecimal codes that describe a color gradient.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMinMaxGradient} method.
     * </p>
     * 
     * @return The minimum and maximum hexadecimal codes that describe a color gradient.
     */
    public final List<String> minMaxGradient() {
        return minMaxGradient;
    }

    /**
     * <p>
     * The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
     * </p>
     * 
     * @return The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
     */
    public final String emptyFillColor() {
        return emptyFillColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColors() ? colors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMinMaxGradient() ? minMaxGradient() : null);
        hashCode = 31 * hashCode + Objects.hashCode(emptyFillColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataColorPalette)) {
            return false;
        }
        DataColorPalette other = (DataColorPalette) obj;
        return hasColors() == other.hasColors() && Objects.equals(colors(), other.colors())
                && hasMinMaxGradient() == other.hasMinMaxGradient() && Objects.equals(minMaxGradient(), other.minMaxGradient())
                && Objects.equals(emptyFillColor(), other.emptyFillColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataColorPalette").add("Colors", hasColors() ? colors() : null)
                .add("MinMaxGradient", hasMinMaxGradient() ? minMaxGradient() : null).add("EmptyFillColor", emptyFillColor())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Colors":
            return Optional.ofNullable(clazz.cast(colors()));
        case "MinMaxGradient":
            return Optional.ofNullable(clazz.cast(minMaxGradient()));
        case "EmptyFillColor":
            return Optional.ofNullable(clazz.cast(emptyFillColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Colors", COLORS_FIELD);
        map.put("MinMaxGradient", MIN_MAX_GRADIENT_FIELD);
        map.put("EmptyFillColor", EMPTY_FILL_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataColorPalette, T> g) {
        return obj -> g.apply((DataColorPalette) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataColorPalette> {
        /**
         * <p>
         * The hexadecimal codes for the colors.
         * </p>
         * 
         * @param colors
         *        The hexadecimal codes for the colors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(Collection<String> colors);

        /**
         * <p>
         * The hexadecimal codes for the colors.
         * </p>
         * 
         * @param colors
         *        The hexadecimal codes for the colors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(String... colors);

        /**
         * <p>
         * The minimum and maximum hexadecimal codes that describe a color gradient.
         * </p>
         * 
         * @param minMaxGradient
         *        The minimum and maximum hexadecimal codes that describe a color gradient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMaxGradient(Collection<String> minMaxGradient);

        /**
         * <p>
         * The minimum and maximum hexadecimal codes that describe a color gradient.
         * </p>
         * 
         * @param minMaxGradient
         *        The minimum and maximum hexadecimal codes that describe a color gradient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMaxGradient(String... minMaxGradient);

        /**
         * <p>
         * The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
         * </p>
         * 
         * @param emptyFillColor
         *        The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyFillColor(String emptyFillColor);
    }

    static final class BuilderImpl implements Builder {
        private List<String> colors = DefaultSdkAutoConstructList.getInstance();

        private List<String> minMaxGradient = DefaultSdkAutoConstructList.getInstance();

        private String emptyFillColor;

        private BuilderImpl() {
        }

        private BuilderImpl(DataColorPalette model) {
            colors(model.colors);
            minMaxGradient(model.minMaxGradient);
            emptyFillColor(model.emptyFillColor);
        }

        public final Collection<String> getColors() {
            if (colors instanceof SdkAutoConstructList) {
                return null;
            }
            return colors;
        }

        public final void setColors(Collection<String> colors) {
            this.colors = ColorListCopier.copy(colors);
        }

        @Override
        public final Builder colors(Collection<String> colors) {
            this.colors = ColorListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(String... colors) {
            colors(Arrays.asList(colors));
            return this;
        }

        public final Collection<String> getMinMaxGradient() {
            if (minMaxGradient instanceof SdkAutoConstructList) {
                return null;
            }
            return minMaxGradient;
        }

        public final void setMinMaxGradient(Collection<String> minMaxGradient) {
            this.minMaxGradient = ColorListCopier.copy(minMaxGradient);
        }

        @Override
        public final Builder minMaxGradient(Collection<String> minMaxGradient) {
            this.minMaxGradient = ColorListCopier.copy(minMaxGradient);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder minMaxGradient(String... minMaxGradient) {
            minMaxGradient(Arrays.asList(minMaxGradient));
            return this;
        }

        public final String getEmptyFillColor() {
            return emptyFillColor;
        }

        public final void setEmptyFillColor(String emptyFillColor) {
            this.emptyFillColor = emptyFillColor;
        }

        @Override
        public final Builder emptyFillColor(String emptyFillColor) {
            this.emptyFillColor = emptyFillColor;
            return this;
        }

        @Override
        public DataColorPalette build() {
            return new DataColorPalette(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
