/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a data aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataAggregation implements SdkPojo, Serializable, ToCopyableBuilder<DataAggregation.Builder, DataAggregation> {
    private static final SdkField<String> DATASET_ROW_DATE_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetRowDateGranularity").getter(getter(DataAggregation::datasetRowDateGranularityAsString))
            .setter(setter(Builder::datasetRowDateGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetRowDateGranularity").build())
            .build();

    private static final SdkField<String> DEFAULT_DATE_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultDateColumnName").getter(getter(DataAggregation::defaultDateColumnName))
            .setter(setter(Builder::defaultDateColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDateColumnName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATASET_ROW_DATE_GRANULARITY_FIELD, DEFAULT_DATE_COLUMN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetRowDateGranularity;

    private final String defaultDateColumnName;

    private DataAggregation(BuilderImpl builder) {
        this.datasetRowDateGranularity = builder.datasetRowDateGranularity;
        this.defaultDateColumnName = builder.defaultDateColumnName;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datasetRowDateGranularity} will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #datasetRowDateGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final TopicTimeGranularity datasetRowDateGranularity() {
        return TopicTimeGranularity.fromValue(datasetRowDateGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datasetRowDateGranularity} will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #datasetRowDateGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final String datasetRowDateGranularityAsString() {
        return datasetRowDateGranularity;
    }

    /**
     * <p>
     * The column name for the default date.
     * </p>
     * 
     * @return The column name for the default date.
     */
    public final String defaultDateColumnName() {
        return defaultDateColumnName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetRowDateGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDateColumnName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAggregation)) {
            return false;
        }
        DataAggregation other = (DataAggregation) obj;
        return Objects.equals(datasetRowDateGranularityAsString(), other.datasetRowDateGranularityAsString())
                && Objects.equals(defaultDateColumnName(), other.defaultDateColumnName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataAggregation").add("DatasetRowDateGranularity", datasetRowDateGranularityAsString())
                .add("DefaultDateColumnName", defaultDateColumnName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetRowDateGranularity":
            return Optional.ofNullable(clazz.cast(datasetRowDateGranularityAsString()));
        case "DefaultDateColumnName":
            return Optional.ofNullable(clazz.cast(defaultDateColumnName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasetRowDateGranularity", DATASET_ROW_DATE_GRANULARITY_FIELD);
        map.put("DefaultDateColumnName", DEFAULT_DATE_COLUMN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAggregation, T> g) {
        return obj -> g.apply((DataAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataAggregation> {
        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param datasetRowDateGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder datasetRowDateGranularity(String datasetRowDateGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param datasetRowDateGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder datasetRowDateGranularity(TopicTimeGranularity datasetRowDateGranularity);

        /**
         * <p>
         * The column name for the default date.
         * </p>
         * 
         * @param defaultDateColumnName
         *        The column name for the default date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDateColumnName(String defaultDateColumnName);
    }

    static final class BuilderImpl implements Builder {
        private String datasetRowDateGranularity;

        private String defaultDateColumnName;

        private BuilderImpl() {
        }

        private BuilderImpl(DataAggregation model) {
            datasetRowDateGranularity(model.datasetRowDateGranularity);
            defaultDateColumnName(model.defaultDateColumnName);
        }

        public final String getDatasetRowDateGranularity() {
            return datasetRowDateGranularity;
        }

        public final void setDatasetRowDateGranularity(String datasetRowDateGranularity) {
            this.datasetRowDateGranularity = datasetRowDateGranularity;
        }

        @Override
        public final Builder datasetRowDateGranularity(String datasetRowDateGranularity) {
            this.datasetRowDateGranularity = datasetRowDateGranularity;
            return this;
        }

        @Override
        public final Builder datasetRowDateGranularity(TopicTimeGranularity datasetRowDateGranularity) {
            this.datasetRowDateGranularity(datasetRowDateGranularity == null ? null : datasetRowDateGranularity.toString());
            return this;
        }

        public final String getDefaultDateColumnName() {
            return defaultDateColumnName;
        }

        public final void setDefaultDateColumnName(String defaultDateColumnName) {
            this.defaultDateColumnName = defaultDateColumnName;
        }

        @Override
        public final Builder defaultDateColumnName(String defaultDateColumnName) {
            this.defaultDateColumnName = defaultDateColumnName;
            return this;
        }

        @Override
        public DataAggregation build() {
            return new DataAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
