/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The URL operation that opens a link to another webpage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomActionURLOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomActionURLOperation.Builder, CustomActionURLOperation> {
    private static final SdkField<String> URL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("URLTemplate").getter(getter(CustomActionURLOperation::urlTemplate)).setter(setter(Builder::urlTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLTemplate").build()).build();

    private static final SdkField<String> URL_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("URLTarget").getter(getter(CustomActionURLOperation::urlTargetAsString))
            .setter(setter(Builder::urlTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_TEMPLATE_FIELD,
            URL_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String urlTemplate;

    private final String urlTarget;

    private CustomActionURLOperation(BuilderImpl builder) {
        this.urlTemplate = builder.urlTemplate;
        this.urlTarget = builder.urlTarget;
    }

    /**
     * <p>
     * THe URL link of the <code>CustomActionURLOperation</code>.
     * </p>
     * 
     * @return THe URL link of the <code>CustomActionURLOperation</code>.
     */
    public final String urlTemplate() {
        return urlTemplate;
    }

    /**
     * <p>
     * The target of the <code>CustomActionURLOperation</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #urlTarget} will
     * return {@link URLTargetConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #urlTargetAsString}.
     * </p>
     * 
     * @return The target of the <code>CustomActionURLOperation</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
     *         </p>
     *         </li>
     * @see URLTargetConfiguration
     */
    public final URLTargetConfiguration urlTarget() {
        return URLTargetConfiguration.fromValue(urlTarget);
    }

    /**
     * <p>
     * The target of the <code>CustomActionURLOperation</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #urlTarget} will
     * return {@link URLTargetConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #urlTargetAsString}.
     * </p>
     * 
     * @return The target of the <code>CustomActionURLOperation</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
     *         </p>
     *         </li>
     * @see URLTargetConfiguration
     */
    public final String urlTargetAsString() {
        return urlTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(urlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(urlTargetAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionURLOperation)) {
            return false;
        }
        CustomActionURLOperation other = (CustomActionURLOperation) obj;
        return Objects.equals(urlTemplate(), other.urlTemplate())
                && Objects.equals(urlTargetAsString(), other.urlTargetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomActionURLOperation").add("URLTemplate", urlTemplate())
                .add("URLTarget", urlTargetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "URLTemplate":
            return Optional.ofNullable(clazz.cast(urlTemplate()));
        case "URLTarget":
            return Optional.ofNullable(clazz.cast(urlTargetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("URLTemplate", URL_TEMPLATE_FIELD);
        map.put("URLTarget", URL_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionURLOperation, T> g) {
        return obj -> g.apply((CustomActionURLOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomActionURLOperation> {
        /**
         * <p>
         * THe URL link of the <code>CustomActionURLOperation</code>.
         * </p>
         * 
         * @param urlTemplate
         *        THe URL link of the <code>CustomActionURLOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlTemplate(String urlTemplate);

        /**
         * <p>
         * The target of the <code>CustomActionURLOperation</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
         * </p>
         * </li>
         * </ul>
         * 
         * @param urlTarget
         *        The target of the <code>CustomActionURLOperation</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
         *        </p>
         *        </li>
         * @see URLTargetConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see URLTargetConfiguration
         */
        Builder urlTarget(String urlTarget);

        /**
         * <p>
         * The target of the <code>CustomActionURLOperation</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
         * </p>
         * </li>
         * </ul>
         * 
         * @param urlTarget
         *        The target of the <code>CustomActionURLOperation</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW_TAB</code>: Opens the target URL in a new browser tab.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAME_TAB</code>: Opens the target URL in the same browser tab.
         *        </p>
         *        </li>
         * @see URLTargetConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see URLTargetConfiguration
         */
        Builder urlTarget(URLTargetConfiguration urlTarget);
    }

    static final class BuilderImpl implements Builder {
        private String urlTemplate;

        private String urlTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionURLOperation model) {
            urlTemplate(model.urlTemplate);
            urlTarget(model.urlTarget);
        }

        public final String getUrlTemplate() {
            return urlTemplate;
        }

        public final void setUrlTemplate(String urlTemplate) {
            this.urlTemplate = urlTemplate;
        }

        @Override
        public final Builder urlTemplate(String urlTemplate) {
            this.urlTemplate = urlTemplate;
            return this;
        }

        public final String getUrlTarget() {
            return urlTarget;
        }

        public final void setUrlTarget(String urlTarget) {
            this.urlTarget = urlTarget;
        }

        @Override
        public final Builder urlTarget(String urlTarget) {
            this.urlTarget = urlTarget;
            return this;
        }

        @Override
        public final Builder urlTarget(URLTargetConfiguration urlTarget) {
            this.urlTarget(urlTarget == null ? null : urlTarget.toString());
            return this;
        }

        @Override
        public CustomActionURLOperation build() {
            return new CustomActionURLOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
