/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNamespaceResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateNamespaceResponse.Builder, CreateNamespaceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateNamespaceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNamespaceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CAPACITY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityRegion").getter(getter(CreateNamespaceResponse::capacityRegion))
            .setter(setter(Builder::capacityRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRegion").build()).build();

    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationStatus").getter(getter(CreateNamespaceResponse::creationStatusAsString))
            .setter(setter(Builder::creationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()).build();

    private static final SdkField<String> IDENTITY_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStore").getter(getter(CreateNamespaceResponse::identityStoreAsString))
            .setter(setter(Builder::identityStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStore").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(CreateNamespaceResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(CreateNamespaceResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CAPACITY_REGION_FIELD, CREATION_STATUS_FIELD, IDENTITY_STORE_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String capacityRegion;

    private final String creationStatus;

    private final String identityStore;

    private final String requestId;

    private final Integer status;

    private CreateNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.capacityRegion = builder.capacityRegion;
        this.creationStatus = builder.creationStatus;
        this.identityStore = builder.identityStore;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the Amazon QuickSight namespace you created.
     * </p>
     * 
     * @return The ARN of the Amazon QuickSight namespace you created.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the new namespace that you created.
     * </p>
     * 
     * @return The name of the new namespace that you created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is
     * set to the region that you run CreateNamespace in.
     * </p>
     * 
     * @return The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace.
     *         This is set to the region that you run CreateNamespace in.
     */
    public final String capacityRegion() {
        return capacityRegion;
    }

    /**
     * <p>
     * The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code>
     * means that your namespace is ready to use. If an error occurs, it indicates if the process is
     * <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error
     * message for follow-up tasks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link NamespaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The status of the creation of the namespace. This is an asynchronous process. A status of
     *         <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the
     *         process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error,
     *         refer to the error message for follow-up tasks.
     * @see NamespaceStatus
     */
    public final NamespaceStatus creationStatus() {
        return NamespaceStatus.fromValue(creationStatus);
    }

    /**
     * <p>
     * The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code>
     * means that your namespace is ready to use. If an error occurs, it indicates if the process is
     * <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error
     * message for follow-up tasks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link NamespaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The status of the creation of the namespace. This is an asynchronous process. A status of
     *         <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the
     *         process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error,
     *         refer to the error message for follow-up tasks.
     * @see NamespaceStatus
     */
    public final String creationStatusAsString() {
        return creationStatus;
    }

    /**
     * <p>
     * Specifies the type of your user identity directory. Currently, this supports users with an identity type of
     * <code>QUICKSIGHT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityStore}
     * will return {@link IdentityStore#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityStoreAsString}.
     * </p>
     * 
     * @return Specifies the type of your user identity directory. Currently, this supports users with an identity type
     *         of <code>QUICKSIGHT</code>.
     * @see IdentityStore
     */
    public final IdentityStore identityStore() {
        return IdentityStore.fromValue(identityStore);
    }

    /**
     * <p>
     * Specifies the type of your user identity directory. Currently, this supports users with an identity type of
     * <code>QUICKSIGHT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityStore}
     * will return {@link IdentityStore#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityStoreAsString}.
     * </p>
     * 
     * @return Specifies the type of your user identity directory. Currently, this supports users with an identity type
     *         of <code>QUICKSIGHT</code>.
     * @see IdentityStore
     */
    public final String identityStoreAsString() {
        return identityStore;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(capacityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNamespaceResponse)) {
            return false;
        }
        CreateNamespaceResponse other = (CreateNamespaceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(capacityRegion(), other.capacityRegion())
                && Objects.equals(creationStatusAsString(), other.creationStatusAsString())
                && Objects.equals(identityStoreAsString(), other.identityStoreAsString())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNamespaceResponse").add("Arn", arn()).add("Name", name())
                .add("CapacityRegion", capacityRegion()).add("CreationStatus", creationStatusAsString())
                .add("IdentityStore", identityStoreAsString()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CapacityRegion":
            return Optional.ofNullable(clazz.cast(capacityRegion()));
        case "CreationStatus":
            return Optional.ofNullable(clazz.cast(creationStatusAsString()));
        case "IdentityStore":
            return Optional.ofNullable(clazz.cast(identityStoreAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CapacityRegion", CAPACITY_REGION_FIELD);
        map.put("CreationStatus", CREATION_STATUS_FIELD);
        map.put("IdentityStore", IDENTITY_STORE_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNamespaceResponse, T> g) {
        return obj -> g.apply((CreateNamespaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateNamespaceResponse> {
        /**
         * <p>
         * The ARN of the Amazon QuickSight namespace you created.
         * </p>
         * 
         * @param arn
         *        The ARN of the Amazon QuickSight namespace you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the new namespace that you created.
         * </p>
         * 
         * @param name
         *        The name of the new namespace that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This
         * is set to the region that you run CreateNamespace in.
         * </p>
         * 
         * @param capacityRegion
         *        The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new
         *        namespace. This is set to the region that you run CreateNamespace in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRegion(String capacityRegion);

        /**
         * <p>
         * The status of the creation of the namespace. This is an asynchronous process. A status of
         * <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the
         * process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer
         * to the error message for follow-up tasks.
         * </p>
         * 
         * @param creationStatus
         *        The status of the creation of the namespace. This is an asynchronous process. A status of
         *        <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if
         *        the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable
         *        error, refer to the error message for follow-up tasks.
         * @see NamespaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceStatus
         */
        Builder creationStatus(String creationStatus);

        /**
         * <p>
         * The status of the creation of the namespace. This is an asynchronous process. A status of
         * <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the
         * process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer
         * to the error message for follow-up tasks.
         * </p>
         * 
         * @param creationStatus
         *        The status of the creation of the namespace. This is an asynchronous process. A status of
         *        <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if
         *        the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable
         *        error, refer to the error message for follow-up tasks.
         * @see NamespaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceStatus
         */
        Builder creationStatus(NamespaceStatus creationStatus);

        /**
         * <p>
         * Specifies the type of your user identity directory. Currently, this supports users with an identity type of
         * <code>QUICKSIGHT</code>.
         * </p>
         * 
         * @param identityStore
         *        Specifies the type of your user identity directory. Currently, this supports users with an identity
         *        type of <code>QUICKSIGHT</code>.
         * @see IdentityStore
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityStore
         */
        Builder identityStore(String identityStore);

        /**
         * <p>
         * Specifies the type of your user identity directory. Currently, this supports users with an identity type of
         * <code>QUICKSIGHT</code>.
         * </p>
         * 
         * @param identityStore
         *        Specifies the type of your user identity directory. Currently, this supports users with an identity
         *        type of <code>QUICKSIGHT</code>.
         * @see IdentityStore
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityStore
         */
        Builder identityStore(IdentityStore identityStore);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String capacityRegion;

        private String creationStatus;

        private String identityStore;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNamespaceResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            capacityRegion(model.capacityRegion);
            creationStatus(model.creationStatus);
            identityStore(model.identityStore);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCapacityRegion() {
            return capacityRegion;
        }

        public final void setCapacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
        }

        @Override
        public final Builder capacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
            return this;
        }

        public final String getCreationStatus() {
            return creationStatus;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(NamespaceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final String getIdentityStore() {
            return identityStore;
        }

        public final void setIdentityStore(String identityStore) {
            this.identityStore = identityStore;
        }

        @Override
        public final Builder identityStore(String identityStore) {
            this.identityStore = identityStore;
            return this;
        }

        @Override
        public final Builder identityStore(IdentityStore identityStore) {
            this.identityStore(identityStore == null ? null : identityStore.toString());
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateNamespaceResponse build() {
            return new CreateNamespaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
