/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for the <code>ContributionAnalysisTimeRanges</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContributionAnalysisTimeRanges implements SdkPojo, Serializable,
        ToCopyableBuilder<ContributionAnalysisTimeRanges.Builder, ContributionAnalysisTimeRanges> {
    private static final SdkField<TopicIRFilterOption> START_RANGE_FIELD = SdkField
            .<TopicIRFilterOption> builder(MarshallingType.SDK_POJO).memberName("StartRange")
            .getter(getter(ContributionAnalysisTimeRanges::startRange)).setter(setter(Builder::startRange))
            .constructor(TopicIRFilterOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartRange").build()).build();

    private static final SdkField<TopicIRFilterOption> END_RANGE_FIELD = SdkField
            .<TopicIRFilterOption> builder(MarshallingType.SDK_POJO).memberName("EndRange")
            .getter(getter(ContributionAnalysisTimeRanges::endRange)).setter(setter(Builder::endRange))
            .constructor(TopicIRFilterOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_RANGE_FIELD,
            END_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TopicIRFilterOption startRange;

    private final TopicIRFilterOption endRange;

    private ContributionAnalysisTimeRanges(BuilderImpl builder) {
        this.startRange = builder.startRange;
        this.endRange = builder.endRange;
    }

    /**
     * <p>
     * The start range for the <code>ContributionAnalysisTimeRanges</code>.
     * </p>
     * 
     * @return The start range for the <code>ContributionAnalysisTimeRanges</code>.
     */
    public final TopicIRFilterOption startRange() {
        return startRange;
    }

    /**
     * <p>
     * The end range for the <code>ContributionAnalysisTimeRanges</code>.
     * </p>
     * 
     * @return The end range for the <code>ContributionAnalysisTimeRanges</code>.
     */
    public final TopicIRFilterOption endRange() {
        return endRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startRange());
        hashCode = 31 * hashCode + Objects.hashCode(endRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributionAnalysisTimeRanges)) {
            return false;
        }
        ContributionAnalysisTimeRanges other = (ContributionAnalysisTimeRanges) obj;
        return Objects.equals(startRange(), other.startRange()) && Objects.equals(endRange(), other.endRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContributionAnalysisTimeRanges").add("StartRange", startRange()).add("EndRange", endRange())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartRange":
            return Optional.ofNullable(clazz.cast(startRange()));
        case "EndRange":
            return Optional.ofNullable(clazz.cast(endRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartRange", START_RANGE_FIELD);
        map.put("EndRange", END_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContributionAnalysisTimeRanges, T> g) {
        return obj -> g.apply((ContributionAnalysisTimeRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContributionAnalysisTimeRanges> {
        /**
         * <p>
         * The start range for the <code>ContributionAnalysisTimeRanges</code>.
         * </p>
         * 
         * @param startRange
         *        The start range for the <code>ContributionAnalysisTimeRanges</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startRange(TopicIRFilterOption startRange);

        /**
         * <p>
         * The start range for the <code>ContributionAnalysisTimeRanges</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicIRFilterOption.Builder} avoiding the
         * need to create one manually via {@link TopicIRFilterOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicIRFilterOption.Builder#build()} is called immediately and
         * its result is passed to {@link #startRange(TopicIRFilterOption)}.
         * 
         * @param startRange
         *        a consumer that will call methods on {@link TopicIRFilterOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startRange(TopicIRFilterOption)
         */
        default Builder startRange(Consumer<TopicIRFilterOption.Builder> startRange) {
            return startRange(TopicIRFilterOption.builder().applyMutation(startRange).build());
        }

        /**
         * <p>
         * The end range for the <code>ContributionAnalysisTimeRanges</code>.
         * </p>
         * 
         * @param endRange
         *        The end range for the <code>ContributionAnalysisTimeRanges</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endRange(TopicIRFilterOption endRange);

        /**
         * <p>
         * The end range for the <code>ContributionAnalysisTimeRanges</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicIRFilterOption.Builder} avoiding the
         * need to create one manually via {@link TopicIRFilterOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicIRFilterOption.Builder#build()} is called immediately and
         * its result is passed to {@link #endRange(TopicIRFilterOption)}.
         * 
         * @param endRange
         *        a consumer that will call methods on {@link TopicIRFilterOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endRange(TopicIRFilterOption)
         */
        default Builder endRange(Consumer<TopicIRFilterOption.Builder> endRange) {
            return endRange(TopicIRFilterOption.builder().applyMutation(endRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TopicIRFilterOption startRange;

        private TopicIRFilterOption endRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ContributionAnalysisTimeRanges model) {
            startRange(model.startRange);
            endRange(model.endRange);
        }

        public final TopicIRFilterOption.Builder getStartRange() {
            return startRange != null ? startRange.toBuilder() : null;
        }

        public final void setStartRange(TopicIRFilterOption.BuilderImpl startRange) {
            this.startRange = startRange != null ? startRange.build() : null;
        }

        @Override
        public final Builder startRange(TopicIRFilterOption startRange) {
            this.startRange = startRange;
            return this;
        }

        public final TopicIRFilterOption.Builder getEndRange() {
            return endRange != null ? endRange.toBuilder() : null;
        }

        public final void setEndRange(TopicIRFilterOption.BuilderImpl endRange) {
            this.endRange = endRange != null ? endRange.build() : null;
        }

        @Override
        public final Builder endRange(TopicIRFilterOption endRange) {
            this.endRange = endRange;
            return this;
        }

        @Override
        public ContributionAnalysisTimeRanges build() {
            return new ContributionAnalysisTimeRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
