/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options for the axis label.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisDisplayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AxisDisplayOptions.Builder, AxisDisplayOptions> {
    private static final SdkField<AxisTickLabelOptions> TICK_LABEL_OPTIONS_FIELD = SdkField
            .<AxisTickLabelOptions> builder(MarshallingType.SDK_POJO).memberName("TickLabelOptions")
            .getter(getter(AxisDisplayOptions::tickLabelOptions)).setter(setter(Builder::tickLabelOptions))
            .constructor(AxisTickLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TickLabelOptions").build()).build();

    private static final SdkField<String> AXIS_LINE_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AxisLineVisibility").getter(getter(AxisDisplayOptions::axisLineVisibilityAsString))
            .setter(setter(Builder::axisLineVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisLineVisibility").build())
            .build();

    private static final SdkField<String> GRID_LINE_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GridLineVisibility").getter(getter(AxisDisplayOptions::gridLineVisibilityAsString))
            .setter(setter(Builder::gridLineVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GridLineVisibility").build())
            .build();

    private static final SdkField<AxisDataOptions> DATA_OPTIONS_FIELD = SdkField
            .<AxisDataOptions> builder(MarshallingType.SDK_POJO).memberName("DataOptions")
            .getter(getter(AxisDisplayOptions::dataOptions)).setter(setter(Builder::dataOptions))
            .constructor(AxisDataOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOptions").build()).build();

    private static final SdkField<ScrollBarOptions> SCROLLBAR_OPTIONS_FIELD = SdkField
            .<ScrollBarOptions> builder(MarshallingType.SDK_POJO).memberName("ScrollbarOptions")
            .getter(getter(AxisDisplayOptions::scrollbarOptions)).setter(setter(Builder::scrollbarOptions))
            .constructor(ScrollBarOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScrollbarOptions").build()).build();

    private static final SdkField<String> AXIS_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AxisOffset").getter(getter(AxisDisplayOptions::axisOffset)).setter(setter(Builder::axisOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisOffset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICK_LABEL_OPTIONS_FIELD,
            AXIS_LINE_VISIBILITY_FIELD, GRID_LINE_VISIBILITY_FIELD, DATA_OPTIONS_FIELD, SCROLLBAR_OPTIONS_FIELD,
            AXIS_OFFSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AxisTickLabelOptions tickLabelOptions;

    private final String axisLineVisibility;

    private final String gridLineVisibility;

    private final AxisDataOptions dataOptions;

    private final ScrollBarOptions scrollbarOptions;

    private final String axisOffset;

    private AxisDisplayOptions(BuilderImpl builder) {
        this.tickLabelOptions = builder.tickLabelOptions;
        this.axisLineVisibility = builder.axisLineVisibility;
        this.gridLineVisibility = builder.gridLineVisibility;
        this.dataOptions = builder.dataOptions;
        this.scrollbarOptions = builder.scrollbarOptions;
        this.axisOffset = builder.axisOffset;
    }

    /**
     * <p>
     * The tick label options of an axis.
     * </p>
     * 
     * @return The tick label options of an axis.
     */
    public final AxisTickLabelOptions tickLabelOptions() {
        return tickLabelOptions;
    }

    /**
     * <p>
     * Determines whether or not the axis line is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #axisLineVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #axisLineVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the axis line is visible.
     * @see Visibility
     */
    public final Visibility axisLineVisibility() {
        return Visibility.fromValue(axisLineVisibility);
    }

    /**
     * <p>
     * Determines whether or not the axis line is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #axisLineVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #axisLineVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the axis line is visible.
     * @see Visibility
     */
    public final String axisLineVisibilityAsString() {
        return axisLineVisibility;
    }

    /**
     * <p>
     * Determines whether or not the grid line is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gridLineVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #gridLineVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the grid line is visible.
     * @see Visibility
     */
    public final Visibility gridLineVisibility() {
        return Visibility.fromValue(gridLineVisibility);
    }

    /**
     * <p>
     * Determines whether or not the grid line is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gridLineVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #gridLineVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the grid line is visible.
     * @see Visibility
     */
    public final String gridLineVisibilityAsString() {
        return gridLineVisibility;
    }

    /**
     * <p>
     * The data options for an axis.
     * </p>
     * 
     * @return The data options for an axis.
     */
    public final AxisDataOptions dataOptions() {
        return dataOptions;
    }

    /**
     * <p>
     * The scroll bar options for an axis.
     * </p>
     * 
     * @return The scroll bar options for an axis.
     */
    public final ScrollBarOptions scrollbarOptions() {
        return scrollbarOptions;
    }

    /**
     * <p>
     * The offset value that determines the starting placement of the axis within a visual's bounds.
     * </p>
     * 
     * @return The offset value that determines the starting placement of the axis within a visual's bounds.
     */
    public final String axisOffset() {
        return axisOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tickLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(axisLineVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gridLineVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(scrollbarOptions());
        hashCode = 31 * hashCode + Objects.hashCode(axisOffset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisDisplayOptions)) {
            return false;
        }
        AxisDisplayOptions other = (AxisDisplayOptions) obj;
        return Objects.equals(tickLabelOptions(), other.tickLabelOptions())
                && Objects.equals(axisLineVisibilityAsString(), other.axisLineVisibilityAsString())
                && Objects.equals(gridLineVisibilityAsString(), other.gridLineVisibilityAsString())
                && Objects.equals(dataOptions(), other.dataOptions())
                && Objects.equals(scrollbarOptions(), other.scrollbarOptions())
                && Objects.equals(axisOffset(), other.axisOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisDisplayOptions").add("TickLabelOptions", tickLabelOptions())
                .add("AxisLineVisibility", axisLineVisibilityAsString()).add("GridLineVisibility", gridLineVisibilityAsString())
                .add("DataOptions", dataOptions()).add("ScrollbarOptions", scrollbarOptions()).add("AxisOffset", axisOffset())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TickLabelOptions":
            return Optional.ofNullable(clazz.cast(tickLabelOptions()));
        case "AxisLineVisibility":
            return Optional.ofNullable(clazz.cast(axisLineVisibilityAsString()));
        case "GridLineVisibility":
            return Optional.ofNullable(clazz.cast(gridLineVisibilityAsString()));
        case "DataOptions":
            return Optional.ofNullable(clazz.cast(dataOptions()));
        case "ScrollbarOptions":
            return Optional.ofNullable(clazz.cast(scrollbarOptions()));
        case "AxisOffset":
            return Optional.ofNullable(clazz.cast(axisOffset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TickLabelOptions", TICK_LABEL_OPTIONS_FIELD);
        map.put("AxisLineVisibility", AXIS_LINE_VISIBILITY_FIELD);
        map.put("GridLineVisibility", GRID_LINE_VISIBILITY_FIELD);
        map.put("DataOptions", DATA_OPTIONS_FIELD);
        map.put("ScrollbarOptions", SCROLLBAR_OPTIONS_FIELD);
        map.put("AxisOffset", AXIS_OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AxisDisplayOptions, T> g) {
        return obj -> g.apply((AxisDisplayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisDisplayOptions> {
        /**
         * <p>
         * The tick label options of an axis.
         * </p>
         * 
         * @param tickLabelOptions
         *        The tick label options of an axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tickLabelOptions(AxisTickLabelOptions tickLabelOptions);

        /**
         * <p>
         * The tick label options of an axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisTickLabelOptions.Builder} avoiding
         * the need to create one manually via {@link AxisTickLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisTickLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #tickLabelOptions(AxisTickLabelOptions)}.
         * 
         * @param tickLabelOptions
         *        a consumer that will call methods on {@link AxisTickLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tickLabelOptions(AxisTickLabelOptions)
         */
        default Builder tickLabelOptions(Consumer<AxisTickLabelOptions.Builder> tickLabelOptions) {
            return tickLabelOptions(AxisTickLabelOptions.builder().applyMutation(tickLabelOptions).build());
        }

        /**
         * <p>
         * Determines whether or not the axis line is visible.
         * </p>
         * 
         * @param axisLineVisibility
         *        Determines whether or not the axis line is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder axisLineVisibility(String axisLineVisibility);

        /**
         * <p>
         * Determines whether or not the axis line is visible.
         * </p>
         * 
         * @param axisLineVisibility
         *        Determines whether or not the axis line is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder axisLineVisibility(Visibility axisLineVisibility);

        /**
         * <p>
         * Determines whether or not the grid line is visible.
         * </p>
         * 
         * @param gridLineVisibility
         *        Determines whether or not the grid line is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder gridLineVisibility(String gridLineVisibility);

        /**
         * <p>
         * Determines whether or not the grid line is visible.
         * </p>
         * 
         * @param gridLineVisibility
         *        Determines whether or not the grid line is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder gridLineVisibility(Visibility gridLineVisibility);

        /**
         * <p>
         * The data options for an axis.
         * </p>
         * 
         * @param dataOptions
         *        The data options for an axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOptions(AxisDataOptions dataOptions);

        /**
         * <p>
         * The data options for an axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDataOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDataOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDataOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataOptions(AxisDataOptions)}.
         * 
         * @param dataOptions
         *        a consumer that will call methods on {@link AxisDataOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataOptions(AxisDataOptions)
         */
        default Builder dataOptions(Consumer<AxisDataOptions.Builder> dataOptions) {
            return dataOptions(AxisDataOptions.builder().applyMutation(dataOptions).build());
        }

        /**
         * <p>
         * The scroll bar options for an axis.
         * </p>
         * 
         * @param scrollbarOptions
         *        The scroll bar options for an axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scrollbarOptions(ScrollBarOptions scrollbarOptions);

        /**
         * <p>
         * The scroll bar options for an axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScrollBarOptions.Builder} avoiding the
         * need to create one manually via {@link ScrollBarOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScrollBarOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #scrollbarOptions(ScrollBarOptions)}.
         * 
         * @param scrollbarOptions
         *        a consumer that will call methods on {@link ScrollBarOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scrollbarOptions(ScrollBarOptions)
         */
        default Builder scrollbarOptions(Consumer<ScrollBarOptions.Builder> scrollbarOptions) {
            return scrollbarOptions(ScrollBarOptions.builder().applyMutation(scrollbarOptions).build());
        }

        /**
         * <p>
         * The offset value that determines the starting placement of the axis within a visual's bounds.
         * </p>
         * 
         * @param axisOffset
         *        The offset value that determines the starting placement of the axis within a visual's bounds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder axisOffset(String axisOffset);
    }

    static final class BuilderImpl implements Builder {
        private AxisTickLabelOptions tickLabelOptions;

        private String axisLineVisibility;

        private String gridLineVisibility;

        private AxisDataOptions dataOptions;

        private ScrollBarOptions scrollbarOptions;

        private String axisOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisDisplayOptions model) {
            tickLabelOptions(model.tickLabelOptions);
            axisLineVisibility(model.axisLineVisibility);
            gridLineVisibility(model.gridLineVisibility);
            dataOptions(model.dataOptions);
            scrollbarOptions(model.scrollbarOptions);
            axisOffset(model.axisOffset);
        }

        public final AxisTickLabelOptions.Builder getTickLabelOptions() {
            return tickLabelOptions != null ? tickLabelOptions.toBuilder() : null;
        }

        public final void setTickLabelOptions(AxisTickLabelOptions.BuilderImpl tickLabelOptions) {
            this.tickLabelOptions = tickLabelOptions != null ? tickLabelOptions.build() : null;
        }

        @Override
        public final Builder tickLabelOptions(AxisTickLabelOptions tickLabelOptions) {
            this.tickLabelOptions = tickLabelOptions;
            return this;
        }

        public final String getAxisLineVisibility() {
            return axisLineVisibility;
        }

        public final void setAxisLineVisibility(String axisLineVisibility) {
            this.axisLineVisibility = axisLineVisibility;
        }

        @Override
        public final Builder axisLineVisibility(String axisLineVisibility) {
            this.axisLineVisibility = axisLineVisibility;
            return this;
        }

        @Override
        public final Builder axisLineVisibility(Visibility axisLineVisibility) {
            this.axisLineVisibility(axisLineVisibility == null ? null : axisLineVisibility.toString());
            return this;
        }

        public final String getGridLineVisibility() {
            return gridLineVisibility;
        }

        public final void setGridLineVisibility(String gridLineVisibility) {
            this.gridLineVisibility = gridLineVisibility;
        }

        @Override
        public final Builder gridLineVisibility(String gridLineVisibility) {
            this.gridLineVisibility = gridLineVisibility;
            return this;
        }

        @Override
        public final Builder gridLineVisibility(Visibility gridLineVisibility) {
            this.gridLineVisibility(gridLineVisibility == null ? null : gridLineVisibility.toString());
            return this;
        }

        public final AxisDataOptions.Builder getDataOptions() {
            return dataOptions != null ? dataOptions.toBuilder() : null;
        }

        public final void setDataOptions(AxisDataOptions.BuilderImpl dataOptions) {
            this.dataOptions = dataOptions != null ? dataOptions.build() : null;
        }

        @Override
        public final Builder dataOptions(AxisDataOptions dataOptions) {
            this.dataOptions = dataOptions;
            return this;
        }

        public final ScrollBarOptions.Builder getScrollbarOptions() {
            return scrollbarOptions != null ? scrollbarOptions.toBuilder() : null;
        }

        public final void setScrollbarOptions(ScrollBarOptions.BuilderImpl scrollbarOptions) {
            this.scrollbarOptions = scrollbarOptions != null ? scrollbarOptions.build() : null;
        }

        @Override
        public final Builder scrollbarOptions(ScrollBarOptions scrollbarOptions) {
            this.scrollbarOptions = scrollbarOptions;
            return this;
        }

        public final String getAxisOffset() {
            return axisOffset;
        }

        public final void setAxisOffset(String axisOffset) {
            this.axisOffset = axisOffset;
        }

        @Override
        public final Builder axisOffset(String axisOffset) {
            this.axisOffset = axisOffset;
            return this;
        }

        @Override
        public AxisDisplayOptions build() {
            return new AxisDisplayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
