/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the import job that includes details of the requested job's configuration and its current status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobSummary.Builder, AssetBundleImportJobSummary> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(AssetBundleImportJobSummary::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AssetBundleImportJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(AssetBundleImportJobSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_IMPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleImportJobId").getter(getter(AssetBundleImportJobSummary::assetBundleImportJobId))
            .setter(setter(Builder::assetBundleImportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobId").build())
            .build();

    private static final SdkField<String> FAILURE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureAction").getter(getter(AssetBundleImportJobSummary::failureActionAsString))
            .setter(setter(Builder::failureAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, ARN_FIELD,
            CREATED_TIME_FIELD, ASSET_BUNDLE_IMPORT_JOB_ID_FIELD, FAILURE_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobStatus;

    private final String arn;

    private final Instant createdTime;

    private final String assetBundleImportJobId;

    private final String failureAction;

    private AssetBundleImportJobSummary(BuilderImpl builder) {
        this.jobStatus = builder.jobStatus;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleImportJobId = builder.assetBundleImportJobId;
        this.failureAction = builder.failureAction;
    }

    /**
     * <p>
     * The current status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the import job.
     * @see AssetBundleImportJobStatus
     */
    public final AssetBundleImportJobStatus jobStatus() {
        return AssetBundleImportJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the import job.
     * @see AssetBundleImportJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The ARN of the import job.
     * </p>
     * 
     * @return The ARN of the import job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time that the import job was created.
     * </p>
     * 
     * @return The time that the import job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID
     * for another job.
     * </p>
     * 
     * @return The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse
     *         this ID for another job.
     */
    public final String assetBundleImportJobId() {
        return assetBundleImportJobId;
    }

    /**
     * <p>
     * The failure action for the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureAction}
     * will return {@link AssetBundleImportFailureAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #failureActionAsString}.
     * </p>
     * 
     * @return The failure action for the import job.
     * @see AssetBundleImportFailureAction
     */
    public final AssetBundleImportFailureAction failureAction() {
        return AssetBundleImportFailureAction.fromValue(failureAction);
    }

    /**
     * <p>
     * The failure action for the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureAction}
     * will return {@link AssetBundleImportFailureAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #failureActionAsString}.
     * </p>
     * 
     * @return The failure action for the import job.
     * @see AssetBundleImportFailureAction
     */
    public final String failureActionAsString() {
        return failureAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleImportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(failureActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobSummary)) {
            return false;
        }
        AssetBundleImportJobSummary other = (AssetBundleImportJobSummary) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(assetBundleImportJobId(), other.assetBundleImportJobId())
                && Objects.equals(failureActionAsString(), other.failureActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobSummary").add("JobStatus", jobStatusAsString()).add("Arn", arn())
                .add("CreatedTime", createdTime()).add("AssetBundleImportJobId", assetBundleImportJobId())
                .add("FailureAction", failureActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "AssetBundleImportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleImportJobId()));
        case "FailureAction":
            return Optional.ofNullable(clazz.cast(failureActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("AssetBundleImportJobId", ASSET_BUNDLE_IMPORT_JOB_ID_FIELD);
        map.put("FailureAction", FAILURE_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobSummary, T> g) {
        return obj -> g.apply((AssetBundleImportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobSummary> {
        /**
         * <p>
         * The current status of the import job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the import job.
         * @see AssetBundleImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the import job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the import job.
         * @see AssetBundleImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportJobStatus
         */
        Builder jobStatus(AssetBundleImportJobStatus jobStatus);

        /**
         * <p>
         * The ARN of the import job.
         * </p>
         * 
         * @param arn
         *        The ARN of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time that the import job was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this
         * ID for another job.
         * </p>
         * 
         * @param assetBundleImportJobId
         *        The ID of the job. This ID is unique while the job is running. After the job is completed, you can
         *        reuse this ID for another job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleImportJobId(String assetBundleImportJobId);

        /**
         * <p>
         * The failure action for the import job.
         * </p>
         * 
         * @param failureAction
         *        The failure action for the import job.
         * @see AssetBundleImportFailureAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportFailureAction
         */
        Builder failureAction(String failureAction);

        /**
         * <p>
         * The failure action for the import job.
         * </p>
         * 
         * @param failureAction
         *        The failure action for the import job.
         * @see AssetBundleImportFailureAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportFailureAction
         */
        Builder failureAction(AssetBundleImportFailureAction failureAction);
    }

    static final class BuilderImpl implements Builder {
        private String jobStatus;

        private String arn;

        private Instant createdTime;

        private String assetBundleImportJobId;

        private String failureAction;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobSummary model) {
            jobStatus(model.jobStatus);
            arn(model.arn);
            createdTime(model.createdTime);
            assetBundleImportJobId(model.assetBundleImportJobId);
            failureAction(model.failureAction);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleImportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleImportJobId() {
            return assetBundleImportJobId;
        }

        public final void setAssetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
        }

        @Override
        public final Builder assetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
            return this;
        }

        public final String getFailureAction() {
            return failureAction;
        }

        public final void setFailureAction(String failureAction) {
            this.failureAction = failureAction;
        }

        @Override
        public final Builder failureAction(String failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        @Override
        public final Builder failureAction(AssetBundleImportFailureAction failureAction) {
            this.failureAction(failureAction == null ? null : failureAction.toString());
            return this;
        }

        @Override
        public AssetBundleImportJobSummary build() {
            return new AssetBundleImportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
