/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the Anchor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Anchor implements SdkPojo, Serializable, ToCopyableBuilder<Anchor.Builder, Anchor> {
    private static final SdkField<String> ANCHOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnchorType").getter(getter(Anchor::anchorTypeAsString)).setter(setter(Builder::anchorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnchorType").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(Anchor::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Offset").getter(getter(Anchor::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCHOR_TYPE_FIELD,
            TIME_GRANULARITY_FIELD, OFFSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String anchorType;

    private final String timeGranularity;

    private final Integer offset;

    private Anchor(BuilderImpl builder) {
        this.anchorType = builder.anchorType;
        this.timeGranularity = builder.timeGranularity;
        this.offset = builder.offset;
    }

    /**
     * <p>
     * The <code>AnchorType</code> for the Anchor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #anchorType} will
     * return {@link AnchorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #anchorTypeAsString}.
     * </p>
     * 
     * @return The <code>AnchorType</code> for the Anchor.
     * @see AnchorType
     */
    public final AnchorType anchorType() {
        return AnchorType.fromValue(anchorType);
    }

    /**
     * <p>
     * The <code>AnchorType</code> for the Anchor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #anchorType} will
     * return {@link AnchorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #anchorTypeAsString}.
     * </p>
     * 
     * @return The <code>AnchorType</code> for the Anchor.
     * @see AnchorType
     */
    public final String anchorTypeAsString() {
        return anchorType;
    }

    /**
     * <p>
     * The <code>TimeGranularity</code> of the Anchor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The <code>TimeGranularity</code> of the Anchor.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The <code>TimeGranularity</code> of the Anchor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The <code>TimeGranularity</code> of the Anchor.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The offset of the Anchor.
     * </p>
     * 
     * @return The offset of the Anchor.
     */
    public final Integer offset() {
        return offset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anchorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anchor)) {
            return false;
        }
        Anchor other = (Anchor) obj;
        return Objects.equals(anchorTypeAsString(), other.anchorTypeAsString())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(offset(), other.offset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Anchor").add("AnchorType", anchorTypeAsString())
                .add("TimeGranularity", timeGranularityAsString()).add("Offset", offset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnchorType":
            return Optional.ofNullable(clazz.cast(anchorTypeAsString()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnchorType", ANCHOR_TYPE_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        map.put("Offset", OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Anchor, T> g) {
        return obj -> g.apply((Anchor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Anchor> {
        /**
         * <p>
         * The <code>AnchorType</code> for the Anchor.
         * </p>
         * 
         * @param anchorType
         *        The <code>AnchorType</code> for the Anchor.
         * @see AnchorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnchorType
         */
        Builder anchorType(String anchorType);

        /**
         * <p>
         * The <code>AnchorType</code> for the Anchor.
         * </p>
         * 
         * @param anchorType
         *        The <code>AnchorType</code> for the Anchor.
         * @see AnchorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnchorType
         */
        Builder anchorType(AnchorType anchorType);

        /**
         * <p>
         * The <code>TimeGranularity</code> of the Anchor.
         * </p>
         * 
         * @param timeGranularity
         *        The <code>TimeGranularity</code> of the Anchor.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The <code>TimeGranularity</code> of the Anchor.
         * </p>
         * 
         * @param timeGranularity
         *        The <code>TimeGranularity</code> of the Anchor.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);

        /**
         * <p>
         * The offset of the Anchor.
         * </p>
         * 
         * @param offset
         *        The offset of the Anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);
    }

    static final class BuilderImpl implements Builder {
        private String anchorType;

        private String timeGranularity;

        private Integer offset;

        private BuilderImpl() {
        }

        private BuilderImpl(Anchor model) {
            anchorType(model.anchorType);
            timeGranularity(model.timeGranularity);
            offset(model.offset);
        }

        public final String getAnchorType() {
            return anchorType;
        }

        public final void setAnchorType(String anchorType) {
            this.anchorType = anchorType;
        }

        @Override
        public final Builder anchorType(String anchorType) {
            this.anchorType = anchorType;
            return this;
        }

        @Override
        public final Builder anchorType(AnchorType anchorType) {
            this.anchorType(anchorType == null ? null : anchorType.toString());
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final Integer getOffset() {
            return offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public Anchor build() {
            return new Anchor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
