/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FolderArnListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreAnalysisResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, RestoreAnalysisResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(RestoreAnalysisResponse.getter(RestoreAnalysisResponse::status)).setter(RestoreAnalysisResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RestoreAnalysisResponse.getter(RestoreAnalysisResponse::arn)).setter(RestoreAnalysisResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(RestoreAnalysisResponse.getter(RestoreAnalysisResponse::analysisId)).setter(RestoreAnalysisResponse.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(RestoreAnalysisResponse.getter(RestoreAnalysisResponse::requestId)).setter(RestoreAnalysisResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<List<String>> RESTORATION_FAILED_FOLDER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestorationFailedFolderArns").getter(RestoreAnalysisResponse.getter(RestoreAnalysisResponse::restorationFailedFolderArns)).setter(RestoreAnalysisResponse.setter(Builder::restorationFailedFolderArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorationFailedFolderArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ARN_FIELD, ANALYSIS_ID_FIELD, REQUEST_ID_FIELD, RESTORATION_FAILED_FOLDER_ARNS_FIELD));
    private final Integer status;
    private final String arn;
    private final String analysisId;
    private final String requestId;
    private final List<String> restorationFailedFolderArns;

    private RestoreAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.arn = builder.arn;
        this.analysisId = builder.analysisId;
        this.requestId = builder.requestId;
        this.restorationFailedFolderArns = builder.restorationFailedFolderArns;
    }

    public final Integer status() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final boolean hasRestorationFailedFolderArns() {
        return this.restorationFailedFolderArns != null && !(this.restorationFailedFolderArns instanceof SdkAutoConstructList);
    }

    public final List<String> restorationFailedFolderArns() {
        return this.restorationFailedFolderArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestorationFailedFolderArns() ? this.restorationFailedFolderArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreAnalysisResponse)) {
            return false;
        }
        RestoreAnalysisResponse other = (RestoreAnalysisResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.requestId(), other.requestId()) && this.hasRestorationFailedFolderArns() == other.hasRestorationFailedFolderArns() && Objects.equals(this.restorationFailedFolderArns(), other.restorationFailedFolderArns());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreAnalysisResponse").add("Status", (Object)this.status()).add("Arn", (Object)this.arn()).add("AnalysisId", (Object)this.analysisId()).add("RequestId", (Object)this.requestId()).add("RestorationFailedFolderArns", this.hasRestorationFailedFolderArns() ? this.restorationFailedFolderArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "RestorationFailedFolderArns": {
                return Optional.ofNullable(clazz.cast(this.restorationFailedFolderArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreAnalysisResponse, T> g) {
        return obj -> g.apply((RestoreAnalysisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private String arn;
        private String analysisId;
        private String requestId;
        private List<String> restorationFailedFolderArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreAnalysisResponse model) {
            super(model);
            this.status(model.status);
            this.arn(model.arn);
            this.analysisId(model.analysisId);
            this.requestId(model.requestId);
            this.restorationFailedFolderArns(model.restorationFailedFolderArns);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Collection<String> getRestorationFailedFolderArns() {
            if (this.restorationFailedFolderArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.restorationFailedFolderArns;
        }

        public final void setRestorationFailedFolderArns(Collection<String> restorationFailedFolderArns) {
            this.restorationFailedFolderArns = FolderArnListCopier.copy(restorationFailedFolderArns);
        }

        @Override
        public final Builder restorationFailedFolderArns(Collection<String> restorationFailedFolderArns) {
            this.restorationFailedFolderArns = FolderArnListCopier.copy(restorationFailedFolderArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorationFailedFolderArns(String ... restorationFailedFolderArns) {
            this.restorationFailedFolderArns(Arrays.asList(restorationFailedFolderArns));
            return this;
        }

        @Override
        public RestoreAnalysisResponse build() {
            return new RestoreAnalysisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreAnalysisResponse> {
        public Builder status(Integer var1);

        public Builder arn(String var1);

        public Builder analysisId(String var1);

        public Builder requestId(String var1);

        public Builder restorationFailedFolderArns(Collection<String> var1);

        public Builder restorationFailedFolderArns(String ... var1);
    }
}

