/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FilterClass;
import software.amazon.awssdk.services.quicksight.model.NamedFilterType;
import software.amazon.awssdk.services.quicksight.model.SynonymsCopier;
import software.amazon.awssdk.services.quicksight.model.TopicCategoryFilter;
import software.amazon.awssdk.services.quicksight.model.TopicDateRangeFilter;
import software.amazon.awssdk.services.quicksight.model.TopicNumericEqualityFilter;
import software.amazon.awssdk.services.quicksight.model.TopicNumericRangeFilter;
import software.amazon.awssdk.services.quicksight.model.TopicRelativeDateFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicFilter> {
    private static final SdkField<String> FILTER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterDescription").getter(TopicFilter.getter(TopicFilter::filterDescription)).setter(TopicFilter.setter(Builder::filterDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterDescription").build()}).build();
    private static final SdkField<String> FILTER_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterClass").getter(TopicFilter.getter(TopicFilter::filterClassAsString)).setter(TopicFilter.setter(Builder::filterClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterClass").build()}).build();
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterName").getter(TopicFilter.getter(TopicFilter::filterName)).setter(TopicFilter.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterName").build()}).build();
    private static final SdkField<List<String>> FILTER_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterSynonyms").getter(TopicFilter.getter(TopicFilter::filterSynonyms)).setter(TopicFilter.setter(Builder::filterSynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterSynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERAND_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperandFieldName").getter(TopicFilter.getter(TopicFilter::operandFieldName)).setter(TopicFilter.setter(Builder::operandFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperandFieldName").build()}).build();
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterType").getter(TopicFilter.getter(TopicFilter::filterTypeAsString)).setter(TopicFilter.setter(Builder::filterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()}).build();
    private static final SdkField<TopicCategoryFilter> CATEGORY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryFilter").getter(TopicFilter.getter(TopicFilter::categoryFilter)).setter(TopicFilter.setter(Builder::categoryFilter)).constructor(TopicCategoryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilter").build()}).build();
    private static final SdkField<TopicNumericEqualityFilter> NUMERIC_EQUALITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericEqualityFilter").getter(TopicFilter.getter(TopicFilter::numericEqualityFilter)).setter(TopicFilter.setter(Builder::numericEqualityFilter)).constructor(TopicNumericEqualityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericEqualityFilter").build()}).build();
    private static final SdkField<TopicNumericRangeFilter> NUMERIC_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericRangeFilter").getter(TopicFilter.getter(TopicFilter::numericRangeFilter)).setter(TopicFilter.setter(Builder::numericRangeFilter)).constructor(TopicNumericRangeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericRangeFilter").build()}).build();
    private static final SdkField<TopicDateRangeFilter> DATE_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DateRangeFilter").getter(TopicFilter.getter(TopicFilter::dateRangeFilter)).setter(TopicFilter.setter(Builder::dateRangeFilter)).constructor(TopicDateRangeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRangeFilter").build()}).build();
    private static final SdkField<TopicRelativeDateFilter> RELATIVE_DATE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RelativeDateFilter").getter(TopicFilter.getter(TopicFilter::relativeDateFilter)).setter(TopicFilter.setter(Builder::relativeDateFilter)).constructor(TopicRelativeDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_DESCRIPTION_FIELD, FILTER_CLASS_FIELD, FILTER_NAME_FIELD, FILTER_SYNONYMS_FIELD, OPERAND_FIELD_NAME_FIELD, FILTER_TYPE_FIELD, CATEGORY_FILTER_FIELD, NUMERIC_EQUALITY_FILTER_FIELD, NUMERIC_RANGE_FILTER_FIELD, DATE_RANGE_FILTER_FIELD, RELATIVE_DATE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterDescription;
    private final String filterClass;
    private final String filterName;
    private final List<String> filterSynonyms;
    private final String operandFieldName;
    private final String filterType;
    private final TopicCategoryFilter categoryFilter;
    private final TopicNumericEqualityFilter numericEqualityFilter;
    private final TopicNumericRangeFilter numericRangeFilter;
    private final TopicDateRangeFilter dateRangeFilter;
    private final TopicRelativeDateFilter relativeDateFilter;

    private TopicFilter(BuilderImpl builder) {
        this.filterDescription = builder.filterDescription;
        this.filterClass = builder.filterClass;
        this.filterName = builder.filterName;
        this.filterSynonyms = builder.filterSynonyms;
        this.operandFieldName = builder.operandFieldName;
        this.filterType = builder.filterType;
        this.categoryFilter = builder.categoryFilter;
        this.numericEqualityFilter = builder.numericEqualityFilter;
        this.numericRangeFilter = builder.numericRangeFilter;
        this.dateRangeFilter = builder.dateRangeFilter;
        this.relativeDateFilter = builder.relativeDateFilter;
    }

    public final String filterDescription() {
        return this.filterDescription;
    }

    public final FilterClass filterClass() {
        return FilterClass.fromValue(this.filterClass);
    }

    public final String filterClassAsString() {
        return this.filterClass;
    }

    public final String filterName() {
        return this.filterName;
    }

    public final boolean hasFilterSynonyms() {
        return this.filterSynonyms != null && !(this.filterSynonyms instanceof SdkAutoConstructList);
    }

    public final List<String> filterSynonyms() {
        return this.filterSynonyms;
    }

    public final String operandFieldName() {
        return this.operandFieldName;
    }

    public final NamedFilterType filterType() {
        return NamedFilterType.fromValue(this.filterType);
    }

    public final String filterTypeAsString() {
        return this.filterType;
    }

    public final TopicCategoryFilter categoryFilter() {
        return this.categoryFilter;
    }

    public final TopicNumericEqualityFilter numericEqualityFilter() {
        return this.numericEqualityFilter;
    }

    public final TopicNumericRangeFilter numericRangeFilter() {
        return this.numericRangeFilter;
    }

    public final TopicDateRangeFilter dateRangeFilter() {
        return this.dateRangeFilter;
    }

    public final TopicRelativeDateFilter relativeDateFilter() {
        return this.relativeDateFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterSynonyms() ? this.filterSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operandFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeDateFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicFilter)) {
            return false;
        }
        TopicFilter other = (TopicFilter)obj;
        return Objects.equals(this.filterDescription(), other.filterDescription()) && Objects.equals(this.filterClassAsString(), other.filterClassAsString()) && Objects.equals(this.filterName(), other.filterName()) && this.hasFilterSynonyms() == other.hasFilterSynonyms() && Objects.equals(this.filterSynonyms(), other.filterSynonyms()) && Objects.equals(this.operandFieldName(), other.operandFieldName()) && Objects.equals(this.filterTypeAsString(), other.filterTypeAsString()) && Objects.equals(this.categoryFilter(), other.categoryFilter()) && Objects.equals(this.numericEqualityFilter(), other.numericEqualityFilter()) && Objects.equals(this.numericRangeFilter(), other.numericRangeFilter()) && Objects.equals(this.dateRangeFilter(), other.dateRangeFilter()) && Objects.equals(this.relativeDateFilter(), other.relativeDateFilter());
    }

    public final String toString() {
        return ToString.builder((String)"TopicFilter").add("FilterDescription", (Object)this.filterDescription()).add("FilterClass", (Object)this.filterClassAsString()).add("FilterName", (Object)this.filterName()).add("FilterSynonyms", this.hasFilterSynonyms() ? this.filterSynonyms() : null).add("OperandFieldName", (Object)this.operandFieldName()).add("FilterType", (Object)this.filterTypeAsString()).add("CategoryFilter", (Object)this.categoryFilter()).add("NumericEqualityFilter", (Object)this.numericEqualityFilter()).add("NumericRangeFilter", (Object)this.numericRangeFilter()).add("DateRangeFilter", (Object)this.dateRangeFilter()).add("RelativeDateFilter", (Object)this.relativeDateFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterDescription": {
                return Optional.ofNullable(clazz.cast(this.filterDescription()));
            }
            case "FilterClass": {
                return Optional.ofNullable(clazz.cast(this.filterClassAsString()));
            }
            case "FilterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "FilterSynonyms": {
                return Optional.ofNullable(clazz.cast(this.filterSynonyms()));
            }
            case "OperandFieldName": {
                return Optional.ofNullable(clazz.cast(this.operandFieldName()));
            }
            case "FilterType": {
                return Optional.ofNullable(clazz.cast(this.filterTypeAsString()));
            }
            case "CategoryFilter": {
                return Optional.ofNullable(clazz.cast(this.categoryFilter()));
            }
            case "NumericEqualityFilter": {
                return Optional.ofNullable(clazz.cast(this.numericEqualityFilter()));
            }
            case "NumericRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.numericRangeFilter()));
            }
            case "DateRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.dateRangeFilter()));
            }
            case "RelativeDateFilter": {
                return Optional.ofNullable(clazz.cast(this.relativeDateFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilterDescription", FILTER_DESCRIPTION_FIELD);
        map.put("FilterClass", FILTER_CLASS_FIELD);
        map.put("FilterName", FILTER_NAME_FIELD);
        map.put("FilterSynonyms", FILTER_SYNONYMS_FIELD);
        map.put("OperandFieldName", OPERAND_FIELD_NAME_FIELD);
        map.put("FilterType", FILTER_TYPE_FIELD);
        map.put("CategoryFilter", CATEGORY_FILTER_FIELD);
        map.put("NumericEqualityFilter", NUMERIC_EQUALITY_FILTER_FIELD);
        map.put("NumericRangeFilter", NUMERIC_RANGE_FILTER_FIELD);
        map.put("DateRangeFilter", DATE_RANGE_FILTER_FIELD);
        map.put("RelativeDateFilter", RELATIVE_DATE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicFilter, T> g) {
        return obj -> g.apply((TopicFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterDescription;
        private String filterClass;
        private String filterName;
        private List<String> filterSynonyms = DefaultSdkAutoConstructList.getInstance();
        private String operandFieldName;
        private String filterType;
        private TopicCategoryFilter categoryFilter;
        private TopicNumericEqualityFilter numericEqualityFilter;
        private TopicNumericRangeFilter numericRangeFilter;
        private TopicDateRangeFilter dateRangeFilter;
        private TopicRelativeDateFilter relativeDateFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicFilter model) {
            this.filterDescription(model.filterDescription);
            this.filterClass(model.filterClass);
            this.filterName(model.filterName);
            this.filterSynonyms(model.filterSynonyms);
            this.operandFieldName(model.operandFieldName);
            this.filterType(model.filterType);
            this.categoryFilter(model.categoryFilter);
            this.numericEqualityFilter(model.numericEqualityFilter);
            this.numericRangeFilter(model.numericRangeFilter);
            this.dateRangeFilter(model.dateRangeFilter);
            this.relativeDateFilter(model.relativeDateFilter);
        }

        public final String getFilterDescription() {
            return this.filterDescription;
        }

        public final void setFilterDescription(String filterDescription) {
            this.filterDescription = filterDescription;
        }

        @Override
        public final Builder filterDescription(String filterDescription) {
            this.filterDescription = filterDescription;
            return this;
        }

        public final String getFilterClass() {
            return this.filterClass;
        }

        public final void setFilterClass(String filterClass) {
            this.filterClass = filterClass;
        }

        @Override
        public final Builder filterClass(String filterClass) {
            this.filterClass = filterClass;
            return this;
        }

        @Override
        public final Builder filterClass(FilterClass filterClass) {
            this.filterClass(filterClass == null ? null : filterClass.toString());
            return this;
        }

        public final String getFilterName() {
            return this.filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final Collection<String> getFilterSynonyms() {
            if (this.filterSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterSynonyms;
        }

        public final void setFilterSynonyms(Collection<String> filterSynonyms) {
            this.filterSynonyms = SynonymsCopier.copy(filterSynonyms);
        }

        @Override
        public final Builder filterSynonyms(Collection<String> filterSynonyms) {
            this.filterSynonyms = SynonymsCopier.copy(filterSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterSynonyms(String ... filterSynonyms) {
            this.filterSynonyms(Arrays.asList(filterSynonyms));
            return this;
        }

        public final String getOperandFieldName() {
            return this.operandFieldName;
        }

        public final void setOperandFieldName(String operandFieldName) {
            this.operandFieldName = operandFieldName;
        }

        @Override
        public final Builder operandFieldName(String operandFieldName) {
            this.operandFieldName = operandFieldName;
            return this;
        }

        public final String getFilterType() {
            return this.filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(NamedFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final TopicCategoryFilter.Builder getCategoryFilter() {
            return this.categoryFilter != null ? this.categoryFilter.toBuilder() : null;
        }

        public final void setCategoryFilter(TopicCategoryFilter.BuilderImpl categoryFilter) {
            this.categoryFilter = categoryFilter != null ? categoryFilter.build() : null;
        }

        @Override
        public final Builder categoryFilter(TopicCategoryFilter categoryFilter) {
            this.categoryFilter = categoryFilter;
            return this;
        }

        public final TopicNumericEqualityFilter.Builder getNumericEqualityFilter() {
            return this.numericEqualityFilter != null ? this.numericEqualityFilter.toBuilder() : null;
        }

        public final void setNumericEqualityFilter(TopicNumericEqualityFilter.BuilderImpl numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter != null ? numericEqualityFilter.build() : null;
        }

        @Override
        public final Builder numericEqualityFilter(TopicNumericEqualityFilter numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter;
            return this;
        }

        public final TopicNumericRangeFilter.Builder getNumericRangeFilter() {
            return this.numericRangeFilter != null ? this.numericRangeFilter.toBuilder() : null;
        }

        public final void setNumericRangeFilter(TopicNumericRangeFilter.BuilderImpl numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter != null ? numericRangeFilter.build() : null;
        }

        @Override
        public final Builder numericRangeFilter(TopicNumericRangeFilter numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter;
            return this;
        }

        public final TopicDateRangeFilter.Builder getDateRangeFilter() {
            return this.dateRangeFilter != null ? this.dateRangeFilter.toBuilder() : null;
        }

        public final void setDateRangeFilter(TopicDateRangeFilter.BuilderImpl dateRangeFilter) {
            this.dateRangeFilter = dateRangeFilter != null ? dateRangeFilter.build() : null;
        }

        @Override
        public final Builder dateRangeFilter(TopicDateRangeFilter dateRangeFilter) {
            this.dateRangeFilter = dateRangeFilter;
            return this;
        }

        public final TopicRelativeDateFilter.Builder getRelativeDateFilter() {
            return this.relativeDateFilter != null ? this.relativeDateFilter.toBuilder() : null;
        }

        public final void setRelativeDateFilter(TopicRelativeDateFilter.BuilderImpl relativeDateFilter) {
            this.relativeDateFilter = relativeDateFilter != null ? relativeDateFilter.build() : null;
        }

        @Override
        public final Builder relativeDateFilter(TopicRelativeDateFilter relativeDateFilter) {
            this.relativeDateFilter = relativeDateFilter;
            return this;
        }

        public TopicFilter build() {
            return new TopicFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicFilter> {
        public Builder filterDescription(String var1);

        public Builder filterClass(String var1);

        public Builder filterClass(FilterClass var1);

        public Builder filterName(String var1);

        public Builder filterSynonyms(Collection<String> var1);

        public Builder filterSynonyms(String ... var1);

        public Builder operandFieldName(String var1);

        public Builder filterType(String var1);

        public Builder filterType(NamedFilterType var1);

        public Builder categoryFilter(TopicCategoryFilter var1);

        default public Builder categoryFilter(Consumer<TopicCategoryFilter.Builder> categoryFilter) {
            return this.categoryFilter((TopicCategoryFilter)((TopicCategoryFilter.Builder)TopicCategoryFilter.builder().applyMutation(categoryFilter)).build());
        }

        public Builder numericEqualityFilter(TopicNumericEqualityFilter var1);

        default public Builder numericEqualityFilter(Consumer<TopicNumericEqualityFilter.Builder> numericEqualityFilter) {
            return this.numericEqualityFilter((TopicNumericEqualityFilter)((TopicNumericEqualityFilter.Builder)TopicNumericEqualityFilter.builder().applyMutation(numericEqualityFilter)).build());
        }

        public Builder numericRangeFilter(TopicNumericRangeFilter var1);

        default public Builder numericRangeFilter(Consumer<TopicNumericRangeFilter.Builder> numericRangeFilter) {
            return this.numericRangeFilter((TopicNumericRangeFilter)((TopicNumericRangeFilter.Builder)TopicNumericRangeFilter.builder().applyMutation(numericRangeFilter)).build());
        }

        public Builder dateRangeFilter(TopicDateRangeFilter var1);

        default public Builder dateRangeFilter(Consumer<TopicDateRangeFilter.Builder> dateRangeFilter) {
            return this.dateRangeFilter((TopicDateRangeFilter)((TopicDateRangeFilter.Builder)TopicDateRangeFilter.builder().applyMutation(dateRangeFilter)).build());
        }

        public Builder relativeDateFilter(TopicRelativeDateFilter var1);

        default public Builder relativeDateFilter(Consumer<TopicRelativeDateFilter.Builder> relativeDateFilter) {
            return this.relativeDateFilter((TopicRelativeDateFilter)((TopicRelativeDateFilter.Builder)TopicRelativeDateFilter.builder().applyMutation(relativeDateFilter)).build());
        }
    }
}

