/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BrandVersionStatus {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    CREATE_SUCCEEDED("CREATE_SUCCEEDED"),
    CREATE_FAILED("CREATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BrandVersionStatus> VALUE_MAP;
    private final String value;

    private BrandVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrandVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrandVersionStatus> knownValues() {
        EnumSet<BrandVersionStatus> knownValues = EnumSet.allOf(BrandVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BrandVersionStatus.class, BrandVersionStatus::toString);
    }
}

