/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IngestionStatus;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIngestionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateIngestionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateIngestionResponse.getter(CreateIngestionResponse::arn)).setter(CreateIngestionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> INGESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionId").getter(CreateIngestionResponse.getter(CreateIngestionResponse::ingestionId)).setter(CreateIngestionResponse.setter(Builder::ingestionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionId").build()}).build();
    private static final SdkField<String> INGESTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionStatus").getter(CreateIngestionResponse.getter(CreateIngestionResponse::ingestionStatusAsString)).setter(CreateIngestionResponse.setter(Builder::ingestionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatus").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateIngestionResponse.getter(CreateIngestionResponse::requestId)).setter(CreateIngestionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateIngestionResponse.getter(CreateIngestionResponse::status)).setter(CreateIngestionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, INGESTION_ID_FIELD, INGESTION_STATUS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIngestionResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String ingestionId;
    private final String ingestionStatus;
    private final String requestId;
    private final Integer status;

    private CreateIngestionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.ingestionId = builder.ingestionId;
        this.ingestionStatus = builder.ingestionStatus;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String ingestionId() {
        return this.ingestionId;
    }

    public final IngestionStatus ingestionStatus() {
        return IngestionStatus.fromValue(this.ingestionStatus);
    }

    public final String ingestionStatusAsString() {
        return this.ingestionStatus;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestionResponse)) {
            return false;
        }
        CreateIngestionResponse other = (CreateIngestionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.ingestionId(), other.ingestionId()) && Objects.equals(this.ingestionStatusAsString(), other.ingestionStatusAsString()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIngestionResponse").add("Arn", (Object)this.arn()).add("IngestionId", (Object)this.ingestionId()).add("IngestionStatus", (Object)this.ingestionStatusAsString()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "IngestionId": {
                return Optional.ofNullable(clazz.cast(this.ingestionId()));
            }
            case "IngestionStatus": {
                return Optional.ofNullable(clazz.cast(this.ingestionStatusAsString()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("IngestionId", INGESTION_ID_FIELD);
        map.put("IngestionStatus", INGESTION_STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestionResponse, T> g) {
        return obj -> g.apply((CreateIngestionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String ingestionId;
        private String ingestionStatus;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestionResponse model) {
            super(model);
            this.arn(model.arn);
            this.ingestionId(model.ingestionId);
            this.ingestionStatus(model.ingestionStatus);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getIngestionId() {
            return this.ingestionId;
        }

        public final void setIngestionId(String ingestionId) {
            this.ingestionId = ingestionId;
        }

        @Override
        public final Builder ingestionId(String ingestionId) {
            this.ingestionId = ingestionId;
            return this;
        }

        public final String getIngestionStatus() {
            return this.ingestionStatus;
        }

        public final void setIngestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
        }

        @Override
        public final Builder ingestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
            return this;
        }

        @Override
        public final Builder ingestionStatus(IngestionStatus ingestionStatus) {
            this.ingestionStatus(ingestionStatus == null ? null : ingestionStatus.toString());
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateIngestionResponse build() {
            return new CreateIngestionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIngestionResponse> {
        public Builder arn(String var1);

        public Builder ingestionId(String var1);

        public Builder ingestionStatus(String var1);

        public Builder ingestionStatus(IngestionStatus var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

