/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GeospatialGradientStepColor;
import software.amazon.awssdk.services.quicksight.model.GeospatialGradientStepColorListCopier;
import software.amazon.awssdk.services.quicksight.model.GeospatialNullDataSettings;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialGradientColor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialGradientColor> {
    private static final SdkField<List<GeospatialGradientStepColor>> STEP_COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepColors").getter(GeospatialGradientColor.getter(GeospatialGradientColor::stepColors)).setter(GeospatialGradientColor.setter(Builder::stepColors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepColors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeospatialGradientStepColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NULL_DATA_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullDataVisibility").getter(GeospatialGradientColor.getter(GeospatialGradientColor::nullDataVisibilityAsString)).setter(GeospatialGradientColor.setter(Builder::nullDataVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataVisibility").build()}).build();
    private static final SdkField<GeospatialNullDataSettings> NULL_DATA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NullDataSettings").getter(GeospatialGradientColor.getter(GeospatialGradientColor::nullDataSettings)).setter(GeospatialGradientColor.setter(Builder::nullDataSettings)).constructor(GeospatialNullDataSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataSettings").build()}).build();
    private static final SdkField<Double> DEFAULT_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DefaultOpacity").getter(GeospatialGradientColor.getter(GeospatialGradientColor::defaultOpacity)).setter(GeospatialGradientColor.setter(Builder::defaultOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOpacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_COLORS_FIELD, NULL_DATA_VISIBILITY_FIELD, NULL_DATA_SETTINGS_FIELD, DEFAULT_OPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeospatialGradientColor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GeospatialGradientStepColor> stepColors;
    private final String nullDataVisibility;
    private final GeospatialNullDataSettings nullDataSettings;
    private final Double defaultOpacity;

    private GeospatialGradientColor(BuilderImpl builder) {
        this.stepColors = builder.stepColors;
        this.nullDataVisibility = builder.nullDataVisibility;
        this.nullDataSettings = builder.nullDataSettings;
        this.defaultOpacity = builder.defaultOpacity;
    }

    public final boolean hasStepColors() {
        return this.stepColors != null && !(this.stepColors instanceof SdkAutoConstructList);
    }

    public final List<GeospatialGradientStepColor> stepColors() {
        return this.stepColors;
    }

    public final Visibility nullDataVisibility() {
        return Visibility.fromValue(this.nullDataVisibility);
    }

    public final String nullDataVisibilityAsString() {
        return this.nullDataVisibility;
    }

    public final GeospatialNullDataSettings nullDataSettings() {
        return this.nullDataSettings;
    }

    public final Double defaultOpacity() {
        return this.defaultOpacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepColors() ? this.stepColors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nullDataVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullDataSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOpacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialGradientColor)) {
            return false;
        }
        GeospatialGradientColor other = (GeospatialGradientColor)obj;
        return this.hasStepColors() == other.hasStepColors() && Objects.equals(this.stepColors(), other.stepColors()) && Objects.equals(this.nullDataVisibilityAsString(), other.nullDataVisibilityAsString()) && Objects.equals(this.nullDataSettings(), other.nullDataSettings()) && Objects.equals(this.defaultOpacity(), other.defaultOpacity());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialGradientColor").add("StepColors", this.hasStepColors() ? this.stepColors() : null).add("NullDataVisibility", (Object)this.nullDataVisibilityAsString()).add("NullDataSettings", (Object)this.nullDataSettings()).add("DefaultOpacity", (Object)this.defaultOpacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepColors": {
                return Optional.ofNullable(clazz.cast(this.stepColors()));
            }
            case "NullDataVisibility": {
                return Optional.ofNullable(clazz.cast(this.nullDataVisibilityAsString()));
            }
            case "NullDataSettings": {
                return Optional.ofNullable(clazz.cast(this.nullDataSettings()));
            }
            case "DefaultOpacity": {
                return Optional.ofNullable(clazz.cast(this.defaultOpacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StepColors", STEP_COLORS_FIELD);
        map.put("NullDataVisibility", NULL_DATA_VISIBILITY_FIELD);
        map.put("NullDataSettings", NULL_DATA_SETTINGS_FIELD);
        map.put("DefaultOpacity", DEFAULT_OPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialGradientColor, T> g) {
        return obj -> g.apply((GeospatialGradientColor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GeospatialGradientStepColor> stepColors = DefaultSdkAutoConstructList.getInstance();
        private String nullDataVisibility;
        private GeospatialNullDataSettings nullDataSettings;
        private Double defaultOpacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialGradientColor model) {
            this.stepColors(model.stepColors);
            this.nullDataVisibility(model.nullDataVisibility);
            this.nullDataSettings(model.nullDataSettings);
            this.defaultOpacity(model.defaultOpacity);
        }

        public final List<GeospatialGradientStepColor.Builder> getStepColors() {
            List<GeospatialGradientStepColor.Builder> result = GeospatialGradientStepColorListCopier.copyToBuilder(this.stepColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepColors(Collection<GeospatialGradientStepColor.BuilderImpl> stepColors) {
            this.stepColors = GeospatialGradientStepColorListCopier.copyFromBuilder(stepColors);
        }

        @Override
        public final Builder stepColors(Collection<GeospatialGradientStepColor> stepColors) {
            this.stepColors = GeospatialGradientStepColorListCopier.copy(stepColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepColors(GeospatialGradientStepColor ... stepColors) {
            this.stepColors(Arrays.asList(stepColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepColors(Consumer<GeospatialGradientStepColor.Builder> ... stepColors) {
            this.stepColors(Stream.of(stepColors).map(c -> (GeospatialGradientStepColor)((GeospatialGradientStepColor.Builder)GeospatialGradientStepColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNullDataVisibility() {
            return this.nullDataVisibility;
        }

        public final void setNullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
        }

        @Override
        public final Builder nullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
            return this;
        }

        @Override
        public final Builder nullDataVisibility(Visibility nullDataVisibility) {
            this.nullDataVisibility(nullDataVisibility == null ? null : nullDataVisibility.toString());
            return this;
        }

        public final GeospatialNullDataSettings.Builder getNullDataSettings() {
            return this.nullDataSettings != null ? this.nullDataSettings.toBuilder() : null;
        }

        public final void setNullDataSettings(GeospatialNullDataSettings.BuilderImpl nullDataSettings) {
            this.nullDataSettings = nullDataSettings != null ? nullDataSettings.build() : null;
        }

        @Override
        public final Builder nullDataSettings(GeospatialNullDataSettings nullDataSettings) {
            this.nullDataSettings = nullDataSettings;
            return this;
        }

        public final Double getDefaultOpacity() {
            return this.defaultOpacity;
        }

        public final void setDefaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
        }

        @Override
        public final Builder defaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
            return this;
        }

        public GeospatialGradientColor build() {
            return new GeospatialGradientColor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialGradientColor> {
        public Builder stepColors(Collection<GeospatialGradientStepColor> var1);

        public Builder stepColors(GeospatialGradientStepColor ... var1);

        public Builder stepColors(Consumer<GeospatialGradientStepColor.Builder> ... var1);

        public Builder nullDataVisibility(String var1);

        public Builder nullDataVisibility(Visibility var1);

        public Builder nullDataSettings(GeospatialNullDataSettings var1);

        default public Builder nullDataSettings(Consumer<GeospatialNullDataSettings.Builder> nullDataSettings) {
            return this.nullDataSettings((GeospatialNullDataSettings)((GeospatialNullDataSettings.Builder)GeospatialNullDataSettings.builder().applyMutation(nullDataSettings)).build());
        }

        public Builder defaultOpacity(Double var1);
    }
}

