/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IncludeGeneratedAnswer;
import software.amazon.awssdk.services.quicksight.model.IncludeQuickSightQIndex;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictQaResultsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, PredictQaResultsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(PredictQaResultsRequest.getter(PredictQaResultsRequest::awsAccountId)).setter(PredictQaResultsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(PredictQaResultsRequest.getter(PredictQaResultsRequest::queryText)).setter(PredictQaResultsRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<String> INCLUDE_QUICK_SIGHT_Q_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncludeQuickSightQIndex").getter(PredictQaResultsRequest.getter(PredictQaResultsRequest::includeQuickSightQIndexAsString)).setter(PredictQaResultsRequest.setter(Builder::includeQuickSightQIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeQuickSightQIndex").build()}).build();
    private static final SdkField<String> INCLUDE_GENERATED_ANSWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncludeGeneratedAnswer").getter(PredictQaResultsRequest.getter(PredictQaResultsRequest::includeGeneratedAnswerAsString)).setter(PredictQaResultsRequest.setter(Builder::includeGeneratedAnswer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGeneratedAnswer").build()}).build();
    private static final SdkField<Integer> MAX_TOPICS_TO_CONSIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxTopicsToConsider").getter(PredictQaResultsRequest.getter(PredictQaResultsRequest::maxTopicsToConsider)).setter(PredictQaResultsRequest.setter(Builder::maxTopicsToConsider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTopicsToConsider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, QUERY_TEXT_FIELD, INCLUDE_QUICK_SIGHT_Q_INDEX_FIELD, INCLUDE_GENERATED_ANSWER_FIELD, MAX_TOPICS_TO_CONSIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("QueryText", QUERY_TEXT_FIELD);
            this.put("IncludeQuickSightQIndex", INCLUDE_QUICK_SIGHT_Q_INDEX_FIELD);
            this.put("IncludeGeneratedAnswer", INCLUDE_GENERATED_ANSWER_FIELD);
            this.put("MaxTopicsToConsider", MAX_TOPICS_TO_CONSIDER_FIELD);
        }
    });
    private final String awsAccountId;
    private final String queryText;
    private final String includeQuickSightQIndex;
    private final String includeGeneratedAnswer;
    private final Integer maxTopicsToConsider;

    private PredictQaResultsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.queryText = builder.queryText;
        this.includeQuickSightQIndex = builder.includeQuickSightQIndex;
        this.includeGeneratedAnswer = builder.includeGeneratedAnswer;
        this.maxTopicsToConsider = builder.maxTopicsToConsider;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final IncludeQuickSightQIndex includeQuickSightQIndex() {
        return IncludeQuickSightQIndex.fromValue(this.includeQuickSightQIndex);
    }

    public final String includeQuickSightQIndexAsString() {
        return this.includeQuickSightQIndex;
    }

    public final IncludeGeneratedAnswer includeGeneratedAnswer() {
        return IncludeGeneratedAnswer.fromValue(this.includeGeneratedAnswer);
    }

    public final String includeGeneratedAnswerAsString() {
        return this.includeGeneratedAnswer;
    }

    public final Integer maxTopicsToConsider() {
        return this.maxTopicsToConsider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeQuickSightQIndexAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGeneratedAnswerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTopicsToConsider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictQaResultsRequest)) {
            return false;
        }
        PredictQaResultsRequest other = (PredictQaResultsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.includeQuickSightQIndexAsString(), other.includeQuickSightQIndexAsString()) && Objects.equals(this.includeGeneratedAnswerAsString(), other.includeGeneratedAnswerAsString()) && Objects.equals(this.maxTopicsToConsider(), other.maxTopicsToConsider());
    }

    public final String toString() {
        return ToString.builder((String)"PredictQaResultsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("QueryText", (Object)(this.queryText() == null ? null : "*** Sensitive Data Redacted ***")).add("IncludeQuickSightQIndex", (Object)this.includeQuickSightQIndexAsString()).add("IncludeGeneratedAnswer", (Object)this.includeGeneratedAnswerAsString()).add("MaxTopicsToConsider", (Object)this.maxTopicsToConsider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "IncludeQuickSightQIndex": {
                return Optional.ofNullable(clazz.cast(this.includeQuickSightQIndexAsString()));
            }
            case "IncludeGeneratedAnswer": {
                return Optional.ofNullable(clazz.cast(this.includeGeneratedAnswerAsString()));
            }
            case "MaxTopicsToConsider": {
                return Optional.ofNullable(clazz.cast(this.maxTopicsToConsider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PredictQaResultsRequest, T> g) {
        return obj -> g.apply((PredictQaResultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String queryText;
        private String includeQuickSightQIndex;
        private String includeGeneratedAnswer;
        private Integer maxTopicsToConsider;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictQaResultsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.queryText(model.queryText);
            this.includeQuickSightQIndex(model.includeQuickSightQIndex);
            this.includeGeneratedAnswer(model.includeGeneratedAnswer);
            this.maxTopicsToConsider(model.maxTopicsToConsider);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final String getIncludeQuickSightQIndex() {
            return this.includeQuickSightQIndex;
        }

        public final void setIncludeQuickSightQIndex(String includeQuickSightQIndex) {
            this.includeQuickSightQIndex = includeQuickSightQIndex;
        }

        @Override
        public final Builder includeQuickSightQIndex(String includeQuickSightQIndex) {
            this.includeQuickSightQIndex = includeQuickSightQIndex;
            return this;
        }

        @Override
        public final Builder includeQuickSightQIndex(IncludeQuickSightQIndex includeQuickSightQIndex) {
            this.includeQuickSightQIndex(includeQuickSightQIndex == null ? null : includeQuickSightQIndex.toString());
            return this;
        }

        public final String getIncludeGeneratedAnswer() {
            return this.includeGeneratedAnswer;
        }

        public final void setIncludeGeneratedAnswer(String includeGeneratedAnswer) {
            this.includeGeneratedAnswer = includeGeneratedAnswer;
        }

        @Override
        public final Builder includeGeneratedAnswer(String includeGeneratedAnswer) {
            this.includeGeneratedAnswer = includeGeneratedAnswer;
            return this;
        }

        @Override
        public final Builder includeGeneratedAnswer(IncludeGeneratedAnswer includeGeneratedAnswer) {
            this.includeGeneratedAnswer(includeGeneratedAnswer == null ? null : includeGeneratedAnswer.toString());
            return this;
        }

        public final Integer getMaxTopicsToConsider() {
            return this.maxTopicsToConsider;
        }

        public final void setMaxTopicsToConsider(Integer maxTopicsToConsider) {
            this.maxTopicsToConsider = maxTopicsToConsider;
        }

        @Override
        public final Builder maxTopicsToConsider(Integer maxTopicsToConsider) {
            this.maxTopicsToConsider = maxTopicsToConsider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PredictQaResultsRequest build() {
            return new PredictQaResultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PredictQaResultsRequest> {
        public Builder awsAccountId(String var1);

        public Builder queryText(String var1);

        public Builder includeQuickSightQIndex(String var1);

        public Builder includeQuickSightQIndex(IncludeQuickSightQIndex var1);

        public Builder includeGeneratedAnswer(String var1);

        public Builder includeGeneratedAnswer(IncludeGeneratedAnswer var1);

        public Builder maxTopicsToConsider(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

