/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.GeneratedAnswerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratedAnswerResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeneratedAnswerResult> {
    private static final SdkField<String> QUESTION_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionText").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::questionText)).setter(GeneratedAnswerResult.setter(Builder::questionText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionText").build()}).build();
    private static final SdkField<String> ANSWER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnswerStatus").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::answerStatusAsString)).setter(GeneratedAnswerResult.setter(Builder::answerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerStatus").build()}).build();
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::topicId)).setter(GeneratedAnswerResult.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::topicName)).setter(GeneratedAnswerResult.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> RESTATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Restatement").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::restatement)).setter(GeneratedAnswerResult.setter(Builder::restatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restatement").build()}).build();
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::questionId)).setter(GeneratedAnswerResult.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> ANSWER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnswerId").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::answerId)).setter(GeneratedAnswerResult.setter(Builder::answerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerId").build()}).build();
    private static final SdkField<String> QUESTION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionUrl").getter(GeneratedAnswerResult.getter(GeneratedAnswerResult::questionUrl)).setter(GeneratedAnswerResult.setter(Builder::questionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_TEXT_FIELD, ANSWER_STATUS_FIELD, TOPIC_ID_FIELD, TOPIC_NAME_FIELD, RESTATEMENT_FIELD, QUESTION_ID_FIELD, ANSWER_ID_FIELD, QUESTION_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QuestionText", QUESTION_TEXT_FIELD);
            this.put("AnswerStatus", ANSWER_STATUS_FIELD);
            this.put("TopicId", TOPIC_ID_FIELD);
            this.put("TopicName", TOPIC_NAME_FIELD);
            this.put("Restatement", RESTATEMENT_FIELD);
            this.put("QuestionId", QUESTION_ID_FIELD);
            this.put("AnswerId", ANSWER_ID_FIELD);
            this.put("QuestionUrl", QUESTION_URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String questionText;
    private final String answerStatus;
    private final String topicId;
    private final String topicName;
    private final String restatement;
    private final String questionId;
    private final String answerId;
    private final String questionUrl;

    private GeneratedAnswerResult(BuilderImpl builder) {
        this.questionText = builder.questionText;
        this.answerStatus = builder.answerStatus;
        this.topicId = builder.topicId;
        this.topicName = builder.topicName;
        this.restatement = builder.restatement;
        this.questionId = builder.questionId;
        this.answerId = builder.answerId;
        this.questionUrl = builder.questionUrl;
    }

    public final String questionText() {
        return this.questionText;
    }

    public final GeneratedAnswerStatus answerStatus() {
        return GeneratedAnswerStatus.fromValue(this.answerStatus);
    }

    public final String answerStatusAsString() {
        return this.answerStatus;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final String restatement() {
        return this.restatement;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String answerId() {
        return this.answerId;
    }

    public final String questionUrl() {
        return this.questionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionText());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedAnswerResult)) {
            return false;
        }
        GeneratedAnswerResult other = (GeneratedAnswerResult)obj;
        return Objects.equals(this.questionText(), other.questionText()) && Objects.equals(this.answerStatusAsString(), other.answerStatusAsString()) && Objects.equals(this.topicId(), other.topicId()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.restatement(), other.restatement()) && Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.answerId(), other.answerId()) && Objects.equals(this.questionUrl(), other.questionUrl());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratedAnswerResult").add("QuestionText", (Object)(this.questionText() == null ? null : "*** Sensitive Data Redacted ***")).add("AnswerStatus", (Object)this.answerStatusAsString()).add("TopicId", (Object)this.topicId()).add("TopicName", (Object)this.topicName()).add("Restatement", (Object)(this.restatement() == null ? null : "*** Sensitive Data Redacted ***")).add("QuestionId", (Object)this.questionId()).add("AnswerId", (Object)this.answerId()).add("QuestionUrl", (Object)this.questionUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionText": {
                return Optional.ofNullable(clazz.cast(this.questionText()));
            }
            case "AnswerStatus": {
                return Optional.ofNullable(clazz.cast(this.answerStatusAsString()));
            }
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "Restatement": {
                return Optional.ofNullable(clazz.cast(this.restatement()));
            }
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "AnswerId": {
                return Optional.ofNullable(clazz.cast(this.answerId()));
            }
            case "QuestionUrl": {
                return Optional.ofNullable(clazz.cast(this.questionUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeneratedAnswerResult, T> g) {
        return obj -> g.apply((GeneratedAnswerResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionText;
        private String answerStatus;
        private String topicId;
        private String topicName;
        private String restatement;
        private String questionId;
        private String answerId;
        private String questionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedAnswerResult model) {
            this.questionText(model.questionText);
            this.answerStatus(model.answerStatus);
            this.topicId(model.topicId);
            this.topicName(model.topicName);
            this.restatement(model.restatement);
            this.questionId(model.questionId);
            this.answerId(model.answerId);
            this.questionUrl(model.questionUrl);
        }

        public final String getQuestionText() {
            return this.questionText;
        }

        public final void setQuestionText(String questionText) {
            this.questionText = questionText;
        }

        @Override
        public final Builder questionText(String questionText) {
            this.questionText = questionText;
            return this;
        }

        public final String getAnswerStatus() {
            return this.answerStatus;
        }

        public final void setAnswerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
        }

        @Override
        public final Builder answerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
            return this;
        }

        @Override
        public final Builder answerStatus(GeneratedAnswerStatus answerStatus) {
            this.answerStatus(answerStatus == null ? null : answerStatus.toString());
            return this;
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getRestatement() {
            return this.restatement;
        }

        public final void setRestatement(String restatement) {
            this.restatement = restatement;
        }

        @Override
        public final Builder restatement(String restatement) {
            this.restatement = restatement;
            return this;
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getAnswerId() {
            return this.answerId;
        }

        public final void setAnswerId(String answerId) {
            this.answerId = answerId;
        }

        @Override
        public final Builder answerId(String answerId) {
            this.answerId = answerId;
            return this;
        }

        public final String getQuestionUrl() {
            return this.questionUrl;
        }

        public final void setQuestionUrl(String questionUrl) {
            this.questionUrl = questionUrl;
        }

        @Override
        public final Builder questionUrl(String questionUrl) {
            this.questionUrl = questionUrl;
            return this;
        }

        public GeneratedAnswerResult build() {
            return new GeneratedAnswerResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeneratedAnswerResult> {
        public Builder questionText(String var1);

        public Builder answerStatus(String var1);

        public Builder answerStatus(GeneratedAnswerStatus var1);

        public Builder topicId(String var1);

        public Builder topicName(String var1);

        public Builder restatement(String var1);

        public Builder questionId(String var1);

        public Builder answerId(String var1);

        public Builder questionUrl(String var1);
    }
}

