/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IdentityStore;
import software.amazon.awssdk.services.quicksight.model.NamespaceStatus;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNamespaceResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateNamespaceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateNamespaceResponse.getter(CreateNamespaceResponse::arn)).setter(CreateNamespaceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNamespaceResponse.getter(CreateNamespaceResponse::name)).setter(CreateNamespaceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CAPACITY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityRegion").getter(CreateNamespaceResponse.getter(CreateNamespaceResponse::capacityRegion)).setter(CreateNamespaceResponse.setter(Builder::capacityRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRegion").build()}).build();
    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationStatus").getter(CreateNamespaceResponse.getter(CreateNamespaceResponse::creationStatusAsString)).setter(CreateNamespaceResponse.setter(Builder::creationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStore").getter(CreateNamespaceResponse.getter(CreateNamespaceResponse::identityStoreAsString)).setter(CreateNamespaceResponse.setter(Builder::identityStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStore").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateNamespaceResponse.getter(CreateNamespaceResponse::requestId)).setter(CreateNamespaceResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateNamespaceResponse.getter(CreateNamespaceResponse::status)).setter(CreateNamespaceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, CAPACITY_REGION_FIELD, CREATION_STATUS_FIELD, IDENTITY_STORE_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("CapacityRegion", CAPACITY_REGION_FIELD);
            this.put("CreationStatus", CREATION_STATUS_FIELD);
            this.put("IdentityStore", IDENTITY_STORE_FIELD);
            this.put("RequestId", REQUEST_ID_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final String arn;
    private final String name;
    private final String capacityRegion;
    private final String creationStatus;
    private final String identityStore;
    private final String requestId;
    private final Integer status;

    private CreateNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.capacityRegion = builder.capacityRegion;
        this.creationStatus = builder.creationStatus;
        this.identityStore = builder.identityStore;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String capacityRegion() {
        return this.capacityRegion;
    }

    public final NamespaceStatus creationStatus() {
        return NamespaceStatus.fromValue(this.creationStatus);
    }

    public final String creationStatusAsString() {
        return this.creationStatus;
    }

    public final IdentityStore identityStore() {
        return IdentityStore.fromValue(this.identityStore);
    }

    public final String identityStoreAsString() {
        return this.identityStore;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNamespaceResponse)) {
            return false;
        }
        CreateNamespaceResponse other = (CreateNamespaceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.capacityRegion(), other.capacityRegion()) && Objects.equals(this.creationStatusAsString(), other.creationStatusAsString()) && Objects.equals(this.identityStoreAsString(), other.identityStoreAsString()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNamespaceResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("CapacityRegion", (Object)this.capacityRegion()).add("CreationStatus", (Object)this.creationStatusAsString()).add("IdentityStore", (Object)this.identityStoreAsString()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CapacityRegion": {
                return Optional.ofNullable(clazz.cast(this.capacityRegion()));
            }
            case "CreationStatus": {
                return Optional.ofNullable(clazz.cast(this.creationStatusAsString()));
            }
            case "IdentityStore": {
                return Optional.ofNullable(clazz.cast(this.identityStoreAsString()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateNamespaceResponse, T> g) {
        return obj -> g.apply((CreateNamespaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String capacityRegion;
        private String creationStatus;
        private String identityStore;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNamespaceResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.capacityRegion(model.capacityRegion);
            this.creationStatus(model.creationStatus);
            this.identityStore(model.identityStore);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCapacityRegion() {
            return this.capacityRegion;
        }

        public final void setCapacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
        }

        @Override
        public final Builder capacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
            return this;
        }

        public final String getCreationStatus() {
            return this.creationStatus;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(NamespaceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final String getIdentityStore() {
            return this.identityStore;
        }

        public final void setIdentityStore(String identityStore) {
            this.identityStore = identityStore;
        }

        @Override
        public final Builder identityStore(String identityStore) {
            this.identityStore = identityStore;
            return this;
        }

        @Override
        public final Builder identityStore(IdentityStore identityStore) {
            this.identityStore(identityStore == null ? null : identityStore.toString());
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateNamespaceResponse build() {
            return new CreateNamespaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNamespaceResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder capacityRegion(String var1);

        public Builder creationStatus(String var1);

        public Builder creationStatus(NamespaceStatus var1);

        public Builder identityStore(String var1);

        public Builder identityStore(IdentityStore var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

