/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsResponse;
import software.amazon.awssdk.services.quicksight.model.TopicSummary;

public class SearchTopicsIterable
implements SdkIterable<SearchTopicsResponse> {
    private final QuickSightClient client;
    private final SearchTopicsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchTopicsIterable(QuickSightClient client, SearchTopicsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchTopicsResponseFetcher();
    }

    public Iterator<SearchTopicsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TopicSummary> topicSummaryList() {
        Function<SearchTopicsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topicSummaryList() != null) {
                return response.topicSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchTopicsResponseFetcher
    implements SyncPageFetcher<SearchTopicsResponse> {
        private SearchTopicsResponseFetcher() {
        }

        public boolean hasNextPage(SearchTopicsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchTopicsResponse nextPage(SearchTopicsResponse previousPage) {
            if (previousPage == null) {
                return SearchTopicsIterable.this.client.searchTopics(SearchTopicsIterable.this.firstRequest);
            }
            return SearchTopicsIterable.this.client.searchTopics((SearchTopicsRequest)((Object)SearchTopicsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

