/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourcePermissions;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobAnalysisOverridePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobAnalysisOverridePermissions> {
    private static final SdkField<List<String>> ANALYSIS_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisIds").getter(AssetBundleImportJobAnalysisOverridePermissions.getter(AssetBundleImportJobAnalysisOverridePermissions::analysisIds)).setter(AssetBundleImportJobAnalysisOverridePermissions.setter(Builder::analysisIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssetBundleResourcePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(AssetBundleImportJobAnalysisOverridePermissions.getter(AssetBundleImportJobAnalysisOverridePermissions::permissions)).setter(AssetBundleImportJobAnalysisOverridePermissions.setter(Builder::permissions)).constructor(AssetBundleResourcePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_IDS_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AnalysisIds", ANALYSIS_IDS_FIELD);
            this.put("Permissions", PERMISSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> analysisIds;
    private final AssetBundleResourcePermissions permissions;

    private AssetBundleImportJobAnalysisOverridePermissions(BuilderImpl builder) {
        this.analysisIds = builder.analysisIds;
        this.permissions = builder.permissions;
    }

    public final boolean hasAnalysisIds() {
        return this.analysisIds != null && !(this.analysisIds instanceof SdkAutoConstructList);
    }

    public final List<String> analysisIds() {
        return this.analysisIds;
    }

    public final AssetBundleResourcePermissions permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisIds() ? this.analysisIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobAnalysisOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobAnalysisOverridePermissions other = (AssetBundleImportJobAnalysisOverridePermissions)obj;
        return this.hasAnalysisIds() == other.hasAnalysisIds() && Objects.equals(this.analysisIds(), other.analysisIds()) && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobAnalysisOverridePermissions").add("AnalysisIds", this.hasAnalysisIds() ? this.analysisIds() : null).add("Permissions", (Object)this.permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisIds": {
                return Optional.ofNullable(clazz.cast(this.analysisIds()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobAnalysisOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobAnalysisOverridePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> analysisIds = DefaultSdkAutoConstructList.getInstance();
        private AssetBundleResourcePermissions permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobAnalysisOverridePermissions model) {
            this.analysisIds(model.analysisIds);
            this.permissions(model.permissions);
        }

        public final Collection<String> getAnalysisIds() {
            if (this.analysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisIds;
        }

        public final void setAnalysisIds(Collection<String> analysisIds) {
            this.analysisIds = AssetBundleRestrictiveResourceIdListCopier.copy(analysisIds);
        }

        @Override
        public final Builder analysisIds(Collection<String> analysisIds) {
            this.analysisIds = AssetBundleRestrictiveResourceIdListCopier.copy(analysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisIds(String ... analysisIds) {
            this.analysisIds(Arrays.asList(analysisIds));
            return this;
        }

        public final AssetBundleResourcePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(AssetBundleResourcePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(AssetBundleResourcePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public AssetBundleImportJobAnalysisOverridePermissions build() {
            return new AssetBundleImportJobAnalysisOverridePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobAnalysisOverridePermissions> {
        public Builder analysisIds(Collection<String> var1);

        public Builder analysisIds(String ... var1);

        public Builder permissions(AssetBundleResourcePermissions var1);

        default public Builder permissions(Consumer<AssetBundleResourcePermissions.Builder> permissions) {
            return this.permissions((AssetBundleResourcePermissions)((AssetBundleResourcePermissions.Builder)AssetBundleResourcePermissions.builder().applyMutation(permissions)).build());
        }
    }
}

