/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.LinkEntityArnListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardLinksRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateDashboardLinksRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateDashboardLinksRequest.getter(UpdateDashboardLinksRequest::awsAccountId)).setter(UpdateDashboardLinksRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(UpdateDashboardLinksRequest.getter(UpdateDashboardLinksRequest::dashboardId)).setter(UpdateDashboardLinksRequest.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()}).build();
    private static final SdkField<List<String>> LINK_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkEntities").getter(UpdateDashboardLinksRequest.getter(UpdateDashboardLinksRequest::linkEntities)).setter(UpdateDashboardLinksRequest.setter(Builder::linkEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARD_ID_FIELD, LINK_ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("DashboardId", DASHBOARD_ID_FIELD);
            this.put("LinkEntities", LINK_ENTITIES_FIELD);
        }
    });
    private final String awsAccountId;
    private final String dashboardId;
    private final List<String> linkEntities;

    private UpdateDashboardLinksRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.linkEntities = builder.linkEntities;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final boolean hasLinkEntities() {
        return this.linkEntities != null && !(this.linkEntities instanceof SdkAutoConstructList);
    }

    public final List<String> linkEntities() {
        return this.linkEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkEntities() ? this.linkEntities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardLinksRequest)) {
            return false;
        }
        UpdateDashboardLinksRequest other = (UpdateDashboardLinksRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardId(), other.dashboardId()) && this.hasLinkEntities() == other.hasLinkEntities() && Objects.equals(this.linkEntities(), other.linkEntities());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardLinksRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardId", (Object)this.dashboardId()).add("LinkEntities", this.hasLinkEntities() ? this.linkEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "LinkEntities": {
                return Optional.ofNullable(clazz.cast(this.linkEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardLinksRequest, T> g) {
        return obj -> g.apply((UpdateDashboardLinksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardId;
        private List<String> linkEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardLinksRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardId(model.dashboardId);
            this.linkEntities(model.linkEntities);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final Collection<String> getLinkEntities() {
            if (this.linkEntities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkEntities;
        }

        public final void setLinkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
        }

        @Override
        public final Builder linkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkEntities(String ... linkEntities) {
            this.linkEntities(Arrays.asList(linkEntities));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardLinksRequest build() {
            return new UpdateDashboardLinksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardLinksRequest> {
        public Builder awsAccountId(String var1);

        public Builder dashboardId(String var1);

        public Builder linkEntities(Collection<String> var1);

        public Builder linkEntities(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

