/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GeospatialCategoricalDataColor;
import software.amazon.awssdk.services.quicksight.model.GeospatialCategoricalDataColorListCopier;
import software.amazon.awssdk.services.quicksight.model.GeospatialNullDataSettings;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialCategoricalColor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialCategoricalColor> {
    private static final SdkField<List<GeospatialCategoricalDataColor>> CATEGORY_DATA_COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategoryDataColors").getter(GeospatialCategoricalColor.getter(GeospatialCategoricalColor::categoryDataColors)).setter(GeospatialCategoricalColor.setter(Builder::categoryDataColors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryDataColors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeospatialCategoricalDataColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NULL_DATA_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullDataVisibility").getter(GeospatialCategoricalColor.getter(GeospatialCategoricalColor::nullDataVisibilityAsString)).setter(GeospatialCategoricalColor.setter(Builder::nullDataVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataVisibility").build()}).build();
    private static final SdkField<GeospatialNullDataSettings> NULL_DATA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NullDataSettings").getter(GeospatialCategoricalColor.getter(GeospatialCategoricalColor::nullDataSettings)).setter(GeospatialCategoricalColor.setter(Builder::nullDataSettings)).constructor(GeospatialNullDataSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataSettings").build()}).build();
    private static final SdkField<Double> DEFAULT_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DefaultOpacity").getter(GeospatialCategoricalColor.getter(GeospatialCategoricalColor::defaultOpacity)).setter(GeospatialCategoricalColor.setter(Builder::defaultOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOpacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_DATA_COLORS_FIELD, NULL_DATA_VISIBILITY_FIELD, NULL_DATA_SETTINGS_FIELD, DEFAULT_OPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CategoryDataColors", CATEGORY_DATA_COLORS_FIELD);
            this.put("NullDataVisibility", NULL_DATA_VISIBILITY_FIELD);
            this.put("NullDataSettings", NULL_DATA_SETTINGS_FIELD);
            this.put("DefaultOpacity", DEFAULT_OPACITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<GeospatialCategoricalDataColor> categoryDataColors;
    private final String nullDataVisibility;
    private final GeospatialNullDataSettings nullDataSettings;
    private final Double defaultOpacity;

    private GeospatialCategoricalColor(BuilderImpl builder) {
        this.categoryDataColors = builder.categoryDataColors;
        this.nullDataVisibility = builder.nullDataVisibility;
        this.nullDataSettings = builder.nullDataSettings;
        this.defaultOpacity = builder.defaultOpacity;
    }

    public final boolean hasCategoryDataColors() {
        return this.categoryDataColors != null && !(this.categoryDataColors instanceof SdkAutoConstructList);
    }

    public final List<GeospatialCategoricalDataColor> categoryDataColors() {
        return this.categoryDataColors;
    }

    public final Visibility nullDataVisibility() {
        return Visibility.fromValue(this.nullDataVisibility);
    }

    public final String nullDataVisibilityAsString() {
        return this.nullDataVisibility;
    }

    public final GeospatialNullDataSettings nullDataSettings() {
        return this.nullDataSettings;
    }

    public final Double defaultOpacity() {
        return this.defaultOpacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategoryDataColors() ? this.categoryDataColors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nullDataVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullDataSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOpacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialCategoricalColor)) {
            return false;
        }
        GeospatialCategoricalColor other = (GeospatialCategoricalColor)obj;
        return this.hasCategoryDataColors() == other.hasCategoryDataColors() && Objects.equals(this.categoryDataColors(), other.categoryDataColors()) && Objects.equals(this.nullDataVisibilityAsString(), other.nullDataVisibilityAsString()) && Objects.equals(this.nullDataSettings(), other.nullDataSettings()) && Objects.equals(this.defaultOpacity(), other.defaultOpacity());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialCategoricalColor").add("CategoryDataColors", this.hasCategoryDataColors() ? this.categoryDataColors() : null).add("NullDataVisibility", (Object)this.nullDataVisibilityAsString()).add("NullDataSettings", (Object)this.nullDataSettings()).add("DefaultOpacity", (Object)this.defaultOpacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategoryDataColors": {
                return Optional.ofNullable(clazz.cast(this.categoryDataColors()));
            }
            case "NullDataVisibility": {
                return Optional.ofNullable(clazz.cast(this.nullDataVisibilityAsString()));
            }
            case "NullDataSettings": {
                return Optional.ofNullable(clazz.cast(this.nullDataSettings()));
            }
            case "DefaultOpacity": {
                return Optional.ofNullable(clazz.cast(this.defaultOpacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeospatialCategoricalColor, T> g) {
        return obj -> g.apply((GeospatialCategoricalColor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GeospatialCategoricalDataColor> categoryDataColors = DefaultSdkAutoConstructList.getInstance();
        private String nullDataVisibility;
        private GeospatialNullDataSettings nullDataSettings;
        private Double defaultOpacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialCategoricalColor model) {
            this.categoryDataColors(model.categoryDataColors);
            this.nullDataVisibility(model.nullDataVisibility);
            this.nullDataSettings(model.nullDataSettings);
            this.defaultOpacity(model.defaultOpacity);
        }

        public final List<GeospatialCategoricalDataColor.Builder> getCategoryDataColors() {
            List<GeospatialCategoricalDataColor.Builder> result = GeospatialCategoricalDataColorListCopier.copyToBuilder(this.categoryDataColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoryDataColors(Collection<GeospatialCategoricalDataColor.BuilderImpl> categoryDataColors) {
            this.categoryDataColors = GeospatialCategoricalDataColorListCopier.copyFromBuilder(categoryDataColors);
        }

        @Override
        public final Builder categoryDataColors(Collection<GeospatialCategoricalDataColor> categoryDataColors) {
            this.categoryDataColors = GeospatialCategoricalDataColorListCopier.copy(categoryDataColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryDataColors(GeospatialCategoricalDataColor ... categoryDataColors) {
            this.categoryDataColors(Arrays.asList(categoryDataColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryDataColors(Consumer<GeospatialCategoricalDataColor.Builder> ... categoryDataColors) {
            this.categoryDataColors(Stream.of(categoryDataColors).map(c -> (GeospatialCategoricalDataColor)((GeospatialCategoricalDataColor.Builder)GeospatialCategoricalDataColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNullDataVisibility() {
            return this.nullDataVisibility;
        }

        public final void setNullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
        }

        @Override
        public final Builder nullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
            return this;
        }

        @Override
        public final Builder nullDataVisibility(Visibility nullDataVisibility) {
            this.nullDataVisibility(nullDataVisibility == null ? null : nullDataVisibility.toString());
            return this;
        }

        public final GeospatialNullDataSettings.Builder getNullDataSettings() {
            return this.nullDataSettings != null ? this.nullDataSettings.toBuilder() : null;
        }

        public final void setNullDataSettings(GeospatialNullDataSettings.BuilderImpl nullDataSettings) {
            this.nullDataSettings = nullDataSettings != null ? nullDataSettings.build() : null;
        }

        @Override
        public final Builder nullDataSettings(GeospatialNullDataSettings nullDataSettings) {
            this.nullDataSettings = nullDataSettings;
            return this;
        }

        public final Double getDefaultOpacity() {
            return this.defaultOpacity;
        }

        public final void setDefaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
        }

        @Override
        public final Builder defaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
            return this;
        }

        public GeospatialCategoricalColor build() {
            return new GeospatialCategoricalColor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialCategoricalColor> {
        public Builder categoryDataColors(Collection<GeospatialCategoricalDataColor> var1);

        public Builder categoryDataColors(GeospatialCategoricalDataColor ... var1);

        public Builder categoryDataColors(Consumer<GeospatialCategoricalDataColor.Builder> ... var1);

        public Builder nullDataVisibility(String var1);

        public Builder nullDataVisibility(Visibility var1);

        public Builder nullDataSettings(GeospatialNullDataSettings var1);

        default public Builder nullDataSettings(Consumer<GeospatialNullDataSettings.Builder> nullDataSettings) {
            return this.nullDataSettings((GeospatialNullDataSettings)((GeospatialNullDataSettings.Builder)GeospatialNullDataSettings.builder().applyMutation(nullDataSettings)).build());
        }

        public Builder defaultOpacity(Double var1);
    }
}

