/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataPathValue;
import software.amazon.awssdk.services.quicksight.model.DataPathValueListCopier;
import software.amazon.awssdk.services.quicksight.model.SortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataPathSort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataPathSort> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(DataPathSort.getter(DataPathSort::directionAsString)).setter(DataPathSort.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<List<DataPathValue>> SORT_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortPaths").getter(DataPathSort.getter(DataPathSort::sortPaths)).setter(DataPathSort.setter(Builder::sortPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataPathValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD, SORT_PATHS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Direction", DIRECTION_FIELD);
            this.put("SortPaths", SORT_PATHS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String direction;
    private final List<DataPathValue> sortPaths;

    private DataPathSort(BuilderImpl builder) {
        this.direction = builder.direction;
        this.sortPaths = builder.sortPaths;
    }

    public final SortDirection direction() {
        return SortDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final boolean hasSortPaths() {
        return this.sortPaths != null && !(this.sortPaths instanceof SdkAutoConstructList);
    }

    public final List<DataPathValue> sortPaths() {
        return this.sortPaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortPaths() ? this.sortPaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathSort)) {
            return false;
        }
        DataPathSort other = (DataPathSort)obj;
        return Objects.equals(this.directionAsString(), other.directionAsString()) && this.hasSortPaths() == other.hasSortPaths() && Objects.equals(this.sortPaths(), other.sortPaths());
    }

    public final String toString() {
        return ToString.builder((String)"DataPathSort").add("Direction", (Object)this.directionAsString()).add("SortPaths", this.hasSortPaths() ? this.sortPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "SortPaths": {
                return Optional.ofNullable(clazz.cast(this.sortPaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataPathSort, T> g) {
        return obj -> g.apply((DataPathSort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String direction;
        private List<DataPathValue> sortPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathSort model) {
            this.direction(model.direction);
            this.sortPaths(model.sortPaths);
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(SortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final List<DataPathValue.Builder> getSortPaths() {
            List<DataPathValue.Builder> result = DataPathValueListCopier.copyToBuilder(this.sortPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortPaths(Collection<DataPathValue.BuilderImpl> sortPaths) {
            this.sortPaths = DataPathValueListCopier.copyFromBuilder(sortPaths);
        }

        @Override
        public final Builder sortPaths(Collection<DataPathValue> sortPaths) {
            this.sortPaths = DataPathValueListCopier.copy(sortPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortPaths(DataPathValue ... sortPaths) {
            this.sortPaths(Arrays.asList(sortPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortPaths(Consumer<DataPathValue.Builder> ... sortPaths) {
            this.sortPaths(Stream.of(sortPaths).map(c -> (DataPathValue)((DataPathValue.Builder)DataPathValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataPathSort build() {
            return new DataPathSort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataPathSort> {
        public Builder direction(String var1);

        public Builder direction(SortDirection var1);

        public Builder sortPaths(Collection<DataPathValue> var1);

        public Builder sortPaths(DataPathValue ... var1);

        public Builder sortPaths(Consumer<DataPathValue.Builder> ... var1);
    }
}

