/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ArcAxisConfiguration;
import software.amazon.awssdk.services.quicksight.model.ArcConfiguration;
import software.amazon.awssdk.services.quicksight.model.ComparisonConfiguration;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.PrimaryValueDisplayType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GaugeChartOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GaugeChartOptions> {
    private static final SdkField<String> PRIMARY_VALUE_DISPLAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryValueDisplayType").getter(GaugeChartOptions.getter(GaugeChartOptions::primaryValueDisplayTypeAsString)).setter(GaugeChartOptions.setter(Builder::primaryValueDisplayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueDisplayType").build()}).build();
    private static final SdkField<ComparisonConfiguration> COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Comparison").getter(GaugeChartOptions.getter(GaugeChartOptions::comparison)).setter(GaugeChartOptions.setter(Builder::comparison)).constructor(ComparisonConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()}).build();
    private static final SdkField<ArcAxisConfiguration> ARC_AXIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArcAxis").getter(GaugeChartOptions.getter(GaugeChartOptions::arcAxis)).setter(GaugeChartOptions.setter(Builder::arcAxis)).constructor(ArcAxisConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcAxis").build()}).build();
    private static final SdkField<ArcConfiguration> ARC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Arc").getter(GaugeChartOptions.getter(GaugeChartOptions::arc)).setter(GaugeChartOptions.setter(Builder::arc)).constructor(ArcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arc").build()}).build();
    private static final SdkField<FontConfiguration> PRIMARY_VALUE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryValueFontConfiguration").getter(GaugeChartOptions.getter(GaugeChartOptions::primaryValueFontConfiguration)).setter(GaugeChartOptions.setter(Builder::primaryValueFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueFontConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_VALUE_DISPLAY_TYPE_FIELD, COMPARISON_FIELD, ARC_AXIS_FIELD, ARC_FIELD, PRIMARY_VALUE_FONT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PrimaryValueDisplayType", PRIMARY_VALUE_DISPLAY_TYPE_FIELD);
            this.put("Comparison", COMPARISON_FIELD);
            this.put("ArcAxis", ARC_AXIS_FIELD);
            this.put("Arc", ARC_FIELD);
            this.put("PrimaryValueFontConfiguration", PRIMARY_VALUE_FONT_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String primaryValueDisplayType;
    private final ComparisonConfiguration comparison;
    private final ArcAxisConfiguration arcAxis;
    private final ArcConfiguration arc;
    private final FontConfiguration primaryValueFontConfiguration;

    private GaugeChartOptions(BuilderImpl builder) {
        this.primaryValueDisplayType = builder.primaryValueDisplayType;
        this.comparison = builder.comparison;
        this.arcAxis = builder.arcAxis;
        this.arc = builder.arc;
        this.primaryValueFontConfiguration = builder.primaryValueFontConfiguration;
    }

    public final PrimaryValueDisplayType primaryValueDisplayType() {
        return PrimaryValueDisplayType.fromValue(this.primaryValueDisplayType);
    }

    public final String primaryValueDisplayTypeAsString() {
        return this.primaryValueDisplayType;
    }

    public final ComparisonConfiguration comparison() {
        return this.comparison;
    }

    public final ArcAxisConfiguration arcAxis() {
        return this.arcAxis;
    }

    public final ArcConfiguration arc() {
        return this.arc;
    }

    public final FontConfiguration primaryValueFontConfiguration() {
        return this.primaryValueFontConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryValueDisplayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparison());
        hashCode = 31 * hashCode + Objects.hashCode(this.arcAxis());
        hashCode = 31 * hashCode + Objects.hashCode(this.arc());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryValueFontConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GaugeChartOptions)) {
            return false;
        }
        GaugeChartOptions other = (GaugeChartOptions)obj;
        return Objects.equals(this.primaryValueDisplayTypeAsString(), other.primaryValueDisplayTypeAsString()) && Objects.equals(this.comparison(), other.comparison()) && Objects.equals(this.arcAxis(), other.arcAxis()) && Objects.equals(this.arc(), other.arc()) && Objects.equals(this.primaryValueFontConfiguration(), other.primaryValueFontConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GaugeChartOptions").add("PrimaryValueDisplayType", (Object)this.primaryValueDisplayTypeAsString()).add("Comparison", (Object)this.comparison()).add("ArcAxis", (Object)this.arcAxis()).add("Arc", (Object)this.arc()).add("PrimaryValueFontConfiguration", (Object)this.primaryValueFontConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryValueDisplayType": {
                return Optional.ofNullable(clazz.cast(this.primaryValueDisplayTypeAsString()));
            }
            case "Comparison": {
                return Optional.ofNullable(clazz.cast(this.comparison()));
            }
            case "ArcAxis": {
                return Optional.ofNullable(clazz.cast(this.arcAxis()));
            }
            case "Arc": {
                return Optional.ofNullable(clazz.cast(this.arc()));
            }
            case "PrimaryValueFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.primaryValueFontConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GaugeChartOptions, T> g) {
        return obj -> g.apply((GaugeChartOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryValueDisplayType;
        private ComparisonConfiguration comparison;
        private ArcAxisConfiguration arcAxis;
        private ArcConfiguration arc;
        private FontConfiguration primaryValueFontConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GaugeChartOptions model) {
            this.primaryValueDisplayType(model.primaryValueDisplayType);
            this.comparison(model.comparison);
            this.arcAxis(model.arcAxis);
            this.arc(model.arc);
            this.primaryValueFontConfiguration(model.primaryValueFontConfiguration);
        }

        public final String getPrimaryValueDisplayType() {
            return this.primaryValueDisplayType;
        }

        public final void setPrimaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
        }

        @Override
        public final Builder primaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
            return this;
        }

        @Override
        public final Builder primaryValueDisplayType(PrimaryValueDisplayType primaryValueDisplayType) {
            this.primaryValueDisplayType(primaryValueDisplayType == null ? null : primaryValueDisplayType.toString());
            return this;
        }

        public final ComparisonConfiguration.Builder getComparison() {
            return this.comparison != null ? this.comparison.toBuilder() : null;
        }

        public final void setComparison(ComparisonConfiguration.BuilderImpl comparison) {
            this.comparison = comparison != null ? comparison.build() : null;
        }

        @Override
        public final Builder comparison(ComparisonConfiguration comparison) {
            this.comparison = comparison;
            return this;
        }

        public final ArcAxisConfiguration.Builder getArcAxis() {
            return this.arcAxis != null ? this.arcAxis.toBuilder() : null;
        }

        public final void setArcAxis(ArcAxisConfiguration.BuilderImpl arcAxis) {
            this.arcAxis = arcAxis != null ? arcAxis.build() : null;
        }

        @Override
        public final Builder arcAxis(ArcAxisConfiguration arcAxis) {
            this.arcAxis = arcAxis;
            return this;
        }

        public final ArcConfiguration.Builder getArc() {
            return this.arc != null ? this.arc.toBuilder() : null;
        }

        public final void setArc(ArcConfiguration.BuilderImpl arc) {
            this.arc = arc != null ? arc.build() : null;
        }

        @Override
        public final Builder arc(ArcConfiguration arc) {
            this.arc = arc;
            return this;
        }

        public final FontConfiguration.Builder getPrimaryValueFontConfiguration() {
            return this.primaryValueFontConfiguration != null ? this.primaryValueFontConfiguration.toBuilder() : null;
        }

        public final void setPrimaryValueFontConfiguration(FontConfiguration.BuilderImpl primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration != null ? primaryValueFontConfiguration.build() : null;
        }

        @Override
        public final Builder primaryValueFontConfiguration(FontConfiguration primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration;
            return this;
        }

        public GaugeChartOptions build() {
            return new GaugeChartOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GaugeChartOptions> {
        public Builder primaryValueDisplayType(String var1);

        public Builder primaryValueDisplayType(PrimaryValueDisplayType var1);

        public Builder comparison(ComparisonConfiguration var1);

        default public Builder comparison(Consumer<ComparisonConfiguration.Builder> comparison) {
            return this.comparison((ComparisonConfiguration)((ComparisonConfiguration.Builder)ComparisonConfiguration.builder().applyMutation(comparison)).build());
        }

        public Builder arcAxis(ArcAxisConfiguration var1);

        default public Builder arcAxis(Consumer<ArcAxisConfiguration.Builder> arcAxis) {
            return this.arcAxis((ArcAxisConfiguration)((ArcAxisConfiguration.Builder)ArcAxisConfiguration.builder().applyMutation(arcAxis)).build());
        }

        public Builder arc(ArcConfiguration var1);

        default public Builder arc(Consumer<ArcConfiguration.Builder> arc) {
            return this.arc((ArcConfiguration)((ArcConfiguration.Builder)ArcConfiguration.builder().applyMutation(arc)).build());
        }

        public Builder primaryValueFontConfiguration(FontConfiguration var1);

        default public Builder primaryValueFontConfiguration(Consumer<FontConfiguration.Builder> primaryValueFontConfiguration) {
            return this.primaryValueFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(primaryValueFontConfiguration)).build());
        }
    }
}

