/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.VisualCustomActionOperation;
import software.amazon.awssdk.services.quicksight.model.VisualCustomActionOperationListCopier;
import software.amazon.awssdk.services.quicksight.model.VisualCustomActionTrigger;
import software.amazon.awssdk.services.quicksight.model.WidgetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VisualCustomAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VisualCustomAction> {
    private static final SdkField<String> CUSTOM_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomActionId").getter(VisualCustomAction.getter(VisualCustomAction::customActionId)).setter(VisualCustomAction.setter(Builder::customActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VisualCustomAction.getter(VisualCustomAction::name)).setter(VisualCustomAction.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VisualCustomAction.getter(VisualCustomAction::statusAsString)).setter(VisualCustomAction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Trigger").getter(VisualCustomAction.getter(VisualCustomAction::triggerAsString)).setter(VisualCustomAction.setter(Builder::trigger)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trigger").build()}).build();
    private static final SdkField<List<VisualCustomActionOperation>> ACTION_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionOperations").getter(VisualCustomAction.getter(VisualCustomAction::actionOperations)).setter(VisualCustomAction.setter(Builder::actionOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VisualCustomActionOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTION_ID_FIELD, NAME_FIELD, STATUS_FIELD, TRIGGER_FIELD, ACTION_OPERATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomActionId", CUSTOM_ACTION_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Trigger", TRIGGER_FIELD);
            this.put("ActionOperations", ACTION_OPERATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String customActionId;
    private final String name;
    private final String status;
    private final String trigger;
    private final List<VisualCustomActionOperation> actionOperations;

    private VisualCustomAction(BuilderImpl builder) {
        this.customActionId = builder.customActionId;
        this.name = builder.name;
        this.status = builder.status;
        this.trigger = builder.trigger;
        this.actionOperations = builder.actionOperations;
    }

    public final String customActionId() {
        return this.customActionId;
    }

    public final String name() {
        return this.name;
    }

    public final WidgetStatus status() {
        return WidgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final VisualCustomActionTrigger trigger() {
        return VisualCustomActionTrigger.fromValue(this.trigger);
    }

    public final String triggerAsString() {
        return this.trigger;
    }

    public final boolean hasActionOperations() {
        return this.actionOperations != null && !(this.actionOperations instanceof SdkAutoConstructList);
    }

    public final List<VisualCustomActionOperation> actionOperations() {
        return this.actionOperations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionOperations() ? this.actionOperations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualCustomAction)) {
            return false;
        }
        VisualCustomAction other = (VisualCustomAction)obj;
        return Objects.equals(this.customActionId(), other.customActionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.triggerAsString(), other.triggerAsString()) && this.hasActionOperations() == other.hasActionOperations() && Objects.equals(this.actionOperations(), other.actionOperations());
    }

    public final String toString() {
        return ToString.builder((String)"VisualCustomAction").add("CustomActionId", (Object)this.customActionId()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Trigger", (Object)this.triggerAsString()).add("ActionOperations", this.hasActionOperations() ? this.actionOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomActionId": {
                return Optional.ofNullable(clazz.cast(this.customActionId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Trigger": {
                return Optional.ofNullable(clazz.cast(this.triggerAsString()));
            }
            case "ActionOperations": {
                return Optional.ofNullable(clazz.cast(this.actionOperations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VisualCustomAction, T> g) {
        return obj -> g.apply((VisualCustomAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customActionId;
        private String name;
        private String status;
        private String trigger;
        private List<VisualCustomActionOperation> actionOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VisualCustomAction model) {
            this.customActionId(model.customActionId);
            this.name(model.name);
            this.status(model.status);
            this.trigger(model.trigger);
            this.actionOperations(model.actionOperations);
        }

        public final String getCustomActionId() {
            return this.customActionId;
        }

        public final void setCustomActionId(String customActionId) {
            this.customActionId = customActionId;
        }

        @Override
        public final Builder customActionId(String customActionId) {
            this.customActionId = customActionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrigger() {
            return this.trigger;
        }

        public final void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        @Override
        public final Builder trigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public final Builder trigger(VisualCustomActionTrigger trigger) {
            this.trigger(trigger == null ? null : trigger.toString());
            return this;
        }

        public final List<VisualCustomActionOperation.Builder> getActionOperations() {
            List<VisualCustomActionOperation.Builder> result = VisualCustomActionOperationListCopier.copyToBuilder(this.actionOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionOperations(Collection<VisualCustomActionOperation.BuilderImpl> actionOperations) {
            this.actionOperations = VisualCustomActionOperationListCopier.copyFromBuilder(actionOperations);
        }

        @Override
        public final Builder actionOperations(Collection<VisualCustomActionOperation> actionOperations) {
            this.actionOperations = VisualCustomActionOperationListCopier.copy(actionOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionOperations(VisualCustomActionOperation ... actionOperations) {
            this.actionOperations(Arrays.asList(actionOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionOperations(Consumer<VisualCustomActionOperation.Builder> ... actionOperations) {
            this.actionOperations(Stream.of(actionOperations).map(c -> (VisualCustomActionOperation)((VisualCustomActionOperation.Builder)VisualCustomActionOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VisualCustomAction build() {
            return new VisualCustomAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VisualCustomAction> {
        public Builder customActionId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(WidgetStatus var1);

        public Builder trigger(String var1);

        public Builder trigger(VisualCustomActionTrigger var1);

        public Builder actionOperations(Collection<VisualCustomActionOperation> var1);

        public Builder actionOperations(VisualCustomActionOperation ... var1);

        public Builder actionOperations(Consumer<VisualCustomActionOperation.Builder> ... var1);
    }
}

