/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.NamedEntityDefinitionMetric;
import software.amazon.awssdk.services.quicksight.model.PropertyRole;
import software.amazon.awssdk.services.quicksight.model.PropertyUsage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamedEntityDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamedEntityDefinition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(NamedEntityDefinition.getter(NamedEntityDefinition::fieldName)).setter(NamedEntityDefinition.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyName").getter(NamedEntityDefinition.getter(NamedEntityDefinition::propertyName)).setter(NamedEntityDefinition.setter(Builder::propertyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyName").build()}).build();
    private static final SdkField<String> PROPERTY_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyRole").getter(NamedEntityDefinition.getter(NamedEntityDefinition::propertyRoleAsString)).setter(NamedEntityDefinition.setter(Builder::propertyRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyRole").build()}).build();
    private static final SdkField<String> PROPERTY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyUsage").getter(NamedEntityDefinition.getter(NamedEntityDefinition::propertyUsageAsString)).setter(NamedEntityDefinition.setter(Builder::propertyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyUsage").build()}).build();
    private static final SdkField<NamedEntityDefinitionMetric> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metric").getter(NamedEntityDefinition.getter(NamedEntityDefinition::metric)).setter(NamedEntityDefinition.setter(Builder::metric)).constructor(NamedEntityDefinitionMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, PROPERTY_NAME_FIELD, PROPERTY_ROLE_FIELD, PROPERTY_USAGE_FIELD, METRIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FieldName", FIELD_NAME_FIELD);
            this.put("PropertyName", PROPERTY_NAME_FIELD);
            this.put("PropertyRole", PROPERTY_ROLE_FIELD);
            this.put("PropertyUsage", PROPERTY_USAGE_FIELD);
            this.put("Metric", METRIC_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String propertyName;
    private final String propertyRole;
    private final String propertyUsage;
    private final NamedEntityDefinitionMetric metric;

    private NamedEntityDefinition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.propertyName = builder.propertyName;
        this.propertyRole = builder.propertyRole;
        this.propertyUsage = builder.propertyUsage;
        this.metric = builder.metric;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public final PropertyRole propertyRole() {
        return PropertyRole.fromValue(this.propertyRole);
    }

    public final String propertyRoleAsString() {
        return this.propertyRole;
    }

    public final PropertyUsage propertyUsage() {
        return PropertyUsage.fromValue(this.propertyUsage);
    }

    public final String propertyUsageAsString() {
        return this.propertyUsage;
    }

    public final NamedEntityDefinitionMetric metric() {
        return this.metric;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedEntityDefinition)) {
            return false;
        }
        NamedEntityDefinition other = (NamedEntityDefinition)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.propertyName(), other.propertyName()) && Objects.equals(this.propertyRoleAsString(), other.propertyRoleAsString()) && Objects.equals(this.propertyUsageAsString(), other.propertyUsageAsString()) && Objects.equals(this.metric(), other.metric());
    }

    public final String toString() {
        return ToString.builder((String)"NamedEntityDefinition").add("FieldName", (Object)this.fieldName()).add("PropertyName", (Object)this.propertyName()).add("PropertyRole", (Object)this.propertyRoleAsString()).add("PropertyUsage", (Object)this.propertyUsageAsString()).add("Metric", (Object)this.metric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "PropertyName": {
                return Optional.ofNullable(clazz.cast(this.propertyName()));
            }
            case "PropertyRole": {
                return Optional.ofNullable(clazz.cast(this.propertyRoleAsString()));
            }
            case "PropertyUsage": {
                return Optional.ofNullable(clazz.cast(this.propertyUsageAsString()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NamedEntityDefinition, T> g) {
        return obj -> g.apply((NamedEntityDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String propertyName;
        private String propertyRole;
        private String propertyUsage;
        private NamedEntityDefinitionMetric metric;

        private BuilderImpl() {
        }

        private BuilderImpl(NamedEntityDefinition model) {
            this.fieldName(model.fieldName);
            this.propertyName(model.propertyName);
            this.propertyRole(model.propertyRole);
            this.propertyUsage(model.propertyUsage);
            this.metric(model.metric);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getPropertyName() {
            return this.propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final String getPropertyRole() {
            return this.propertyRole;
        }

        public final void setPropertyRole(String propertyRole) {
            this.propertyRole = propertyRole;
        }

        @Override
        public final Builder propertyRole(String propertyRole) {
            this.propertyRole = propertyRole;
            return this;
        }

        @Override
        public final Builder propertyRole(PropertyRole propertyRole) {
            this.propertyRole(propertyRole == null ? null : propertyRole.toString());
            return this;
        }

        public final String getPropertyUsage() {
            return this.propertyUsage;
        }

        public final void setPropertyUsage(String propertyUsage) {
            this.propertyUsage = propertyUsage;
        }

        @Override
        public final Builder propertyUsage(String propertyUsage) {
            this.propertyUsage = propertyUsage;
            return this;
        }

        @Override
        public final Builder propertyUsage(PropertyUsage propertyUsage) {
            this.propertyUsage(propertyUsage == null ? null : propertyUsage.toString());
            return this;
        }

        public final NamedEntityDefinitionMetric.Builder getMetric() {
            return this.metric != null ? this.metric.toBuilder() : null;
        }

        public final void setMetric(NamedEntityDefinitionMetric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(NamedEntityDefinitionMetric metric) {
            this.metric = metric;
            return this;
        }

        public NamedEntityDefinition build() {
            return new NamedEntityDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamedEntityDefinition> {
        public Builder fieldName(String var1);

        public Builder propertyName(String var1);

        public Builder propertyRole(String var1);

        public Builder propertyRole(PropertyRole var1);

        public Builder propertyUsage(String var1);

        public Builder propertyUsage(PropertyUsage var1);

        public Builder metric(NamedEntityDefinitionMetric var1);

        default public Builder metric(Consumer<NamedEntityDefinitionMetric.Builder> metric) {
            return this.metric((NamedEntityDefinitionMetric)((NamedEntityDefinitionMetric.Builder)NamedEntityDefinitionMetric.builder().applyMutation(metric)).build());
        }
    }
}

