/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Slot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Slot> {
    private static final SdkField<String> SLOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlotId").getter(Slot.getter(Slot::slotId)).setter(Slot.setter(Builder::slotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotId").build()}).build();
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualId").getter(Slot.getter(Slot::visualId)).setter(Slot.setter(Builder::visualId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_ID_FIELD, VISUAL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String slotId;
    private final String visualId;

    private Slot(BuilderImpl builder) {
        this.slotId = builder.slotId;
        this.visualId = builder.visualId;
    }

    public final String slotId() {
        return this.slotId;
    }

    public final String visualId() {
        return this.visualId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.slotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        return Objects.equals(this.slotId(), other.slotId()) && Objects.equals(this.visualId(), other.visualId());
    }

    public final String toString() {
        return ToString.builder((String)"Slot").add("SlotId", (Object)this.slotId()).add("VisualId", (Object)this.visualId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SlotId": {
                return Optional.ofNullable(clazz.cast(this.slotId()));
            }
            case "VisualId": {
                return Optional.ofNullable(clazz.cast(this.visualId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Slot, T> g) {
        return obj -> g.apply((Slot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String slotId;
        private String visualId;

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            this.slotId(model.slotId);
            this.visualId(model.visualId);
        }

        public final String getSlotId() {
            return this.slotId;
        }

        public final void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        @Override
        public final Builder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public final String getVisualId() {
            return this.visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public Slot build() {
            return new Slot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Slot> {
        public Builder slotId(String var1);

        public Builder visualId(String var1);
    }
}

