/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TopicRelativeDateFilterFunction;
import software.amazon.awssdk.services.quicksight.model.TopicSingularFilterConstant;
import software.amazon.awssdk.services.quicksight.model.TopicTimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRelativeDateFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRelativeDateFilter> {
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(TopicRelativeDateFilter.getter(TopicRelativeDateFilter::timeGranularityAsString)).setter(TopicRelativeDateFilter.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<String> RELATIVE_DATE_FILTER_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelativeDateFilterFunction").getter(TopicRelativeDateFilter.getter(TopicRelativeDateFilter::relativeDateFilterFunctionAsString)).setter(TopicRelativeDateFilter.setter(Builder::relativeDateFilterFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateFilterFunction").build()}).build();
    private static final SdkField<TopicSingularFilterConstant> CONSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constant").getter(TopicRelativeDateFilter.getter(TopicRelativeDateFilter::constant)).setter(TopicRelativeDateFilter.setter(Builder::constant)).constructor(TopicSingularFilterConstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_GRANULARITY_FIELD, RELATIVE_DATE_FILTER_FUNCTION_FIELD, CONSTANT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String timeGranularity;
    private final String relativeDateFilterFunction;
    private final TopicSingularFilterConstant constant;

    private TopicRelativeDateFilter(BuilderImpl builder) {
        this.timeGranularity = builder.timeGranularity;
        this.relativeDateFilterFunction = builder.relativeDateFilterFunction;
        this.constant = builder.constant;
    }

    public final TopicTimeGranularity timeGranularity() {
        return TopicTimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final TopicRelativeDateFilterFunction relativeDateFilterFunction() {
        return TopicRelativeDateFilterFunction.fromValue(this.relativeDateFilterFunction);
    }

    public final String relativeDateFilterFunctionAsString() {
        return this.relativeDateFilterFunction;
    }

    public final TopicSingularFilterConstant constant() {
        return this.constant;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeDateFilterFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.constant());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRelativeDateFilter)) {
            return false;
        }
        TopicRelativeDateFilter other = (TopicRelativeDateFilter)obj;
        return Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && Objects.equals(this.relativeDateFilterFunctionAsString(), other.relativeDateFilterFunctionAsString()) && Objects.equals(this.constant(), other.constant());
    }

    public final String toString() {
        return ToString.builder((String)"TopicRelativeDateFilter").add("TimeGranularity", (Object)this.timeGranularityAsString()).add("RelativeDateFilterFunction", (Object)this.relativeDateFilterFunctionAsString()).add("Constant", (Object)(this.constant() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "RelativeDateFilterFunction": {
                return Optional.ofNullable(clazz.cast(this.relativeDateFilterFunctionAsString()));
            }
            case "Constant": {
                return Optional.ofNullable(clazz.cast(this.constant()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRelativeDateFilter, T> g) {
        return obj -> g.apply((TopicRelativeDateFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeGranularity;
        private String relativeDateFilterFunction;
        private TopicSingularFilterConstant constant;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRelativeDateFilter model) {
            this.timeGranularity(model.timeGranularity);
            this.relativeDateFilterFunction(model.relativeDateFilterFunction);
            this.constant(model.constant);
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TopicTimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final String getRelativeDateFilterFunction() {
            return this.relativeDateFilterFunction;
        }

        public final void setRelativeDateFilterFunction(String relativeDateFilterFunction) {
            this.relativeDateFilterFunction = relativeDateFilterFunction;
        }

        @Override
        public final Builder relativeDateFilterFunction(String relativeDateFilterFunction) {
            this.relativeDateFilterFunction = relativeDateFilterFunction;
            return this;
        }

        @Override
        public final Builder relativeDateFilterFunction(TopicRelativeDateFilterFunction relativeDateFilterFunction) {
            this.relativeDateFilterFunction(relativeDateFilterFunction == null ? null : relativeDateFilterFunction.toString());
            return this;
        }

        public final TopicSingularFilterConstant.Builder getConstant() {
            return this.constant != null ? this.constant.toBuilder() : null;
        }

        public final void setConstant(TopicSingularFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicSingularFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        public TopicRelativeDateFilter build() {
            return new TopicRelativeDateFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRelativeDateFilter> {
        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TopicTimeGranularity var1);

        public Builder relativeDateFilterFunction(String var1);

        public Builder relativeDateFilterFunction(TopicRelativeDateFilterFunction var1);

        public Builder constant(TopicSingularFilterConstant var1);

        default public Builder constant(Consumer<TopicSingularFilterConstant.Builder> constant) {
            return this.constant((TopicSingularFilterConstant)((TopicSingularFilterConstant.Builder)TopicSingularFilterConstant.builder().applyMutation(constant)).build());
        }
    }
}

