/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a tree map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TreeMapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TreeMapConfiguration.Builder, TreeMapConfiguration> {
    private static final SdkField<TreeMapFieldWells> FIELD_WELLS_FIELD = SdkField
            .<TreeMapFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(TreeMapConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(TreeMapFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<TreeMapSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<TreeMapSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(TreeMapConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(TreeMapSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<ChartAxisLabelOptions> GROUP_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("GroupLabelOptions")
            .getter(getter(TreeMapConfiguration::groupLabelOptions)).setter(setter(Builder::groupLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupLabelOptions").build()).build();

    private static final SdkField<ChartAxisLabelOptions> SIZE_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("SizeLabelOptions")
            .getter(getter(TreeMapConfiguration::sizeLabelOptions)).setter(setter(Builder::sizeLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeLabelOptions").build()).build();

    private static final SdkField<ChartAxisLabelOptions> COLOR_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ColorLabelOptions")
            .getter(getter(TreeMapConfiguration::colorLabelOptions)).setter(setter(Builder::colorLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorLabelOptions").build()).build();

    private static final SdkField<ColorScale> COLOR_SCALE_FIELD = SdkField.<ColorScale> builder(MarshallingType.SDK_POJO)
            .memberName("ColorScale").getter(getter(TreeMapConfiguration::colorScale)).setter(setter(Builder::colorScale))
            .constructor(ColorScale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorScale").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(TreeMapConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(TreeMapConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(TreeMapConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(TreeMapConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, GROUP_LABEL_OPTIONS_FIELD, SIZE_LABEL_OPTIONS_FIELD, COLOR_LABEL_OPTIONS_FIELD,
            COLOR_SCALE_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, TOOLTIP_FIELD, INTERACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TreeMapFieldWells fieldWells;

    private final TreeMapSortConfiguration sortConfiguration;

    private final ChartAxisLabelOptions groupLabelOptions;

    private final ChartAxisLabelOptions sizeLabelOptions;

    private final ChartAxisLabelOptions colorLabelOptions;

    private final ColorScale colorScale;

    private final LegendOptions legend;

    private final DataLabelOptions dataLabels;

    private final TooltipOptions tooltip;

    private final VisualInteractionOptions interactions;

    private TreeMapConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.groupLabelOptions = builder.groupLabelOptions;
        this.sizeLabelOptions = builder.sizeLabelOptions;
        this.colorLabelOptions = builder.colorLabelOptions;
        this.colorScale = builder.colorScale;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final TreeMapFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a tree map.
     * </p>
     * 
     * @return The sort configuration of a tree map.
     */
    public final TreeMapSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The label options (label text, label visibility) of the groups that are displayed in a tree map.
     * </p>
     * 
     * @return The label options (label text, label visibility) of the groups that are displayed in a tree map.
     */
    public final ChartAxisLabelOptions groupLabelOptions() {
        return groupLabelOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility) of the sizes that are displayed in a tree map.
     * </p>
     * 
     * @return The label options (label text, label visibility) of the sizes that are displayed in a tree map.
     */
    public final ChartAxisLabelOptions sizeLabelOptions() {
        return sizeLabelOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility) for the colors displayed in a tree map.
     * </p>
     * 
     * @return The label options (label text, label visibility) for the colors displayed in a tree map.
     */
    public final ChartAxisLabelOptions colorLabelOptions() {
        return colorLabelOptions;
    }

    /**
     * <p>
     * The color options (gradient color, point of divergence) of a tree map.
     * </p>
     * 
     * @return The color options (gradient color, point of divergence) of a tree map.
     */
    public final ColorScale colorScale() {
        return colorScale;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The options that determine if visual data labels are displayed.
     * </p>
     * 
     * @return The options that determine if visual data labels are displayed.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The tooltip display setup of the visual.
     * </p>
     * 
     * @return The tooltip display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(groupLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sizeLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(colorLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(colorScale());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreeMapConfiguration)) {
            return false;
        }
        TreeMapConfiguration other = (TreeMapConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(groupLabelOptions(), other.groupLabelOptions())
                && Objects.equals(sizeLabelOptions(), other.sizeLabelOptions())
                && Objects.equals(colorLabelOptions(), other.colorLabelOptions())
                && Objects.equals(colorScale(), other.colorScale()) && Objects.equals(legend(), other.legend())
                && Objects.equals(dataLabels(), other.dataLabels()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TreeMapConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("GroupLabelOptions", groupLabelOptions())
                .add("SizeLabelOptions", sizeLabelOptions()).add("ColorLabelOptions", colorLabelOptions())
                .add("ColorScale", colorScale()).add("Legend", legend()).add("DataLabels", dataLabels())
                .add("Tooltip", tooltip()).add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "GroupLabelOptions":
            return Optional.ofNullable(clazz.cast(groupLabelOptions()));
        case "SizeLabelOptions":
            return Optional.ofNullable(clazz.cast(sizeLabelOptions()));
        case "ColorLabelOptions":
            return Optional.ofNullable(clazz.cast(colorLabelOptions()));
        case "ColorScale":
            return Optional.ofNullable(clazz.cast(colorScale()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TreeMapConfiguration, T> g) {
        return obj -> g.apply((TreeMapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TreeMapConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(TreeMapFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TreeMapFieldWells.Builder} avoiding the
         * need to create one manually via {@link TreeMapFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TreeMapFieldWells.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldWells(TreeMapFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link TreeMapFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(TreeMapFieldWells)
         */
        default Builder fieldWells(Consumer<TreeMapFieldWells.Builder> fieldWells) {
            return fieldWells(TreeMapFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a tree map.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a tree map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(TreeMapSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a tree map.
         * </p>
         * This is a convenience method that creates an instance of the {@link TreeMapSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link TreeMapSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TreeMapSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(TreeMapSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link TreeMapSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(TreeMapSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<TreeMapSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(TreeMapSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility) of the groups that are displayed in a tree map.
         * </p>
         * 
         * @param groupLabelOptions
         *        The label options (label text, label visibility) of the groups that are displayed in a tree map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupLabelOptions(ChartAxisLabelOptions groupLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility) of the groups that are displayed in a tree map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #groupLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param groupLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupLabelOptions(ChartAxisLabelOptions)
         */
        default Builder groupLabelOptions(Consumer<ChartAxisLabelOptions.Builder> groupLabelOptions) {
            return groupLabelOptions(ChartAxisLabelOptions.builder().applyMutation(groupLabelOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility) of the sizes that are displayed in a tree map.
         * </p>
         * 
         * @param sizeLabelOptions
         *        The label options (label text, label visibility) of the sizes that are displayed in a tree map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeLabelOptions(ChartAxisLabelOptions sizeLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility) of the sizes that are displayed in a tree map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #sizeLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param sizeLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeLabelOptions(ChartAxisLabelOptions)
         */
        default Builder sizeLabelOptions(Consumer<ChartAxisLabelOptions.Builder> sizeLabelOptions) {
            return sizeLabelOptions(ChartAxisLabelOptions.builder().applyMutation(sizeLabelOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility) for the colors displayed in a tree map.
         * </p>
         * 
         * @param colorLabelOptions
         *        The label options (label text, label visibility) for the colors displayed in a tree map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility) for the colors displayed in a tree map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #colorLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param colorLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorLabelOptions(ChartAxisLabelOptions)
         */
        default Builder colorLabelOptions(Consumer<ChartAxisLabelOptions.Builder> colorLabelOptions) {
            return colorLabelOptions(ChartAxisLabelOptions.builder().applyMutation(colorLabelOptions).build());
        }

        /**
         * <p>
         * The color options (gradient color, point of divergence) of a tree map.
         * </p>
         * 
         * @param colorScale
         *        The color options (gradient color, point of divergence) of a tree map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorScale(ColorScale colorScale);

        /**
         * <p>
         * The color options (gradient color, point of divergence) of a tree map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColorScale.Builder} avoiding the need to
         * create one manually via {@link ColorScale#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColorScale.Builder#build()} is called immediately and its result
         * is passed to {@link #colorScale(ColorScale)}.
         * 
         * @param colorScale
         *        a consumer that will call methods on {@link ColorScale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorScale(ColorScale)
         */
        default Builder colorScale(Consumer<ColorScale.Builder> colorScale) {
            return colorScale(ColorScale.builder().applyMutation(colorScale).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * 
         * @param dataLabels
         *        The options that determine if visual data labels are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The tooltip display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TreeMapFieldWells fieldWells;

        private TreeMapSortConfiguration sortConfiguration;

        private ChartAxisLabelOptions groupLabelOptions;

        private ChartAxisLabelOptions sizeLabelOptions;

        private ChartAxisLabelOptions colorLabelOptions;

        private ColorScale colorScale;

        private LegendOptions legend;

        private DataLabelOptions dataLabels;

        private TooltipOptions tooltip;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(TreeMapConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            groupLabelOptions(model.groupLabelOptions);
            sizeLabelOptions(model.sizeLabelOptions);
            colorLabelOptions(model.colorLabelOptions);
            colorScale(model.colorScale);
            legend(model.legend);
            dataLabels(model.dataLabels);
            tooltip(model.tooltip);
            interactions(model.interactions);
        }

        public final TreeMapFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(TreeMapFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(TreeMapFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final TreeMapSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(TreeMapSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(TreeMapSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getGroupLabelOptions() {
            return groupLabelOptions != null ? groupLabelOptions.toBuilder() : null;
        }

        public final void setGroupLabelOptions(ChartAxisLabelOptions.BuilderImpl groupLabelOptions) {
            this.groupLabelOptions = groupLabelOptions != null ? groupLabelOptions.build() : null;
        }

        @Override
        public final Builder groupLabelOptions(ChartAxisLabelOptions groupLabelOptions) {
            this.groupLabelOptions = groupLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getSizeLabelOptions() {
            return sizeLabelOptions != null ? sizeLabelOptions.toBuilder() : null;
        }

        public final void setSizeLabelOptions(ChartAxisLabelOptions.BuilderImpl sizeLabelOptions) {
            this.sizeLabelOptions = sizeLabelOptions != null ? sizeLabelOptions.build() : null;
        }

        @Override
        public final Builder sizeLabelOptions(ChartAxisLabelOptions sizeLabelOptions) {
            this.sizeLabelOptions = sizeLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColorLabelOptions() {
            return colorLabelOptions != null ? colorLabelOptions.toBuilder() : null;
        }

        public final void setColorLabelOptions(ChartAxisLabelOptions.BuilderImpl colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions != null ? colorLabelOptions.build() : null;
        }

        @Override
        public final Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions;
            return this;
        }

        public final ColorScale.Builder getColorScale() {
            return colorScale != null ? colorScale.toBuilder() : null;
        }

        public final void setColorScale(ColorScale.BuilderImpl colorScale) {
            this.colorScale = colorScale != null ? colorScale.build() : null;
        }

        @Override
        public final Builder colorScale(ColorScale colorScale) {
            this.colorScale = colorScale;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public TreeMapConfiguration build() {
            return new TreeMapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
