/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>GaugeChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GaugeChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GaugeChartConfiguration.Builder, GaugeChartConfiguration> {
    private static final SdkField<GaugeChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<GaugeChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(GaugeChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(GaugeChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<GaugeChartOptions> GAUGE_CHART_OPTIONS_FIELD = SdkField
            .<GaugeChartOptions> builder(MarshallingType.SDK_POJO).memberName("GaugeChartOptions")
            .getter(getter(GaugeChartConfiguration::gaugeChartOptions)).setter(setter(Builder::gaugeChartOptions))
            .constructor(GaugeChartOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GaugeChartOptions").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(GaugeChartConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_OPTIONS_FIELD = SdkField
            .<TooltipOptions> builder(MarshallingType.SDK_POJO).memberName("TooltipOptions")
            .getter(getter(GaugeChartConfiguration::tooltipOptions)).setter(setter(Builder::tooltipOptions))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipOptions").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(GaugeChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(GaugeChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            GAUGE_CHART_OPTIONS_FIELD, DATA_LABELS_FIELD, TOOLTIP_OPTIONS_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final GaugeChartFieldWells fieldWells;

    private final GaugeChartOptions gaugeChartOptions;

    private final DataLabelOptions dataLabels;

    private final TooltipOptions tooltipOptions;

    private final VisualPalette visualPalette;

    private final VisualInteractionOptions interactions;

    private GaugeChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.gaugeChartOptions = builder.gaugeChartOptions;
        this.dataLabels = builder.dataLabels;
        this.tooltipOptions = builder.tooltipOptions;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field well configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The field well configuration of a <code>GaugeChartVisual</code>.
     */
    public final GaugeChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The options that determine the presentation of the <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The options that determine the presentation of the <code>GaugeChartVisual</code>.
     */
    public final GaugeChartOptions gaugeChartOptions() {
        return gaugeChartOptions;
    }

    /**
     * <p>
     * The data label configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The data label configuration of a <code>GaugeChartVisual</code>.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The tooltip configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The tooltip configuration of a <code>GaugeChartVisual</code>.
     */
    public final TooltipOptions tooltipOptions() {
        return tooltipOptions;
    }

    /**
     * <p>
     * The visual palette configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The visual palette configuration of a <code>GaugeChartVisual</code>.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(gaugeChartOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltipOptions());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GaugeChartConfiguration)) {
            return false;
        }
        GaugeChartConfiguration other = (GaugeChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(gaugeChartOptions(), other.gaugeChartOptions())
                && Objects.equals(dataLabels(), other.dataLabels()) && Objects.equals(tooltipOptions(), other.tooltipOptions())
                && Objects.equals(visualPalette(), other.visualPalette()) && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GaugeChartConfiguration").add("FieldWells", fieldWells())
                .add("GaugeChartOptions", gaugeChartOptions()).add("DataLabels", dataLabels())
                .add("TooltipOptions", tooltipOptions()).add("VisualPalette", visualPalette())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "GaugeChartOptions":
            return Optional.ofNullable(clazz.cast(gaugeChartOptions()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "TooltipOptions":
            return Optional.ofNullable(clazz.cast(tooltipOptions()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GaugeChartConfiguration, T> g) {
        return obj -> g.apply((GaugeChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GaugeChartConfiguration> {
        /**
         * <p>
         * The field well configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(GaugeChartFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GaugeChartFieldWells.Builder} avoiding
         * the need to create one manually via {@link GaugeChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GaugeChartFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(GaugeChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link GaugeChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(GaugeChartFieldWells)
         */
        default Builder fieldWells(Consumer<GaugeChartFieldWells.Builder> fieldWells) {
            return fieldWells(GaugeChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param gaugeChartOptions
         *        The options that determine the presentation of the <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gaugeChartOptions(GaugeChartOptions gaugeChartOptions);

        /**
         * <p>
         * The options that determine the presentation of the <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GaugeChartOptions.Builder} avoiding the
         * need to create one manually via {@link GaugeChartOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GaugeChartOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #gaugeChartOptions(GaugeChartOptions)}.
         * 
         * @param gaugeChartOptions
         *        a consumer that will call methods on {@link GaugeChartOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gaugeChartOptions(GaugeChartOptions)
         */
        default Builder gaugeChartOptions(Consumer<GaugeChartOptions.Builder> gaugeChartOptions) {
            return gaugeChartOptions(GaugeChartOptions.builder().applyMutation(gaugeChartOptions).build());
        }

        /**
         * <p>
         * The data label configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param dataLabels
         *        The data label configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The data label configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The tooltip configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param tooltipOptions
         *        The tooltip configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltipOptions(TooltipOptions tooltipOptions);

        /**
         * <p>
         * The tooltip configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltipOptions(TooltipOptions)}.
         * 
         * @param tooltipOptions
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltipOptions(TooltipOptions)
         */
        default Builder tooltipOptions(Consumer<TooltipOptions.Builder> tooltipOptions) {
            return tooltipOptions(TooltipOptions.builder().applyMutation(tooltipOptions).build());
        }

        /**
         * <p>
         * The visual palette configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param visualPalette
         *        The visual palette configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The visual palette configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GaugeChartFieldWells fieldWells;

        private GaugeChartOptions gaugeChartOptions;

        private DataLabelOptions dataLabels;

        private TooltipOptions tooltipOptions;

        private VisualPalette visualPalette;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(GaugeChartConfiguration model) {
            fieldWells(model.fieldWells);
            gaugeChartOptions(model.gaugeChartOptions);
            dataLabels(model.dataLabels);
            tooltipOptions(model.tooltipOptions);
            visualPalette(model.visualPalette);
            interactions(model.interactions);
        }

        public final GaugeChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(GaugeChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(GaugeChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final GaugeChartOptions.Builder getGaugeChartOptions() {
            return gaugeChartOptions != null ? gaugeChartOptions.toBuilder() : null;
        }

        public final void setGaugeChartOptions(GaugeChartOptions.BuilderImpl gaugeChartOptions) {
            this.gaugeChartOptions = gaugeChartOptions != null ? gaugeChartOptions.build() : null;
        }

        @Override
        public final Builder gaugeChartOptions(GaugeChartOptions gaugeChartOptions) {
            this.gaugeChartOptions = gaugeChartOptions;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltipOptions() {
            return tooltipOptions != null ? tooltipOptions.toBuilder() : null;
        }

        public final void setTooltipOptions(TooltipOptions.BuilderImpl tooltipOptions) {
            this.tooltipOptions = tooltipOptions != null ? tooltipOptions.build() : null;
        }

        @Override
        public final Builder tooltipOptions(TooltipOptions tooltipOptions) {
            this.tooltipOptions = tooltipOptions;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public GaugeChartConfiguration build() {
            return new GaugeChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
