/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FolderSummary;
import software.amazon.awssdk.services.quicksight.model.ListFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersResponse;

public class ListFoldersPublisher
implements SdkPublisher<ListFoldersResponse> {
    private final QuickSightAsyncClient client;
    private final ListFoldersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFoldersPublisher(QuickSightAsyncClient client, ListFoldersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFoldersPublisher(QuickSightAsyncClient client, ListFoldersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFoldersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFoldersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FolderSummary> folderSummaryList() {
        Function<ListFoldersResponse, Iterator> getIterator = response -> {
            if (response != null && response.folderSummaryList() != null) {
                return response.folderSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFoldersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFoldersResponseFetcher
    implements AsyncPageFetcher<ListFoldersResponse> {
        private ListFoldersResponseFetcher() {
        }

        public boolean hasNextPage(ListFoldersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFoldersResponse> nextPage(ListFoldersResponse previousPage) {
            if (previousPage == null) {
                return ListFoldersPublisher.this.client.listFolders(ListFoldersPublisher.this.firstRequest);
            }
            return ListFoldersPublisher.this.client.listFolders((ListFoldersRequest)((Object)ListFoldersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

