/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The link configuration of a table field URL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableFieldLinkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TableFieldLinkConfiguration.Builder, TableFieldLinkConfiguration> {
    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(TableFieldLinkConfiguration::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<TableFieldLinkContentConfiguration> CONTENT_FIELD = SdkField
            .<TableFieldLinkContentConfiguration> builder(MarshallingType.SDK_POJO).memberName("Content")
            .getter(getter(TableFieldLinkConfiguration::content)).setter(setter(Builder::content))
            .constructor(TableFieldLinkContentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String target;

    private final TableFieldLinkContentConfiguration content;

    private TableFieldLinkConfiguration(BuilderImpl builder) {
        this.target = builder.target;
        this.content = builder.content;
    }

    /**
     * <p>
     * The URL target (new tab, new window, same tab) for the table link configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link URLTargetConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetAsString}.
     * </p>
     * 
     * @return The URL target (new tab, new window, same tab) for the table link configuration.
     * @see URLTargetConfiguration
     */
    public final URLTargetConfiguration target() {
        return URLTargetConfiguration.fromValue(target);
    }

    /**
     * <p>
     * The URL target (new tab, new window, same tab) for the table link configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link URLTargetConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetAsString}.
     * </p>
     * 
     * @return The URL target (new tab, new window, same tab) for the table link configuration.
     * @see URLTargetConfiguration
     */
    public final String targetAsString() {
        return target;
    }

    /**
     * <p>
     * The URL content (text, icon) for the table link configuration.
     * </p>
     * 
     * @return The URL content (text, icon) for the table link configuration.
     */
    public final TableFieldLinkContentConfiguration content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldLinkConfiguration)) {
            return false;
        }
        TableFieldLinkConfiguration other = (TableFieldLinkConfiguration) obj;
        return Objects.equals(targetAsString(), other.targetAsString()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableFieldLinkConfiguration").add("Target", targetAsString()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableFieldLinkConfiguration, T> g) {
        return obj -> g.apply((TableFieldLinkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableFieldLinkConfiguration> {
        /**
         * <p>
         * The URL target (new tab, new window, same tab) for the table link configuration.
         * </p>
         * 
         * @param target
         *        The URL target (new tab, new window, same tab) for the table link configuration.
         * @see URLTargetConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see URLTargetConfiguration
         */
        Builder target(String target);

        /**
         * <p>
         * The URL target (new tab, new window, same tab) for the table link configuration.
         * </p>
         * 
         * @param target
         *        The URL target (new tab, new window, same tab) for the table link configuration.
         * @see URLTargetConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see URLTargetConfiguration
         */
        Builder target(URLTargetConfiguration target);

        /**
         * <p>
         * The URL content (text, icon) for the table link configuration.
         * </p>
         * 
         * @param content
         *        The URL content (text, icon) for the table link configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(TableFieldLinkContentConfiguration content);

        /**
         * <p>
         * The URL content (text, icon) for the table link configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TableFieldLinkContentConfiguration.Builder} avoiding the need to create one manually via
         * {@link TableFieldLinkContentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableFieldLinkContentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #content(TableFieldLinkContentConfiguration)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link TableFieldLinkContentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(TableFieldLinkContentConfiguration)
         */
        default Builder content(Consumer<TableFieldLinkContentConfiguration.Builder> content) {
            return content(TableFieldLinkContentConfiguration.builder().applyMutation(content).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String target;

        private TableFieldLinkContentConfiguration content;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldLinkConfiguration model) {
            target(model.target);
            content(model.content);
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(URLTargetConfiguration target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final TableFieldLinkContentConfiguration.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(TableFieldLinkContentConfiguration.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(TableFieldLinkContentConfiguration content) {
            this.content = content;
            return this;
        }

        @Override
        public TableFieldLinkConfiguration build() {
            return new TableFieldLinkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
