/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The general configuration of a column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnConfiguration.Builder, ColumnConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(ColumnConfiguration::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<FormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField
            .<FormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("FormatConfiguration")
            .getter(getter(ColumnConfiguration::formatConfiguration)).setter(setter(Builder::formatConfiguration))
            .constructor(FormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(ColumnConfiguration::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD,
            FORMAT_CONFIGURATION_FIELD, ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier column;

    private final FormatConfiguration formatConfiguration;

    private final String role;

    private ColumnConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.formatConfiguration = builder.formatConfiguration;
        this.role = builder.role;
    }

    /**
     * <p>
     * The column.
     * </p>
     * 
     * @return The column.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The format configuration of a column.
     * </p>
     * 
     * @return The format configuration of a column.
     */
    public final FormatConfiguration formatConfiguration() {
        return formatConfiguration;
    }

    /**
     * <p>
     * The role of the column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link ColumnRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the column.
     * @see ColumnRole
     */
    public final ColumnRole role() {
        return ColumnRole.fromValue(role);
    }

    /**
     * <p>
     * The role of the column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link ColumnRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the column.
     * @see ColumnRole
     */
    public final String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(formatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnConfiguration)) {
            return false;
        }
        ColumnConfiguration other = (ColumnConfiguration) obj;
        return Objects.equals(column(), other.column()) && Objects.equals(formatConfiguration(), other.formatConfiguration())
                && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnConfiguration").add("Column", column()).add("FormatConfiguration", formatConfiguration())
                .add("Role", roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "FormatConfiguration":
            return Optional.ofNullable(clazz.cast(formatConfiguration()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnConfiguration, T> g) {
        return obj -> g.apply((ColumnConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnConfiguration> {
        /**
         * <p>
         * The column.
         * </p>
         * 
         * @param column
         *        The column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The format configuration of a column.
         * </p>
         * 
         * @param formatConfiguration
         *        The format configuration of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatConfiguration(FormatConfiguration formatConfiguration);

        /**
         * <p>
         * The format configuration of a column.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormatConfiguration.Builder} avoiding the
         * need to create one manually via {@link FormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormatConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #formatConfiguration(FormatConfiguration)}.
         * 
         * @param formatConfiguration
         *        a consumer that will call methods on {@link FormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatConfiguration(FormatConfiguration)
         */
        default Builder formatConfiguration(Consumer<FormatConfiguration.Builder> formatConfiguration) {
            return formatConfiguration(FormatConfiguration.builder().applyMutation(formatConfiguration).build());
        }

        /**
         * <p>
         * The role of the column.
         * </p>
         * 
         * @param role
         *        The role of the column.
         * @see ColumnRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnRole
         */
        Builder role(String role);

        /**
         * <p>
         * The role of the column.
         * </p>
         * 
         * @param role
         *        The role of the column.
         * @see ColumnRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnRole
         */
        Builder role(ColumnRole role);
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier column;

        private FormatConfiguration formatConfiguration;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnConfiguration model) {
            column(model.column);
            formatConfiguration(model.formatConfiguration);
            role(model.role);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final FormatConfiguration.Builder getFormatConfiguration() {
            return formatConfiguration != null ? formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(FormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(FormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(ColumnRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public ColumnConfiguration build() {
            return new ColumnConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
