/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisLabelReferenceOptions;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AxisLabelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AxisLabelOptions> {
    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontConfiguration").getter(AxisLabelOptions.getter(AxisLabelOptions::fontConfiguration)).setter(AxisLabelOptions.setter(Builder::fontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()}).build();
    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLabel").getter(AxisLabelOptions.getter(AxisLabelOptions::customLabel)).setter(AxisLabelOptions.setter(Builder::customLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()}).build();
    private static final SdkField<AxisLabelReferenceOptions> APPLY_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplyTo").getter(AxisLabelOptions.getter(AxisLabelOptions::applyTo)).setter(AxisLabelOptions.setter(Builder::applyTo)).constructor(AxisLabelReferenceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyTo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_CONFIGURATION_FIELD, CUSTOM_LABEL_FIELD, APPLY_TO_FIELD));
    private static final long serialVersionUID = 1L;
    private final FontConfiguration fontConfiguration;
    private final String customLabel;
    private final AxisLabelReferenceOptions applyTo;

    private AxisLabelOptions(BuilderImpl builder) {
        this.fontConfiguration = builder.fontConfiguration;
        this.customLabel = builder.customLabel;
        this.applyTo = builder.applyTo;
    }

    public final FontConfiguration fontConfiguration() {
        return this.fontConfiguration;
    }

    public final String customLabel() {
        return this.customLabel;
    }

    public final AxisLabelReferenceOptions applyTo() {
        return this.applyTo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyTo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisLabelOptions)) {
            return false;
        }
        AxisLabelOptions other = (AxisLabelOptions)obj;
        return Objects.equals(this.fontConfiguration(), other.fontConfiguration()) && Objects.equals(this.customLabel(), other.customLabel()) && Objects.equals(this.applyTo(), other.applyTo());
    }

    public final String toString() {
        return ToString.builder((String)"AxisLabelOptions").add("FontConfiguration", (Object)this.fontConfiguration()).add("CustomLabel", (Object)this.customLabel()).add("ApplyTo", (Object)this.applyTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fontConfiguration()));
            }
            case "CustomLabel": {
                return Optional.ofNullable(clazz.cast(this.customLabel()));
            }
            case "ApplyTo": {
                return Optional.ofNullable(clazz.cast(this.applyTo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AxisLabelOptions, T> g) {
        return obj -> g.apply((AxisLabelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FontConfiguration fontConfiguration;
        private String customLabel;
        private AxisLabelReferenceOptions applyTo;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisLabelOptions model) {
            this.fontConfiguration(model.fontConfiguration);
            this.customLabel(model.customLabel);
            this.applyTo(model.applyTo);
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return this.fontConfiguration != null ? this.fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getCustomLabel() {
            return this.customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final AxisLabelReferenceOptions.Builder getApplyTo() {
            return this.applyTo != null ? this.applyTo.toBuilder() : null;
        }

        public final void setApplyTo(AxisLabelReferenceOptions.BuilderImpl applyTo) {
            this.applyTo = applyTo != null ? applyTo.build() : null;
        }

        @Override
        public final Builder applyTo(AxisLabelReferenceOptions applyTo) {
            this.applyTo = applyTo;
            return this;
        }

        public AxisLabelOptions build() {
            return new AxisLabelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AxisLabelOptions> {
        public Builder fontConfiguration(FontConfiguration var1);

        default public Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return this.fontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(fontConfiguration)).build());
        }

        public Builder customLabel(String var1);

        public Builder applyTo(AxisLabelReferenceOptions var1);

        default public Builder applyTo(Consumer<AxisLabelReferenceOptions.Builder> applyTo) {
            return this.applyTo((AxisLabelReferenceOptions)((AxisLabelReferenceOptions.Builder)AxisLabelReferenceOptions.builder().applyMutation(applyTo)).build());
        }
    }
}

