/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisDefinition;
import software.amazon.awssdk.services.quicksight.model.AnalysisError;
import software.amazon.awssdk.services.quicksight.model.AnalysisErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnalysisDefinitionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeAnalysisDefinitionResponse> {
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::analysisId)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::name)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<AnalysisError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::errors)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatus").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::resourceStatusAsString)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::resourceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeArn").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::themeArn)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<AnalysisDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::definition)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::definition)).constructor(AnalysisDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::status)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeAnalysisDefinitionResponse.getter(DescribeAnalysisDefinitionResponse::requestId)).setter(DescribeAnalysisDefinitionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_ID_FIELD, NAME_FIELD, ERRORS_FIELD, RESOURCE_STATUS_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final String analysisId;
    private final String name;
    private final List<AnalysisError> errors;
    private final String resourceStatus;
    private final String themeArn;
    private final AnalysisDefinition definition;
    private final Integer status;
    private final String requestId;

    private DescribeAnalysisDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.analysisId = builder.analysisId;
        this.name = builder.name;
        this.errors = builder.errors;
        this.resourceStatus = builder.resourceStatus;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<AnalysisError> errors() {
        return this.errors;
    }

    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public final String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public final String themeArn() {
        return this.themeArn;
    }

    public final AnalysisDefinition definition() {
        return this.definition;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisDefinitionResponse)) {
            return false;
        }
        DescribeAnalysisDefinitionResponse other = (DescribeAnalysisDefinitionResponse)((Object)obj);
        return Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.name(), other.name()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.themeArn(), other.themeArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAnalysisDefinitionResponse").add("AnalysisId", (Object)this.analysisId()).add("Name", (Object)this.name()).add("Errors", this.hasErrors() ? this.errors() : null).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ThemeArn", (Object)this.themeArn()).add("Definition", (Object)this.definition()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "ResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusAsString()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnalysisDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeAnalysisDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String analysisId;
        private String name;
        private List<AnalysisError> errors = DefaultSdkAutoConstructList.getInstance();
        private String resourceStatus;
        private String themeArn;
        private AnalysisDefinition definition;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisDefinitionResponse model) {
            super(model);
            this.analysisId(model.analysisId);
            this.name(model.name);
            this.errors(model.errors);
            this.resourceStatus(model.resourceStatus);
            this.themeArn(model.themeArn);
            this.definition(model.definition);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AnalysisError.Builder> getErrors() {
            List<AnalysisError.Builder> result = AnalysisErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AnalysisError.BuilderImpl> errors) {
            this.errors = AnalysisErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AnalysisError> errors) {
            this.errors = AnalysisErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AnalysisError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AnalysisError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AnalysisError)((AnalysisError.Builder)AnalysisError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final AnalysisDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(AnalysisDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(AnalysisDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeAnalysisDefinitionResponse build() {
            return new DescribeAnalysisDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnalysisDefinitionResponse> {
        public Builder analysisId(String var1);

        public Builder name(String var1);

        public Builder errors(Collection<AnalysisError> var1);

        public Builder errors(AnalysisError ... var1);

        public Builder errors(Consumer<AnalysisError.Builder> ... var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder themeArn(String var1);

        public Builder definition(AnalysisDefinition var1);

        default public Builder definition(Consumer<AnalysisDefinition.Builder> definition) {
            return this.definition((AnalysisDefinition)((AnalysisDefinition.Builder)AnalysisDefinition.builder().applyMutation(definition)).build());
        }

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

