/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.AssignmentStatus;
import software.amazon.awssdk.services.quicksight.model.IdentityMapCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIamPolicyAssignmentResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateIamPolicyAssignmentResponse> {
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentName").getter(UpdateIamPolicyAssignmentResponse.getter(UpdateIamPolicyAssignmentResponse::assignmentName)).setter(UpdateIamPolicyAssignmentResponse.setter(Builder::assignmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()}).build();
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentId").getter(UpdateIamPolicyAssignmentResponse.getter(UpdateIamPolicyAssignmentResponse::assignmentId)).setter(UpdateIamPolicyAssignmentResponse.setter(Builder::assignmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(UpdateIamPolicyAssignmentResponse.getter(UpdateIamPolicyAssignmentResponse::policyArn)).setter(UpdateIamPolicyAssignmentResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Identities").getter(UpdateIamPolicyAssignmentResponse.getter(UpdateIamPolicyAssignmentResponse::identities)).setter(UpdateIamPolicyAssignmentResponse.setter(Builder::identities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentStatus").getter(UpdateIamPolicyAssignmentResponse.getter(UpdateIamPolicyAssignmentResponse::assignmentStatusAsString)).setter(UpdateIamPolicyAssignmentResponse.setter(Builder::assignmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateIamPolicyAssignmentResponse.getter(UpdateIamPolicyAssignmentResponse::requestId)).setter(UpdateIamPolicyAssignmentResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateIamPolicyAssignmentResponse.getter(UpdateIamPolicyAssignmentResponse::status)).setter(UpdateIamPolicyAssignmentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_NAME_FIELD, ASSIGNMENT_ID_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD, ASSIGNMENT_STATUS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String assignmentName;
    private final String assignmentId;
    private final String policyArn;
    private final Map<String, List<String>> identities;
    private final String assignmentStatus;
    private final String requestId;
    private final Integer status;

    private UpdateIamPolicyAssignmentResponse(BuilderImpl builder) {
        super(builder);
        this.assignmentName = builder.assignmentName;
        this.assignmentId = builder.assignmentId;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
        this.assignmentStatus = builder.assignmentStatus;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String assignmentName() {
        return this.assignmentName;
    }

    public final String assignmentId() {
        return this.assignmentId;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final boolean hasIdentities() {
        return this.identities != null && !(this.identities instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> identities() {
        return this.identities;
    }

    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(this.assignmentStatus);
    }

    public final String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentities() ? this.identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIamPolicyAssignmentResponse)) {
            return false;
        }
        UpdateIamPolicyAssignmentResponse other = (UpdateIamPolicyAssignmentResponse)((Object)obj);
        return Objects.equals(this.assignmentName(), other.assignmentName()) && Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.policyArn(), other.policyArn()) && this.hasIdentities() == other.hasIdentities() && Objects.equals(this.identities(), other.identities()) && Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIamPolicyAssignmentResponse").add("AssignmentName", (Object)this.assignmentName()).add("AssignmentId", (Object)this.assignmentId()).add("PolicyArn", (Object)this.policyArn()).add("Identities", this.hasIdentities() ? this.identities() : null).add("AssignmentStatus", (Object)this.assignmentStatusAsString()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentName": {
                return Optional.ofNullable(clazz.cast(this.assignmentName()));
            }
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "Identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIamPolicyAssignmentResponse, T> g) {
        return obj -> g.apply((UpdateIamPolicyAssignmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String assignmentName;
        private String assignmentId;
        private String policyArn;
        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();
        private String assignmentStatus;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIamPolicyAssignmentResponse model) {
            super(model);
            this.assignmentName(model.assignmentName);
            this.assignmentId(model.assignmentId);
            this.policyArn(model.policyArn);
            this.identities(model.identities);
            this.assignmentStatus(model.assignmentStatus);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getAssignmentName() {
            return this.assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (this.identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.identities;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateIamPolicyAssignmentResponse build() {
            return new UpdateIamPolicyAssignmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIamPolicyAssignmentResponse> {
        public Builder assignmentName(String var1);

        public Builder assignmentId(String var1);

        public Builder policyArn(String var1);

        public Builder identities(Map<String, ? extends Collection<String>> var1);

        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatus var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

