/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.KPIPrimaryValueConditionalFormatting;
import software.amazon.awssdk.services.quicksight.model.KPIProgressBarConditionalFormatting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KPIConditionalFormattingOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KPIConditionalFormattingOption> {
    private static final SdkField<KPIPrimaryValueConditionalFormatting> PRIMARY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryValue").getter(KPIConditionalFormattingOption.getter(KPIConditionalFormattingOption::primaryValue)).setter(KPIConditionalFormattingOption.setter(Builder::primaryValue)).constructor(KPIPrimaryValueConditionalFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValue").build()}).build();
    private static final SdkField<KPIProgressBarConditionalFormatting> PROGRESS_BAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressBar").getter(KPIConditionalFormattingOption.getter(KPIConditionalFormattingOption::progressBar)).setter(KPIConditionalFormattingOption.setter(Builder::progressBar)).constructor(KPIProgressBarConditionalFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressBar").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_VALUE_FIELD, PROGRESS_BAR_FIELD));
    private static final long serialVersionUID = 1L;
    private final KPIPrimaryValueConditionalFormatting primaryValue;
    private final KPIProgressBarConditionalFormatting progressBar;

    private KPIConditionalFormattingOption(BuilderImpl builder) {
        this.primaryValue = builder.primaryValue;
        this.progressBar = builder.progressBar;
    }

    public final KPIPrimaryValueConditionalFormatting primaryValue() {
        return this.primaryValue;
    }

    public final KPIProgressBarConditionalFormatting progressBar() {
        return this.progressBar;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressBar());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIConditionalFormattingOption)) {
            return false;
        }
        KPIConditionalFormattingOption other = (KPIConditionalFormattingOption)obj;
        return Objects.equals(this.primaryValue(), other.primaryValue()) && Objects.equals(this.progressBar(), other.progressBar());
    }

    public final String toString() {
        return ToString.builder((String)"KPIConditionalFormattingOption").add("PrimaryValue", (Object)this.primaryValue()).add("ProgressBar", (Object)this.progressBar()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryValue": {
                return Optional.ofNullable(clazz.cast(this.primaryValue()));
            }
            case "ProgressBar": {
                return Optional.ofNullable(clazz.cast(this.progressBar()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KPIConditionalFormattingOption, T> g) {
        return obj -> g.apply((KPIConditionalFormattingOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KPIPrimaryValueConditionalFormatting primaryValue;
        private KPIProgressBarConditionalFormatting progressBar;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIConditionalFormattingOption model) {
            this.primaryValue(model.primaryValue);
            this.progressBar(model.progressBar);
        }

        public final KPIPrimaryValueConditionalFormatting.Builder getPrimaryValue() {
            return this.primaryValue != null ? this.primaryValue.toBuilder() : null;
        }

        public final void setPrimaryValue(KPIPrimaryValueConditionalFormatting.BuilderImpl primaryValue) {
            this.primaryValue = primaryValue != null ? primaryValue.build() : null;
        }

        @Override
        public final Builder primaryValue(KPIPrimaryValueConditionalFormatting primaryValue) {
            this.primaryValue = primaryValue;
            return this;
        }

        public final KPIProgressBarConditionalFormatting.Builder getProgressBar() {
            return this.progressBar != null ? this.progressBar.toBuilder() : null;
        }

        public final void setProgressBar(KPIProgressBarConditionalFormatting.BuilderImpl progressBar) {
            this.progressBar = progressBar != null ? progressBar.build() : null;
        }

        @Override
        public final Builder progressBar(KPIProgressBarConditionalFormatting progressBar) {
            this.progressBar = progressBar;
            return this;
        }

        public KPIConditionalFormattingOption build() {
            return new KPIConditionalFormattingOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KPIConditionalFormattingOption> {
        public Builder primaryValue(KPIPrimaryValueConditionalFormatting var1);

        default public Builder primaryValue(Consumer<KPIPrimaryValueConditionalFormatting.Builder> primaryValue) {
            return this.primaryValue((KPIPrimaryValueConditionalFormatting)((KPIPrimaryValueConditionalFormatting.Builder)KPIPrimaryValueConditionalFormatting.builder().applyMutation(primaryValue)).build());
        }

        public Builder progressBar(KPIProgressBarConditionalFormatting var1);

        default public Builder progressBar(Consumer<KPIProgressBarConditionalFormatting.Builder> progressBar) {
            return this.progressBar((KPIProgressBarConditionalFormatting)((KPIProgressBarConditionalFormatting.Builder)KPIProgressBarConditionalFormatting.builder().applyMutation(progressBar)).build());
        }
    }
}

